/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.util.PsiNavigateUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

class RecentTestsListPopup
extends ListPopupImpl {
    private final RecentTestRunner myTestRunner;

    public RecentTestsListPopup(ListPopupStep<String> popupStep, RecentTestRunner testRunner) {
        super(popupStep);
        this.myTestRunner = testRunner;
        this.shiftReleased();
        this.registerActions(this);
    }

    private void registerActions(ListPopupImpl popup) {
        popup.registerAction("alternate", KeyStroke.getKeyStroke("shift pressed SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentTestsListPopup.this.shiftPressed();
            }
        });
        popup.registerAction("restoreDefault", KeyStroke.getKeyStroke("released SHIFT"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentTestsListPopup.this.shiftReleased();
            }
        });
        popup.registerAction("invokeAction", KeyStroke.getKeyStroke("shift ENTER"), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RecentTestsListPopup.this.handleSelect(true);
            }
        });
        popup.registerAction("navigate", KeyStroke.getKeyStroke(115, 0), new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Location location;
                Object[] values = RecentTestsListPopup.this.getSelectedValues();
                if (values.length == 1 && (location = RecentTestsListPopup.this.myTestRunner.getLocation(values[0].toString())) != null) {
                    RecentTestsListPopup.this.cancel();
                    PsiNavigateUtil.navigate((PsiElement)location.getPsiElement());
                }
            }
        });
    }

    private void shiftPressed() {
        this.setCaption("Run Recent Tests");
        this.myTestRunner.setMode(RecentTestRunner.Mode.RUN);
    }

    private void shiftReleased() {
        this.setCaption("Debug Recent Tests");
        this.myTestRunner.setMode(RecentTestRunner.Mode.DEBUG);
    }
}

