/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.Location;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.TestIconMapper;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testIntegration.RecentTestRunner;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class SelectTestStep
extends BaseListPopupStep<String> {
    private static Comparator<String> TEST_BY_PATH_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            String path1 = VirtualFileManager.extractPath((String)o1);
            String path2 = VirtualFileManager.extractPath((String)o2);
            return path1.compareTo(path2);
        }
    };
    private final Map<String, TestStateStorage.Record> myRecords;
    private final RecentTestRunner myRunner;

    public SelectTestStep(Map<String, TestStateStorage.Record> records, RecentTestRunner runner) {
        super("Debug Recent Tests", SelectTestStep.getUrls(records, runner));
        this.myRunner = runner;
        this.myRecords = records;
    }

    private static List<String> getUrls(Map<String, TestStateStorage.Record> records, RecentTestRunner runner) {
        TestGroup groups = SelectTestStep.toTestGroups(records, runner);
        ArrayList failed = ContainerUtil.newArrayList(groups.failedTests);
        Collections.sort(failed, TEST_BY_PATH_COMPARATOR);
        ArrayList other = ContainerUtil.newArrayList(groups.otherTests);
        Collections.sort(other, TEST_BY_PATH_COMPARATOR);
        ArrayList passed = ContainerUtil.newArrayList(groups.passedTests);
        Collections.sort(passed, TEST_BY_PATH_COMPARATOR);
        failed.addAll(other);
        failed.addAll(passed);
        return failed;
    }

    private static TestGroup toTestGroups(Map<String, TestStateStorage.Record> records, RecentTestRunner runner) {
        HashSet failedTests = ContainerUtil.newHashSet();
        HashSet passedSuites = ContainerUtil.newHashSet();
        HashSet otherSuites = ContainerUtil.newHashSet();
        block5: for (Map.Entry<String, TestStateStorage.Record> item : records.entrySet()) {
            String url = item.getKey();
            TestStateInfo.Magnitude magnitude = SelectTestStep.getMagnitude(item.getValue().magnitude);
            if (magnitude == null) continue;
            switch (magnitude) {
                case COMPLETE_INDEX: {
                    if (!runner.isSuite(url)) continue block5;
                    passedSuites.add(url);
                    continue block5;
                }
                case PASSED_INDEX: {
                    if (!runner.isSuite(url)) continue block5;
                    passedSuites.add(url);
                    continue block5;
                }
                case ERROR_INDEX: {
                    failedTests.add(url);
                    continue block5;
                }
            }
            otherSuites.add(url);
        }
        return new TestGroup(failedTests, passedSuites, otherSuites);
    }

    private static TestStateInfo.Magnitude getMagnitude(int magnitude) {
        for (TestStateInfo.Magnitude m : TestStateInfo.Magnitude.values()) {
            if (m.getValue() != magnitude) continue;
            return m;
        }
        return null;
    }

    @NotNull
    public String getTextFor(String value) {
        String string = VirtualFileManager.extractPath((String)value);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testIntegration/SelectTestStep", "getTextFor"));
        }
        return string;
    }

    public boolean isSpeedSearchEnabled() {
        return true;
    }

    public Icon getIconFor(String value) {
        TestStateStorage.Record record = this.myRecords.get(value);
        TestStateInfo.Magnitude magnitude = TestIconMapper.getMagnitude((int)record.magnitude);
        return TestIconMapper.getIcon((TestStateInfo.Magnitude)magnitude);
    }

    public PopupStep onChosen(String url, boolean finalChoice) {
        Location location = this.myRunner.getLocation(url);
        this.myRunner.run(location);
        return null;
    }

    private static class TestGroup {
        public Set<String> failedTests;
        public Set<String> passedTests;
        public Set<String> otherTests;

        public TestGroup(Set<String> failedTests, Set<String> passedTests, Set<String> otherTests) {
            this.failedTests = failedTests;
            this.passedTests = passedTests;
            this.otherTests = otherTests;
        }
    }
}

