/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.testIntegration.RecentTestRunnerImpl;
import com.intellij.testIntegration.RecentTestsListPopup;
import com.intellij.testIntegration.SelectTestStep;
import java.util.Date;
import java.util.Map;

public class ShowRecentTests
extends AnAction {
    private static final int TEST_LIMIT = Integer.MAX_VALUE;

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        Map<String, TestStateStorage.Record> records = TestStateStorage.getInstance(project2).getRecentTests(Integer.MAX_VALUE, ShowRecentTests.getSinceDate());
        RecentTestRunnerImpl testRunner = new RecentTestRunnerImpl(project2);
        SelectTestStep selectStepTest = new SelectTestStep(records, testRunner);
        RecentTestsListPopup popup = new RecentTestsListPopup((ListPopupStep<String>)selectStepTest, testRunner);
        popup.showCenteredInCurrentWindow(project2);
    }
}

