/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.impl.ProjectLifecycleListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.ui.DeferredIconImpl;
import com.intellij.ui.IconDeferrer;
import com.intellij.util.Function;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class IconDeferrerImpl
extends IconDeferrer {
    private final Object LOCK = new Object();
    private final Map<Object, Icon> myIconsCache = new LinkedHashMap<Object, Icon>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, Icon> eldest) {
            return this.size() > 100;
        }
    };
    private long myLastClearTimestamp;
    private final LowMemoryWatcher myLowMemoryWatcher = LowMemoryWatcher.register((Runnable)new Runnable(){

        @Override
        public void run() {
            IconDeferrerImpl.this.clear();
        }
    });
    private static final ThreadLocal<Boolean> myEvaluationIsInProgress = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };

    public IconDeferrerImpl(MessageBus bus) {
        MessageBusConnection connection = bus.connect();
        connection.subscribe(PsiModificationTracker.TOPIC, (Object)new PsiModificationTracker.Listener(){

            public void modificationCountChanged() {
                IconDeferrerImpl.this.clear();
            }
        });
        connection.subscribe(ProjectLifecycleListener.TOPIC, (Object)new ProjectLifecycleListener.Adapter(){

            public void afterProjectClosed(@NotNull Project project2) {
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ui/IconDeferrerImpl$4", "afterProjectClosed"));
                }
                IconDeferrerImpl.this.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myIconsCache.clear();
            ++this.myLastClearTimestamp;
        }
    }

    public <T> Icon defer(Icon base, T param, @NotNull Function<T, Icon> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/IconDeferrerImpl", "defer"));
        }
        return this.deferImpl(base, param, evaluator, false);
    }

    public <T> Icon deferAutoUpdatable(Icon base, T param, @NotNull Function<T, Icon> evaluator) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/IconDeferrerImpl", "deferAutoUpdatable"));
        }
        return this.deferImpl(base, param, evaluator, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Icon deferImpl(Icon base, T param, @NotNull Function<T, Icon> evaluator, final boolean autoUpdatable) {
        if (evaluator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/ui/IconDeferrerImpl", "deferImpl"));
        }
        if (myEvaluationIsInProgress.get().booleanValue()) {
            return (Icon)evaluator.fun(param);
        }
        Object object = this.LOCK;
        synchronized (object) {
            Object result2 = this.myIconsCache.get(param);
            if (result2 == null) {
                final long started = this.myLastClearTimestamp;
                result2 = new DeferredIconImpl<T>(base, param, evaluator, new DeferredIconImpl.IconListener<T>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void evalDone(DeferredIconImpl<T> source, T key, @NotNull Icon r) {
                        if (r == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "com/intellij/ui/IconDeferrerImpl$5", "evalDone"));
                        }
                        Object object = IconDeferrerImpl.this.LOCK;
                        synchronized (object) {
                            if (started == IconDeferrerImpl.this.myLastClearTimestamp) {
                                IconDeferrerImpl.this.myIconsCache.put(key, autoUpdatable ? source : r);
                            }
                        }
                    }
                }, autoUpdatable);
                this.myIconsCache.put(param, (Icon)result2);
            }
            return result2;
        }
    }

    static void evaluateDeferred(@NotNull Runnable runnable2) {
        if (runnable2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/ui/IconDeferrerImpl", "evaluateDeferred"));
        }
        try {
            myEvaluationIsInProgress.set(Boolean.TRUE);
            runnable2.run();
        }
        finally {
            myEvaluationIsInProgress.set(Boolean.FALSE);
        }
    }

    public boolean equalIcons(Icon icon1, Icon icon2) {
        return DeferredIconImpl.equalIcons(icon1, icon2);
    }
}

