/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextFieldWithAutoCompletionContributor<T>
extends CompletionContributor
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ui.TextFieldWithAutoCompletionContributor");
    private static final Key<TextFieldWithAutoCompletionListProvider> KEY = Key.create((String)"text field simple completion available");
    private static final Key<Boolean> AUTO_POPUP_KEY = Key.create((String)"text Field simple completion auto-popup");

    public static <T> void installCompletion(Document document, Project project2, @Nullable TextFieldWithAutoCompletionListProvider<T> provider, boolean autoPopup) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
        if (psiFile != null) {
            psiFile.putUserData(KEY, provider == null ? TextFieldWithAutoCompletion.EMPTY_COMPLETION : provider);
            psiFile.putUserData(AUTO_POPUP_KEY, (Object)autoPopup);
        }
    }

    public void fillCompletionVariants(final @NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2) {
        String prefix;
        String shortcut;
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/ui/TextFieldWithAutoCompletionContributor", "fillCompletionVariants"));
        }
        if (result2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/ui/TextFieldWithAutoCompletionContributor", "fillCompletionVariants"));
        }
        PsiFile file2 = parameters.getOriginalFile();
        final TextFieldWithAutoCompletionListProvider provider = (TextFieldWithAutoCompletionListProvider)file2.getUserData(KEY);
        if (provider == null || DumbService.isDumb((Project)file2.getProject()) && !DumbService.isDumbAware((Object)provider)) {
            return;
        }
        String adv = provider.getAdvertisement();
        if (adv == null && (shortcut = TextFieldWithAutoCompletionContributor.getActionShortcut((String)"QuickJavaDoc")) != null) {
            adv = provider.getQuickDocHotKeyAdvertisement(shortcut);
        }
        if (adv != null) {
            result2.addLookupAdvertisement(adv);
        }
        if ((prefix = provider.getPrefix(parameters)) == null) {
            return;
        }
        if (parameters.getInvocationCount() == 0 && !((Boolean)file2.getUserData(AUTO_POPUP_KEY)).booleanValue()) {
            return;
        }
        PrefixMatcher prefixMatcher = provider.createPrefixMatcher(prefix);
        if (prefixMatcher != null) {
            result2 = result2.withPrefixMatcher(prefixMatcher);
        }
        Collection items = provider.getItems(prefix, true, parameters);
        TextFieldWithAutoCompletionContributor.addCompletionElements(result2, provider, items, -10000);
        final ProgressManager progressManager = ProgressManager.getInstance();
        ProgressIndicator mainIndicator = progressManager.getProgressIndicator();
        final SensitiveProgressWrapper indicator = mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new EmptyProgressIndicator();
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(new Callable<Collection<T>>(){

            @Override
            public Collection<T> call() {
                return (Collection)progressManager.runProcess(new Computable<Collection<T>>(){

                    public Collection<T> compute() {
                        return provider.getItems(prefix, false, parameters);
                    }
                }, indicator);
            }
        });
        while (true) {
            try {
                Collection tasks = (Collection)future2.get(100L, TimeUnit.MILLISECONDS);
                if (tasks != null) {
                    TextFieldWithAutoCompletionContributor.addCompletionElements(result2, provider, tasks, 0);
                    return;
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ProgressManager.checkCanceled();
        }
    }

    private static <T> void addCompletionElements(CompletionResultSet result2, TextFieldWithAutoCompletionListProvider<T> listProvider, Collection<T> items, int index) {
        AutoCompletionPolicy completionPolicy = ApplicationManager.getApplication().isUnitTestMode() ? AutoCompletionPolicy.ALWAYS_AUTOCOMPLETE : AutoCompletionPolicy.NEVER_AUTOCOMPLETE;
        int grouping = index;
        for (T item : items) {
            if (item == null) {
                LOG.error("Null item from " + listProvider);
                continue;
            }
            LookupElementBuilder builder = listProvider.createLookupBuilder(item);
            result2.addElement(PrioritizedLookupElement.withGrouping((LookupElement)builder.withAutoCompletionPolicy(completionPolicy), (int)grouping--));
        }
    }
}

