/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.ui.popup.ComponentPopupBuilder;
import com.intellij.openapi.ui.popup.IconButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.MaskProvider;
import com.intellij.openapi.ui.popup.MouseChecker;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.util.BooleanFunction;
import com.intellij.util.Processor;
import com.intellij.util.ui.EmptyIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComponentPopupBuilderImpl
implements ComponentPopupBuilder {
    private String myTitle;
    private boolean myResizable;
    private boolean myMovable;
    private final JComponent myComponent;
    private final JComponent myPreferredFocusedComponent;
    private boolean myRequestFocus;
    private String myDimensionServiceKey;
    private Computable<Boolean> myCallback;
    private Project myProject;
    private boolean myCancelOnClickOutside;
    private boolean myCancelOnWindowDeactivation;
    private final Set<JBPopupListener> myListeners;
    private boolean myUseDimServiceForXYLocation;
    private IconButton myCancelButton;
    private MouseChecker myCancelOnMouseOutCallback;
    private boolean myCancelOnWindow;
    private ActiveIcon myTitleIcon;
    private boolean myCancelKeyEnabled;
    private boolean myLocateByContent;
    private boolean myPlaceWithinScreen;
    private Processor<JBPopup> myPinCallback;
    private Dimension myMinSize;
    private MaskProvider myMaskProvider;
    private float myAlpha;
    private List<Object> myUserData;
    private boolean myInStack;
    private boolean myModalContext;
    private Component[] myFocusOwners;
    private String myAd;
    private boolean myShowShadow;
    private boolean myShowBorder;
    private boolean myFocusable;
    private ActiveComponent myCommandButton;
    private List<Pair<ActionListener, KeyStroke>> myKeyboardActions;
    private Component mySettingsButtons;
    private boolean myMayBeParent;
    private int myAdAlignment;
    private BooleanFunction<KeyEvent> myKeyEventHandler;

    public ComponentPopupBuilderImpl(@NotNull JComponent component, JComponent preferredFocusedComponent) {
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "<init>"));
        }
        this.myTitle = "";
        this.myDimensionServiceKey = null;
        this.myCallback = null;
        this.myCancelOnClickOutside = true;
        this.myCancelOnWindowDeactivation = true;
        this.myListeners = new LinkedHashSet<JBPopupListener>();
        this.myTitleIcon = new ActiveIcon(EmptyIcon.ICON_0);
        this.myCancelKeyEnabled = true;
        this.myLocateByContent = false;
        this.myPlaceWithinScreen = true;
        this.myPinCallback = null;
        this.myInStack = true;
        this.myModalContext = true;
        this.myFocusOwners = new Component[0];
        this.myShowShadow = true;
        this.myShowBorder = true;
        this.myFocusable = true;
        this.myKeyboardActions = Collections.emptyList();
        this.myAdAlignment = 2;
        this.myComponent = component;
        this.myPreferredFocusedComponent = preferredFocusedComponent;
    }

    @NotNull
    public ComponentPopupBuilder setMayBeParent(boolean mayBeParent) {
        this.myMayBeParent = mayBeParent;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setMayBeParent"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setTitle(String title) {
        this.myTitle = title;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setTitle"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setResizable(boolean resizable) {
        this.myResizable = resizable;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setResizable"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setMovable(boolean movable) {
        this.myMovable = movable;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setMovable"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnClickOutside(boolean cancel) {
        this.myCancelOnClickOutside = cancel;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelOnClickOutside"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnMouseOutCallback(MouseChecker shouldCancel) {
        this.myCancelOnMouseOutCallback = shouldCancel;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelOnMouseOutCallback"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder addListener(JBPopupListener listener) {
        this.myListeners.add(listener);
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "addListener"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setRequestFocus(boolean requestFocus) {
        this.myRequestFocus = requestFocus;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setRequestFocus"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setFocusable(boolean focusable) {
        this.myFocusable = focusable;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setFocusable"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setDimensionServiceKey(Project project2, String key, boolean useForXYLocation) {
        this.myDimensionServiceKey = key;
        this.myUseDimServiceForXYLocation = useForXYLocation;
        this.myProject = project2;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setDimensionServiceKey"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelCallback(Computable<Boolean> shouldProceed) {
        this.myCallback = shouldProceed;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelCallback"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelButton(@NotNull IconButton cancelButton) {
        if (cancelButton == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelButton", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelButton"));
        }
        this.myCancelButton = cancelButton;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelButton"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCommandButton(@NotNull ActiveComponent button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCommandButton"));
        }
        this.myCommandButton = button;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCommandButton"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCouldPin(@Nullable Processor<JBPopup> callback) {
        this.myPinCallback = callback;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCouldPin"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setKeyboardActions(@NotNull List<Pair<ActionListener, KeyStroke>> keyboardActions) {
        if (keyboardActions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyboardActions", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setKeyboardActions"));
        }
        this.myKeyboardActions = keyboardActions;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setKeyboardActions"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setSettingButtons(@NotNull Component button) {
        if (button == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "button", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setSettingButtons"));
        }
        this.mySettingsButtons = button;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setSettingButtons"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelOnOtherWindowOpen(boolean cancelOnWindow) {
        this.myCancelOnWindow = cancelOnWindow;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelOnOtherWindowOpen"));
        }
        return componentPopupBuilderImpl;
    }

    public ComponentPopupBuilder setCancelOnWindowDeactivation(boolean cancelOnWindowDeactivation) {
        this.myCancelOnWindowDeactivation = cancelOnWindowDeactivation;
        return this;
    }

    @NotNull
    public ComponentPopupBuilder setKeyEventHandler(@NotNull BooleanFunction<KeyEvent> handler2) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setKeyEventHandler"));
        }
        this.myKeyEventHandler = handler2;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setKeyEventHandler"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setProject(Project project2) {
        this.myProject = project2;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setProject"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public JBPopup createPopup() {
        AbstractPopup popup = new AbstractPopup().init(this.myProject, this.myComponent, this.myPreferredFocusedComponent, this.myRequestFocus, this.myFocusable, this.myMovable, this.myDimensionServiceKey, this.myResizable, this.myTitle, this.myCallback, this.myCancelOnClickOutside, this.myListeners, this.myUseDimServiceForXYLocation, this.myCommandButton, this.myCancelButton, this.myCancelOnMouseOutCallback, this.myCancelOnWindow, this.myTitleIcon, this.myCancelKeyEnabled, this.myLocateByContent, this.myPlaceWithinScreen, this.myMinSize, this.myAlpha, this.myMaskProvider, this.myInStack, this.myModalContext, this.myFocusOwners, this.myAd, this.myAdAlignment, false, this.myKeyboardActions, this.mySettingsButtons, this.myPinCallback, this.myMayBeParent, this.myShowShadow, this.myShowBorder, this.myCancelOnWindowDeactivation, this.myKeyEventHandler);
        if (this.myUserData != null) {
            popup.setUserData(this.myUserData);
        }
        Disposer.register((Disposable)ApplicationManager.getApplication(), (Disposable)popup);
        AbstractPopup abstractPopup = popup;
        if (abstractPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "createPopup"));
        }
        return abstractPopup;
    }

    @NotNull
    public ComponentPopupBuilder setRequestFocusCondition(Project project2, Condition<Project> condition) {
        this.myRequestFocus = condition.value((Object)project2);
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setRequestFocusCondition"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setTitleIcon(@NotNull ActiveIcon icon) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setTitleIcon"));
        }
        this.myTitleIcon = icon;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setTitleIcon"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setCancelKeyEnabled(boolean enabled) {
        this.myCancelKeyEnabled = enabled;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setCancelKeyEnabled"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setLocateByContent(boolean byContent) {
        this.myLocateByContent = byContent;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setLocateByContent"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setLocateWithinScreenBounds(boolean within) {
        this.myPlaceWithinScreen = within;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setLocateWithinScreenBounds"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setMinSize(Dimension minSize) {
        this.myMinSize = minSize;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setMinSize"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setMaskProvider(MaskProvider maskProvider) {
        this.myMaskProvider = maskProvider;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setMaskProvider"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setAlpha(float alpha) {
        this.myAlpha = alpha;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setAlpha"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setBelongsToGlobalPopupStack(boolean isInStack) {
        this.myInStack = isInStack;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setBelongsToGlobalPopupStack"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder addUserData(Object object) {
        if (this.myUserData == null) {
            this.myUserData = new ArrayList<Object>();
        }
        this.myUserData.add(object);
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "addUserData"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setModalContext(boolean modal) {
        this.myModalContext = modal;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setModalContext"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setFocusOwners(@NotNull Component[] focusOwners) {
        if (focusOwners == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "focusOwners", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setFocusOwners"));
        }
        this.myFocusOwners = focusOwners;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setFocusOwners"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setAdText(@Nullable String text) {
        ComponentPopupBuilder componentPopupBuilder = this.setAdText(text, 2);
        if (componentPopupBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setAdText"));
        }
        return componentPopupBuilder;
    }

    @NotNull
    public ComponentPopupBuilder setAdText(@Nullable String text, int textAlignment) {
        this.myAd = text;
        this.myAdAlignment = textAlignment;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setAdText"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setShowShadow(boolean show) {
        this.myShowShadow = show;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setShowShadow"));
        }
        return componentPopupBuilderImpl;
    }

    @NotNull
    public ComponentPopupBuilder setShowBorder(boolean show) {
        this.myShowBorder = show;
        ComponentPopupBuilderImpl componentPopupBuilderImpl = this;
        if (componentPopupBuilderImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/popup/ComponentPopupBuilderImpl", "setShowBorder"));
        }
        return componentPopupBuilderImpl;
    }
}

