/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.tree;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.PerFileMappings;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.ComboBoxAction;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.ui.tree.AbstractFileTreeTable;
import com.intellij.util.ui.tree.LanguagePerFileConfigurable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LanguagePerFileConfigurable<T>
implements SearchableConfigurable,
Configurable.NoScroll {
    protected final Project myProject;
    private final Class<T> myValueClass;
    private final PerFileMappings<T> myMappings;
    private final String myTreeTableTitle;
    private final String myOverrideQuestion;
    private final String myOverrideTitle;
    private AbstractFileTreeTable<T> myTreeView;
    private JScrollPane myTreePanel;
    private JPanel myPanel;
    private JLabel myLabel;

    protected LanguagePerFileConfigurable(@NotNull Project project2, Class<T> valueClass, PerFileMappings<T> mappings, String caption, String treeTableTitle, String overrideQuestion, String overrideTitle) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/util/ui/tree/LanguagePerFileConfigurable", "<init>"));
        }
        this.myProject = project2;
        this.myValueClass = valueClass;
        this.myMappings = mappings;
        this.myTreeTableTitle = treeTableTitle;
        this.myOverrideQuestion = overrideQuestion;
        this.myOverrideTitle = overrideTitle;
        this.$$$setupUI$$$();
        this.myLabel.setText(caption);
    }

    public JComponent createComponent() {
        this.myTreeView = new MyTreeTable();
        this.myTreePanel.setViewportView((Component)((Object)this.myTreeView));
        return this.myPanel;
    }

    @Nullable
    public T getNewMapping(VirtualFile file2) {
        Map<VirtualFile, T> values = this.myTreeView.getValues();
        for (VirtualFile cur = file2; cur != null; cur = cur.getParent()) {
            T t = values.get(cur);
            if (t == null) continue;
            return t;
        }
        T t = values.get(null);
        return (T)(t == null ? this.myMappings.getDefaultMapping(file2) : t);
    }

    public boolean isModified() {
        Map mapping = this.myMappings.getMappings();
        boolean same = this.myTreeView.getValues().equals(mapping);
        return !same;
    }

    public void apply() throws ConfigurationException {
        this.myMappings.setMappings(this.myTreeView.getValues());
    }

    public void reset() {
        this.myTreeView.reset(this.myMappings.getMappings());
    }

    public void disposeUIResources() {
    }

    public void selectFile(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/util/ui/tree/LanguagePerFileConfigurable", "selectFile"));
        }
        this.myTreeView.select(virtualFile instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile).getDelegate() : virtualFile);
    }

    private void createUIComponents() {
        this.myTreePanel = ScrollPaneFactory.createScrollPane((Component)new JBTable());
    }

    protected abstract String visualize(@NotNull T var1);

    public AbstractFileTreeTable<T> getTreeView() {
        return this.myTreeView;
    }

    @NotNull
    public String getId() {
        String string = this.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/tree/LanguagePerFileConfigurable", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    protected boolean handleDefaultValue(VirtualFile file2, ColoredTableCellRenderer renderer) {
        return false;
    }

    @Nullable
    protected Icon getIcon(T currentValue, T selectableValue) {
        return null;
    }

    protected boolean isDumbAware() {
        return true;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myLabel = jLabel = new JLabel();
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JScrollPane jScrollPane = this.myTreePanel;
        jPanel.add((Component)jScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 7, 7, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private abstract class ChooseSomethingAction
    extends ComboBoxAction {
        private final VirtualFile myVirtualFile;

        public ChooseSomethingAction(VirtualFile virtualFile) {
            this.myVirtualFile = virtualFile;
        }

        @NotNull
        protected DefaultActionGroup createPopupActionGroup(JComponent button) {
            DefaultActionGroup defaultActionGroup = this.createGroup(true);
            if (defaultActionGroup == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/ui/tree/LanguagePerFileConfigurable$ChooseSomethingAction", "createPopupActionGroup"));
            }
            return defaultActionGroup;
        }

        private com.intellij.util.ui.tree.LanguagePerFileConfigurable$ChooseSomethingAction.ChangeSomethingAction createChooseAction(VirtualFile virtualFile, T t) {
            return new ChangeSomethingAction(virtualFile, t){

                @Override
                protected void chosen(VirtualFile file2, T t) {
                    ChooseSomethingAction.this.chosen(file2, t);
                }
            };
        }

        protected abstract void chosen(VirtualFile var1, T var2);

        public DefaultActionGroup createGroup(boolean showClear) {
            DefaultActionGroup group = new DefaultActionGroup();
            if (showClear) {
                group.add((AnAction)this.createChooseAction(this.myVirtualFile, null));
            }
            ArrayList values = new ArrayList(LanguagePerFileConfigurable.this.myMappings.getAvailableValues(this.myVirtualFile));
            Collections.sort(values, new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return LanguagePerFileConfigurable.this.visualize(o1).compareTo(LanguagePerFileConfigurable.this.visualize(o2));
                }
            });
            for (Object t : values) {
                if (!LanguagePerFileConfigurable.this.myMappings.isSelectable(t)) continue;
                group.add((AnAction)this.createChooseAction(this.myVirtualFile, t));
            }
            return group;
        }

        private abstract class ChangeSomethingAction
        extends AnAction {
            private final VirtualFile myFile;
            private final T myDialect;

            ChangeSomethingAction(@Nullable VirtualFile file2, T t) {
                super("", "", null);
                Presentation presentation = this.getTemplatePresentation();
                presentation.setText(t == null ? "Clear" : LanguagePerFileConfigurable.this.visualize(t));
                presentation.setIcon(LanguagePerFileConfigurable.this.getIcon(LanguagePerFileConfigurable.this.myTreeView.getValues().get(file2), t));
                this.myFile = file2;
                this.myDialect = t;
            }

            public void actionPerformed(AnActionEvent e) {
                this.chosen(this.myFile, this.myDialect);
            }

            protected abstract void chosen(VirtualFile var1, T var2);

            public boolean isDumbAware() {
                return LanguagePerFileConfigurable.this.isDumbAware();
            }
        }
    }

    private class MyTreeTable
    extends AbstractFileTreeTable<T> {
        public MyTreeTable() {
            super(LanguagePerFileConfigurable.this.myProject, LanguagePerFileConfigurable.this.myValueClass, LanguagePerFileConfigurable.this.myTreeTableTitle, VirtualFileFilter.ALL, true);
            this.getValueColumn().setCellEditor(new DefaultCellEditor((JComboBox)new ComboBox()){
                private VirtualFile myVirtualFile;
                {
                    super(x0);
                    this.delegate = new DefaultCellEditor.EditorDelegate(){

                        @Override
                        public void setValue(Object value) {
                            MyTreeTable.this.getTableModel().setValueAt(value, (Object)new DefaultMutableTreeNode(myVirtualFile), -1);
                        }

                        @Override
                        public Object getCellEditorValue() {
                            return MyTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(myVirtualFile), 1);
                        }
                    };
                }

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                    Object o = table.getModel().getValueAt(row, 0);
                    this.myVirtualFile = o instanceof Project ? null : (VirtualFile)o;
                    ChooseSomethingAction changeAction = new ChooseSomethingAction(this.myVirtualFile){

                        public void update(AnActionEvent e) {
                            boolean enabled = MyTreeTable.this.isValueEditableForFile(myVirtualFile);
                            if (myVirtualFile != null) {
                                Object mapping = LanguagePerFileConfigurable.this.myMappings.getMapping(myVirtualFile);
                                e.getPresentation().setText(mapping == null ? "" : LanguagePerFileConfigurable.this.visualize(mapping));
                            }
                            e.getPresentation().setEnabled(enabled);
                        }

                        @Override
                        protected void chosen(VirtualFile virtualFile, T charset) {
                            MyTreeTable.this.getValueColumn().getCellEditor().stopCellEditing();
                            if (MyTreeTable.this.clearSubdirectoriesOnDemandOrCancel(virtualFile, LanguagePerFileConfigurable.this.myOverrideQuestion, LanguagePerFileConfigurable.this.myOverrideTitle)) {
                                MyTreeTable.this.getTableModel().setValueAt(LanguagePerFileConfigurable.this.myMappings.chosenToStored(virtualFile, charset), (Object)new DefaultMutableTreeNode(virtualFile), 1);
                            }
                        }
                    };
                    Presentation templatePresentation = changeAction.getTemplatePresentation();
                    JComponent comboComponent = changeAction.createCustomComponent(templatePresentation);
                    DataContext dataContext = SimpleDataContext.getSimpleContext(CommonDataKeys.VIRTUAL_FILE.getName(), this.myVirtualFile, SimpleDataContext.getProjectContext(MyTreeTable.this.getProject()));
                    AnActionEvent event = AnActionEvent.createFromAnAction((AnAction)changeAction, null, (String)"unknown", (DataContext)dataContext);
                    changeAction.update(event);
                    this.editorComponent = comboComponent;
                    comboComponent.addComponentListener(new ComponentAdapter(){

                        @Override
                        public void componentShown(ComponentEvent e) {
                            AbstractFileTreeTable.press((Container)e.getComponent());
                        }
                    });
                    Object t = MyTreeTable.this.getTableModel().getValueAt((Object)new DefaultMutableTreeNode(this.myVirtualFile), 1);
                    templatePresentation.setText(t == null ? "" : LanguagePerFileConfigurable.this.visualize(t));
                    comboComponent.revalidate();
                    return this.editorComponent;
                }
            });
            this.getValueColumn().setCellRenderer((TableCellRenderer)new ColoredTableCellRenderer(){

                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    Object t = value;
                    if (t != null) {
                        this.append(LanguagePerFileConfigurable.this.visualize(t), SimpleTextAttributes.REGULAR_ATTRIBUTES);
                    } else {
                        VirtualFile file2;
                        Object userObject = table.getModel().getValueAt(row, 0);
                        VirtualFile virtualFile = file2 = userObject instanceof VirtualFile ? (VirtualFile)userObject : null;
                        if (file2 != null) {
                            if (LanguagePerFileConfigurable.this.handleDefaultValue(file2, this)) {
                                return;
                            }
                            if (!MyTreeTable.this.isValueEditableForFile(file2)) {
                                this.append("N/A", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                            }
                        }
                    }
                }
            });
        }

        @Override
        protected boolean isValueEditableForFile(VirtualFile virtualFile) {
            FileType fileType;
            boolean enabled = true;
            if (virtualFile != null && !virtualFile.isDirectory() && (fileType = virtualFile.getFileType()).isBinary()) {
                enabled = false;
            }
            return enabled;
        }
    }
}

