/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import org.jetbrains.annotations.NotNull;

public class CommitId {
    @NotNull
    private final Hash myHash;
    @NotNull
    private final VirtualFile myRoot;

    public CommitId(@NotNull Hash hash, @NotNull VirtualFile root) {
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "com/intellij/vcs/log/CommitId", "<init>"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/vcs/log/CommitId", "<init>"));
        }
        this.myHash = hash;
        this.myRoot = root;
    }

    @NotNull
    public Hash getHash() {
        Hash hash = this.myHash;
        if (hash == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/CommitId", "getHash"));
        }
        return hash;
    }

    @NotNull
    public VirtualFile getRoot() {
        VirtualFile virtualFile = this.myRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/CommitId", "getRoot"));
        }
        return virtualFile;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitId commitId = (CommitId)o;
        if (!this.myHash.equals(commitId.myHash)) {
            return false;
        }
        return this.myRoot.equals(commitId.myRoot);
    }

    public int hashCode() {
        int result2 = this.myHash.hashCode();
        result2 = 31 * result2 + this.myRoot.hashCode();
        return result2;
    }
}

