/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick;

import com.intellij.concurrency.ResultConsumer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.evaluation.XInstanceEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class XDebuggerInstanceTreeCreator
implements DebuggerTreeCreator<Pair<XInstanceEvaluator, String>> {
    @NotNull
    private final Project myProject;
    private final XDebuggerEditorsProvider myProvider;
    private final XSourcePosition myPosition;
    private final XValueMarkers<?, ?> myMarkers;
    private final XDebugSession mySession;

    public XDebuggerInstanceTreeCreator(@NotNull Project project2, XDebuggerEditorsProvider editorsProvider, XSourcePosition sourcePosition, XValueMarkers<?, ?> markers, XDebugSession session) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator", "<init>"));
        }
        this.myProject = project2;
        this.myProvider = editorsProvider;
        this.myPosition = sourcePosition;
        this.myMarkers = markers;
        this.mySession = session;
    }

    @Override
    @NotNull
    public Tree createTree(@NotNull Pair<XInstanceEvaluator, String> descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator", "createTree"));
        }
        XDebuggerTree tree = new XDebuggerTree(this.myProject, this.myProvider, this.myPosition, "XDebugger.Inspect.Tree.Popup", this.myMarkers);
        final XValueNodeImpl root = new XValueNodeImpl(tree, null, (String)descriptor.getSecond(), new InstanceEvaluatorTreeRootValue((XInstanceEvaluator)descriptor.getFirst(), (String)descriptor.getSecond()));
        tree.setRoot(root, false);
        Condition<TreeNode> visibleRootCondition = new Condition<TreeNode>(){

            public boolean value(TreeNode node) {
                return node.getParent() == root;
            }
        };
        tree.expandNodesOnLoad(visibleRootCondition);
        tree.selectNodeOnLoad(visibleRootCondition);
        XDebuggerTree xDebuggerTree = tree;
        if (xDebuggerTree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator", "createTree"));
        }
        return xDebuggerTree;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull Pair<XInstanceEvaluator, String> descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator", "getTitle"));
        }
        String string = (String)descriptor.getSecond();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator", "getTitle"));
        }
        return string;
    }

    @Override
    public void createDescriptorByNode(Object node, ResultConsumer<Pair<XInstanceEvaluator, String>> resultConsumer) {
        if (node instanceof XValueNodeImpl) {
            XValueNodeImpl valueNode = (XValueNodeImpl)node;
            resultConsumer.onSuccess((Object)Pair.create((Object)((XValue)valueNode.getValueContainer()).getInstanceEvaluator(), (Object)valueNode.getName()));
        }
    }

    private class InstanceEvaluatorTreeRootValue
    extends XValue {
        private final XInstanceEvaluator myInstanceEvaluator;
        private final String myName;

        public InstanceEvaluatorTreeRootValue(XInstanceEvaluator instanceEvaluator, String name) {
            this.myInstanceEvaluator = instanceEvaluator;
            this.myName = name;
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator$InstanceEvaluatorTreeRootValue", "computePresentation"));
            }
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator$InstanceEvaluatorTreeRootValue", "computePresentation"));
            }
            node.setPresentation(null, null, "root", true);
        }

        public void computeChildren(final @NotNull XCompositeNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator$InstanceEvaluatorTreeRootValue", "computeChildren"));
            }
            XStackFrame frame = XDebuggerInstanceTreeCreator.this.mySession.getCurrentStackFrame();
            if (frame != null) {
                this.myInstanceEvaluator.evaluate(new XDebuggerEvaluator.XEvaluationCallback(){

                    public void evaluated(@NotNull XValue result2) {
                        if (result2 == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator$InstanceEvaluatorTreeRootValue$1", "evaluated"));
                        }
                        node.addChildren(XValueChildrenList.singleton((String)InstanceEvaluatorTreeRootValue.this.myName, (XValue)result2), true);
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/xdebugger/impl/evaluate/quick/XDebuggerInstanceTreeCreator$InstanceEvaluatorTreeRootValue$1", "errorOccurred"));
                        }
                    }
                }, frame);
            } else {
                node.setErrorMessage("Frame is not available");
            }
        }
    }
}

