/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.TooltipEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.ClickListener;
import com.intellij.ui.HintHint;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.IconUtil;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeCreator;
import com.intellij.xdebugger.impl.evaluate.quick.common.DebuggerTreeWithHistoryPopup;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JComponent;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractValueHint {
    private static final Logger LOG = Logger.getInstance(AbstractValueHint.class);
    private final KeyListener myEditorKeyListener;
    private RangeHighlighter myHighlighter;
    private Cursor myStoredCursor;
    private final Project myProject;
    private final Editor myEditor;
    private final ValueHintType myType;
    protected final Point myPoint;
    private LightweightHint myCurrentHint;
    private boolean myHintHidden;
    private TextRange myCurrentRange;
    private Runnable myHideRunnable;
    private boolean myInsideShow;

    public AbstractValueHint(@NotNull Project project2, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type, TextRange textRange) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "<init>"));
        }
        this.myEditorKeyListener = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (!AbstractValueHint.isAltMask(e.getModifiers())) {
                    ValueLookupManager.getInstance(AbstractValueHint.this.myProject).hideHint();
                }
            }
        };
        this.myInsideShow = false;
        this.myPoint = point;
        this.myProject = project2;
        this.myEditor = editor;
        this.myType = type;
        this.myCurrentRange = textRange;
    }

    protected abstract boolean canShowHint();

    protected abstract void evaluateAndShowHint();

    public boolean isKeepHint(Editor editor, Point point) {
        if (this.myCurrentHint != null && this.myCurrentHint.canControlAutoHide()) {
            return true;
        }
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            return false;
        }
        return this.myType == ValueHintType.MOUSE_CLICK_HINT ? this.myCurrentHint != null && this.myCurrentHint.isVisible() : this.isInsideCurrentRange(editor, point);
    }

    boolean isInsideCurrentRange(Editor editor, Point point) {
        return this.myCurrentRange != null && this.myCurrentRange.contains(AbstractValueHint.calculateOffset(editor, point));
    }

    public static int calculateOffset(@NotNull Editor editor, @NotNull Point point) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "calculateOffset"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "calculateOffset"));
        }
        return editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
    }

    public void hideHint() {
        this.myHintHidden = true;
        this.myCurrentRange = null;
        if (this.myStoredCursor != null) {
            JComponent internalComponent = this.myEditor.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(myStoredCursor)");
            }
            internalComponent.removeKeyListener(this.myEditorKeyListener);
        }
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
            this.myCurrentHint = null;
        }
        if (this.myHighlighter != null) {
            this.myHighlighter.dispose();
            this.myHighlighter = null;
        }
    }

    public void invokeHint() {
        this.invokeHint(null);
    }

    public void invokeHint(Runnable hideRunnable) {
        this.myHideRunnable = hideRunnable;
        if (!this.canShowHint()) {
            this.hideHint();
            return;
        }
        if (this.myType == ValueHintType.MOUSE_ALT_OVER_HINT) {
            EditorColorsScheme scheme = EditorColorsManager.getInstance().getGlobalScheme();
            TextAttributes attributes = scheme.getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR);
            attributes = NavigationUtil.patchAttributesColor(attributes, this.myCurrentRange, this.myEditor);
            this.myHighlighter = this.myEditor.getMarkupModel().addRangeHighlighter(this.myCurrentRange.getStartOffset(), this.myCurrentRange.getEndOffset(), 6001, attributes, HighlighterTargetArea.EXACT_RANGE);
            JComponent internalComponent = this.myEditor.getContentComponent();
            this.myStoredCursor = internalComponent.getCursor();
            internalComponent.addKeyListener(this.myEditorKeyListener);
            internalComponent.setCursor(AbstractValueHint.hintCursor());
            if (LOG.isDebugEnabled()) {
                LOG.debug("internalComponent.setCursor(hintCursor())");
            }
        } else {
            this.evaluateAndShowHint();
        }
    }

    private static Cursor hintCursor() {
        return Cursor.getPredefinedCursor(12);
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    protected Editor getEditor() {
        Editor editor = this.myEditor;
        if (editor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "getEditor"));
        }
        return editor;
    }

    protected ValueHintType getType() {
        return this.myType;
    }

    protected boolean showHint(JComponent component) {
        this.myInsideShow = true;
        if (this.myCurrentHint != null) {
            this.myCurrentHint.hide();
        }
        this.myCurrentHint = new LightweightHint(component){

            @Override
            protected boolean canAutoHideOn(TooltipEvent event) {
                Component comp;
                InputEvent inputEvent = event.getInputEvent();
                if (inputEvent instanceof MouseEvent && (comp = inputEvent.getComponent()) instanceof EditorComponentImpl) {
                    EditorImpl editor = ((EditorComponentImpl)comp).getEditor();
                    return !AbstractValueHint.this.isInsideCurrentRange(editor, ((MouseEvent)inputEvent).getPoint());
                }
                return true;
            }
        };
        this.myCurrentHint.addHintListener(new HintListener(){

            @Override
            public void hintHidden(EventObject event) {
                if (AbstractValueHint.this.myHideRunnable != null && !AbstractValueHint.this.myInsideShow) {
                    AbstractValueHint.this.myHideRunnable.run();
                }
                AbstractValueHint.this.onHintHidden();
            }
        });
        if (this.myEditor.isDisposed() || this.myEditor.getComponent().getRootPane() == null) {
            return false;
        }
        Point p = HintManagerImpl.getHintPosition(this.myCurrentHint, this.myEditor, this.myEditor.xyToLogicalPosition(this.myPoint), (short)2);
        HintHint hint = HintManagerImpl.createHintHint(this.myEditor, p, this.myCurrentHint, (short)2, true);
        hint.setShowImmediately(true);
        HintManagerImpl.getInstanceImpl().showEditorHint(this.myCurrentHint, this.myEditor, p, 42, 0, false, hint);
        this.myInsideShow = false;
        return true;
    }

    protected void onHintHidden() {
    }

    protected boolean isHintHidden() {
        return this.myHintHidden;
    }

    protected JComponent createExpandableHintComponent(SimpleColoredText text, final Runnable expand) {
        JComponent component = HintUtil.createInformationLabel(text, IconUtil.getAddIcon());
        AbstractValueHint.addClickListenerToHierarchy(component, new ClickListener(){

            public boolean onClick(@NotNull MouseEvent event, int clickCount) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint$4", "onClick"));
                }
                if (AbstractValueHint.this.myCurrentHint != null) {
                    AbstractValueHint.this.myCurrentHint.hide();
                }
                expand.run();
                return true;
            }
        });
        return component;
    }

    private static void addClickListenerToHierarchy(Component c, ClickListener l) {
        l.installOn(c);
        if (c instanceof Container) {
            Component[] children2;
            for (Component child : children2 = ((Container)c).getComponents()) {
                AbstractValueHint.addClickListenerToHierarchy(child, l);
            }
        }
    }

    @Nullable
    protected TextRange getCurrentRange() {
        return this.myCurrentRange;
    }

    private static boolean isAltMask(@JdkConstants.InputEventMask int modifiers) {
        return KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)KeymapManager.getInstance().getActiveKeymap(), (int)modifiers, (String)"QuickEvaluateExpression");
    }

    @Nullable
    public static ValueHintType getHintType(EditorMouseEvent e) {
        int modifiers = e.getMouseEvent().getModifiers();
        if (modifiers == 0) {
            return ValueHintType.MOUSE_OVER_HINT;
        }
        if (AbstractValueHint.isAltMask(modifiers)) {
            return ValueHintType.MOUSE_ALT_OVER_HINT;
        }
        return null;
    }

    public boolean isInsideHint(Editor editor, Point point) {
        return this.myCurrentHint != null && this.myCurrentHint.isInsideHint(new RelativePoint((Component)editor.getContentComponent(), point));
    }

    protected <D> void showTreePopup(@NotNull DebuggerTreeCreator<D> creator, @NotNull D descriptor) {
        if (creator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "creator", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "showTreePopup"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/xdebugger/impl/evaluate/quick/common/AbstractValueHint", "showTreePopup"));
        }
        DebuggerTreeWithHistoryPopup.showTreePopup(creator, descriptor, this.getEditor(), this.myPoint, this.getProject(), this.myHideRunnable);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractValueHint hint = (AbstractValueHint)o;
        if (!this.myProject.equals(hint.myProject)) {
            return false;
        }
        if (!this.myEditor.equals(hint.myEditor)) {
            return false;
        }
        if (this.myType != hint.myType) {
            return false;
        }
        return !(this.myCurrentRange != null ? !this.myCurrentRange.equals((Object)hint.myCurrentRange) : hint.myCurrentRange != null);
    }

    public int hashCode() {
        int result2 = this.myProject.hashCode();
        result2 = 31 * result2 + this.myEditor.hashCode();
        result2 = 31 * result2 + this.myType.hashCode();
        result2 = 31 * result2 + (this.myCurrentRange != null ? this.myCurrentRange.hashCode() : 0);
        return result2;
    }
}

