/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.evaluate.quick.common;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.QuickEvaluateHandler;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class ValueLookupManager
extends EditorMouseAdapter
implements EditorMouseMotionListener {
    public static final Key<Boolean> DISABLE_VALUE_LOOKUP = Key.create((String)"DISABLE_VALUE_LOOKUP");
    private final Project myProject;
    private final Alarm myAlarm;
    private AbstractValueHint myRequest = null;
    private final DebuggerSupport[] mySupports;
    private boolean myListening;

    public ValueLookupManager(Project project2) {
        this.myProject = project2;
        this.mySupports = DebuggerSupport.getDebuggerSupports();
        this.myAlarm = new Alarm((Disposable)project2);
    }

    public void startListening() {
        if (!this.myListening) {
            this.myListening = true;
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseMotionListener((EditorMouseMotionListener)this, (Disposable)this.myProject);
            EditorFactory.getInstance().getEventMulticaster().addEditorMouseListener((EditorMouseListener)this, (Disposable)this.myProject);
        }
    }

    public void mouseDragged(EditorMouseEvent e) {
    }

    public void mouseExited(EditorMouseEvent e) {
        this.myAlarm.cancelAllRequests();
    }

    public void mouseMoved(EditorMouseEvent e) {
        if (e.isConsumed()) {
            return;
        }
        Editor editor = e.getEditor();
        if (editor.getProject() != null && editor.getProject() != this.myProject) {
            return;
        }
        ValueHintType type = AbstractValueHint.getHintType(e);
        if (e.getArea() != EditorMouseEventArea.EDITING_AREA || DISABLE_VALUE_LOOKUP.get((UserDataHolder)editor) == Boolean.TRUE || type == null) {
            this.myAlarm.cancelAllRequests();
            return;
        }
        Point point = e.getMouseEvent().getPoint();
        if (this.myRequest != null && !this.myRequest.isKeepHint(editor, point)) {
            this.hideHint();
        }
        for (DebuggerSupport support : this.mySupports) {
            QuickEvaluateHandler handler2 = support.getQuickEvaluateHandler();
            if (!handler2.isEnabled(this.myProject)) continue;
            this.requestHint(handler2, editor, point, type);
            break;
        }
    }

    private void requestHint(final QuickEvaluateHandler handler2, final Editor editor, final Point point, final @NotNull ValueHintType type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "requestHint"));
        }
        final Rectangle area = editor.getScrollingModel().getVisibleArea();
        this.myAlarm.cancelAllRequests();
        if (type == ValueHintType.MOUSE_OVER_HINT) {
            if (Registry.is((String)"debugger.valueTooltipAutoShow")) {
                this.myAlarm.addRequest(new Runnable(){

                    @Override
                    public void run() {
                        if (area.equals(editor.getScrollingModel().getVisibleArea())) {
                            ValueLookupManager.this.showHint(handler2, editor, point, type);
                        }
                    }
                }, this.getDelay(handler2));
            }
        } else {
            this.showHint(handler2, editor, point, type);
        }
    }

    private int getDelay(QuickEvaluateHandler handler2) {
        int delay = handler2.getValueLookupDelay(this.myProject);
        if (this.myRequest != null && !this.myRequest.isHintHidden()) {
            delay = Math.max(100, delay);
        }
        return delay;
    }

    public void hideHint() {
        if (this.myRequest != null) {
            this.myRequest.hideHint();
            this.myRequest = null;
        }
    }

    public void showHint(@NotNull QuickEvaluateHandler handler2, @NotNull Editor editor, @NotNull Point point, @NotNull ValueHintType type) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        if (point == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "point", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xdebugger/impl/evaluate/quick/common/ValueLookupManager", "showHint"));
        }
        this.myAlarm.cancelAllRequests();
        if (editor.isDisposed() || !handler2.canShowHint(this.myProject)) {
            return;
        }
        final AbstractValueHint request = handler2.createValueHint(this.myProject, editor, point, type);
        if (request != null) {
            if (this.myRequest != null && this.myRequest.equals(request)) {
                return;
            }
            if (!request.canShowHint()) {
                return;
            }
            if (this.myRequest != null && this.myRequest.isInsideHint(editor, point)) {
                return;
            }
            this.hideHint();
            this.myRequest = request;
            this.myRequest.invokeHint(new Runnable(){

                @Override
                public void run() {
                    if (ValueLookupManager.this.myRequest != null && ValueLookupManager.this.myRequest == request) {
                        ValueLookupManager.this.myRequest = null;
                    }
                }
            });
        }
    }

    public static ValueLookupManager getInstance(Project project2) {
        return (ValueLookupManager)((Object)ServiceManager.getService((Project)project2, ValueLookupManager.class));
    }
}

