/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.ui.EditorComboBoxEditor;
import com.intellij.ui.EditorComboBoxRenderer;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerCopyPastePreprocessor;
import com.intellij.xdebugger.impl.ui.XDebuggerEditorBase;
import java.awt.Dimension;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XDebuggerExpressionComboBox
extends XDebuggerEditorBase {
    private final JComponent myComponent;
    private final ComboBox myComboBox;
    private EditorComboBoxEditor myEditor;
    private XExpression myExpression;

    public XDebuggerExpressionComboBox(@NotNull Project project2, @NotNull XDebuggerEditorsProvider debuggerEditorsProvider, @Nullable @NonNls String historyId, @Nullable XSourcePosition sourcePosition) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox", "<init>"));
        }
        if (debuggerEditorsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debuggerEditorsProvider", "com/intellij/xdebugger/impl/ui/XDebuggerExpressionComboBox", "<init>"));
        }
        super(project2, debuggerEditorsProvider, EvaluationMode.EXPRESSION, historyId, sourcePosition);
        this.myComboBox = new ComboBox(100);
        this.myComboBox.setEditable(true);
        this.myExpression = XExpressionImpl.EMPTY_EXPRESSION;
        Dimension minimumSize = new Dimension(this.myComboBox.getMinimumSize());
        minimumSize.width = 100;
        this.myComboBox.setMinimumSize(minimumSize);
        this.initEditor();
        this.fillComboBox();
        this.myComponent = this.addChooseFactoryLabel((JComponent)this.myComboBox, false);
    }

    public ComboBox getComboBox() {
        return this.myComboBox;
    }

    @Override
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Override
    @Nullable
    public Editor getEditor() {
        return this.myEditor.getEditor();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myEditor.getEditorComponent();
    }

    public void setEnabled(boolean enable) {
        if (enable == this.myComboBox.isEnabled()) {
            return;
        }
        this.myComboBox.setEnabled(enable);
        if (!enable) {
            this.myExpression = this.getExpression();
        }
    }

    private void initEditor() {
        this.myEditor = new EditorComboBoxEditor(this.getProject(), this.getEditorsProvider().getFileType()){

            @Override
            public void setItem(Object anObject) {
                if (anObject == null) {
                    anObject = XExpressionImpl.EMPTY_EXPRESSION;
                }
                XExpression expression = (XExpression)anObject;
                this.getEditorComponent().setNewDocumentAndFileType(XDebuggerExpressionComboBox.this.getFileType(expression), XDebuggerExpressionComboBox.this.createDocument(expression));
            }

            @Override
            protected void onEditorCreate(EditorEx editor) {
                editor.putUserData(DebuggerCopyPastePreprocessor.REMOVE_NEWLINES_ON_PASTE, true);
                editor.getColorsScheme().setEditorFontSize(XDebuggerExpressionComboBox.this.myComboBox.getFont().getSize());
            }
        };
        this.myEditor.getEditorComponent().setFontInheritedFromLAF(false);
        this.myComboBox.setEditor((ComboBoxEditor)this.myEditor);
        this.myComboBox.setRenderer((ListCellRenderer)new EditorComboBoxRenderer((ComboBoxEditor)this.myEditor));
        this.myComboBox.setMaximumRowCount(10);
    }

    @Override
    protected void onHistoryChanged() {
        this.fillComboBox();
    }

    private void fillComboBox() {
        this.myComboBox.removeAllItems();
        for (XExpression expression : this.getRecentExpressions()) {
            this.myComboBox.addItem((Object)expression);
        }
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
    }

    @Override
    protected void doSetText(XExpression text) {
        if (this.myComboBox.getItemCount() > 0) {
            this.myComboBox.setSelectedIndex(0);
        }
        this.myEditor.setItem(text);
        this.myExpression = text;
    }

    @Override
    public XExpression getExpression() {
        Object document = this.myEditor.getItem();
        if (document instanceof Document) {
            return this.getEditorsProvider().createExpression(this.getProject(), (Document)document, this.myExpression.getLanguage(), EvaluationMode.EXPRESSION);
        }
        return this.myExpression;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return (JComponent)this.myComboBox.getEditor().getEditorComponent();
    }

    @Override
    public void selectAll() {
        this.myComboBox.getEditor().selectAll();
    }
}

