/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.NotNullFunction;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.presentation.XRegularValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XValueNodePresentationConfigurator {
    public static void setPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren, ConfigurableXValueNode node) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator", "setPresentation"));
        }
        XValueNodePresentationConfigurator.doSetPresentation(icon, presentation, hasChildren, node);
    }

    public static void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, boolean hasChildren, ConfigurableXValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator", "setPresentation"));
        }
        XValueNodePresentationConfigurator.doSetPresentation(icon, (XValuePresentation)new XRegularValuePresentation(value, type), hasChildren, node);
    }

    public static void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String separator, @NonNls @Nullable String value, boolean hasChildren, ConfigurableXValueNode node) {
        if (separator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator", "setPresentation"));
        }
        XValueNodePresentationConfigurator.doSetPresentation(icon, (XValuePresentation)new XRegularValuePresentation(StringUtil.notNullize((String)value), type, separator), hasChildren, node);
    }

    public static void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, @Nullable NotNullFunction<String, String> valuePresenter, boolean hasChildren, ConfigurableXValueNode node) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator", "setPresentation"));
        }
        XValueNodePresentationConfigurator.doSetPresentation(icon, (XValuePresentation)(valuePresenter == null ? new XRegularValuePresentation(value, type) : new XValuePresentationAdapter(value, type, valuePresenter)), hasChildren, node);
    }

    private static void doSetPresentation(final @Nullable Icon icon, final @NotNull XValuePresentation presentation, final boolean hasChildren, final ConfigurableXValueNode node) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator", "doSetPresentation"));
        }
        if (DebuggerUIUtil.isObsolete(node)) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            node.applyPresentation(icon, presentation, hasChildren);
        } else {
            Runnable updater = new Runnable(){

                @Override
                public void run() {
                    node.applyPresentation(icon, presentation, hasChildren);
                }
            };
            if (node instanceof XDebuggerTreeNode) {
                ((XDebuggerTreeNode)((Object)node)).invokeNodeUpdate(updater);
            } else {
                application.invokeLater(updater);
            }
        }
    }

    private static final class XValuePresentationAdapter
    extends XValuePresentation {
        private final String myValue;
        private final String myType;
        private final NotNullFunction<String, String> valuePresenter;

        public XValuePresentationAdapter(String value, String type, NotNullFunction<String, String> valuePresenter) {
            this.myValue = value;
            this.myType = type;
            this.valuePresenter = valuePresenter;
        }

        @Nullable
        public String getType() {
            return this.myType;
        }

        public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$XValuePresentationAdapter", "renderValue"));
            }
            renderer.renderValue((String)this.valuePresenter.fun((Object)this.myValue));
        }
    }

    public static abstract class ConfigurableXValueNodeImpl
    implements ConfigurableXValueNode,
    XValueNode {
        public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, boolean hasChildren) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl", "setPresentation"));
            }
            XValueNodePresentationConfigurator.setPresentation(icon, type, value, hasChildren, this);
        }

        public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String separator, @NonNls @Nullable String value, boolean hasChildren) {
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl", "setPresentation"));
            }
            XValueNodePresentationConfigurator.setPresentation(icon, type, separator, value, hasChildren, (ConfigurableXValueNode)this);
        }

        public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String value, @Nullable NotNullFunction<String, String> valuePresenter, boolean hasChildren) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl", "setPresentation"));
            }
            XValueNodePresentationConfigurator.setPresentation(icon, type, value, valuePresenter, hasChildren, (ConfigurableXValueNode)this);
        }

        public void setPresentation(@Nullable Icon icon, @NotNull XValuePresentation presentation, boolean hasChildren) {
            if (presentation == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl", "setPresentation"));
            }
            XValueNodePresentationConfigurator.setPresentation(icon, presentation, hasChildren, this);
        }

        public void setPresentation(@Nullable Icon icon, @NonNls @Nullable String type, @NonNls @NotNull String separator, @NonNls @NotNull String value, @Nullable NotNullFunction<String, String> valuePresenter, boolean hasChildren) {
            if (separator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "separator", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl", "setPresentation"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/nodes/XValueNodePresentationConfigurator$ConfigurableXValueNodeImpl", "setPresentation"));
            }
            XValueNodePresentationConfigurator.setPresentation(icon, type, separator, valuePresenter, hasChildren, (ConfigurableXValueNode)this);
        }
    }

    public static interface ConfigurableXValueNode {
        public void applyPresentation(@Nullable Icon var1, @NotNull XValuePresentation var2, boolean var3);
    }
}

