/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create((String)"XmlNamespaces");

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file2, Project project2, PsiFile context) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "getNamespace"));
        }
        if (DumbService.isDumb((Project)project2) || context != null && XmlUtil.isStubBuilding()) {
            return XmlNamespaceIndex.computeNamespace(file2);
        }
        List list = FileBasedIndex.getInstance().getValues(NAME, (Object)file2.getUrl(), XmlNamespaceIndex.createFilter(project2));
        return list.size() == 0 ? null : ((XsdNamespaceBuilder)list.get(0)).getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String computeNamespace(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "computeNamespace"));
        }
        InputStream stream = null;
        try {
            stream = file2.getInputStream();
            String string = XsdNamespaceBuilder.computeNamespace(stream);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(String namespace, @NotNull Project project2, @Nullable Module module2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getResourcesByNamespace"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module2, project2, null);
        Collections.sort(resources);
        return resources;
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module2, @NotNull Project project2, @Nullable NullableFunction<List<IndexedRelevantResource<String, XsdNamespaceBuilder>>, IndexedRelevantResource<String, XsdNamespaceBuilder>> chooser) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "getAllResources"));
        }
        return IndexedRelevantResource.getAllResources(NAME, module2, project2, chooser);
    }

    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        ID<String, XsdNamespaceBuilder> iD = NAME;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        DataIndexer<String, XsdNamespaceBuilder, FileContent> dataIndexer = new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                XsdNamespaceBuilder builder = "dtd".equals(inputData.getFile().getExtension()) ? new XsdNamespaceBuilder(inputData.getFileName(), "", Collections.<String>emptyList(), Collections.<String>emptyList()) : XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                HashMap<String, XsdNamespaceBuilder> map = new HashMap<String, XsdNamespaceBuilder>(2);
                String namespace = builder.getNamespace();
                if (namespace != null) {
                    map.put(namespace, builder);
                }
                map.put(inputData.getFile().getUrl(), builder);
                HashMap<String, XsdNamespaceBuilder> hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex$1", "map"));
                }
                return hashMap;
            }
        };
        if (dataIndexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getIndexer"));
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        DataExternalizer<XsdNamespaceBuilder> dataExternalizer = new DataExternalizer<XsdNamespaceBuilder>(){

            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/xml/index/XmlNamespaceIndex$2", "save"));
                }
                IOUtil.writeUTF((DataOutput)out, (String)(value.getNamespace() == null ? "" : value.getNamespace()));
                IOUtil.writeUTF((DataOutput)out, (String)(value.getVersion() == null ? "" : value.getVersion()));
                XmlNamespaceIndex.writeList(out, value.getTags());
                XmlNamespaceIndex.writeList(out, value.getRootTags());
            }

            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/xml/index/XmlNamespaceIndex$2", "read"));
                }
                return new XsdNamespaceBuilder(IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in), XmlNamespaceIndex.readList(in), XmlNamespaceIndex.readList(in));
            }
        };
        if (dataExternalizer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "getValueExternalizer"));
        }
        return dataExternalizer;
    }

    private static void writeList(@NotNull DataOutput out, List<String> tags) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "com/intellij/xml/index/XmlNamespaceIndex", "writeList"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)tags.size());
        for (String s : tags) {
            IOUtil.writeUTF((DataOutput)out, (String)s);
        }
    }

    @NotNull
    private static ArrayList<String> readList(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "com/intellij/xml/index/XmlNamespaceIndex", "readList"));
        }
        int count = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList<String> tags = new ArrayList<String>(count);
        for (int i = 0; i < count; ++i) {
            tags.add(IOUtil.readUTF((DataInput)in));
        }
        ArrayList<String> arrayList = tags;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xml/index/XmlNamespaceIndex", "readList"));
        }
        return arrayList;
    }

    @Override
    public int getVersion() {
        return 4;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, final @Nullable String tagName, final @Nullable String version, @Nullable String schemaLocation, @Nullable Module module2, @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project2, module2);
        if (resources.isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        final String fileName = schemaLocation == null ? null : new File(schemaLocation).getName();
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = Collections.max(resources, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

            @Override
            public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                int i;
                if (fileName != null && (i = Comparing.compare((boolean)fileName.equals(o1.getFile().getName()), (boolean)fileName.equals(o2.getFile().getName()))) != 0) {
                    return i;
                }
                if (tagName != null && (i = Comparing.compare((boolean)o1.getValue().hasTag(tagName), (boolean)o2.getValue().hasTag(tagName))) != 0) {
                    return i;
                }
                i = o1.compareTo(o2);
                if (i != 0) {
                    return i;
                }
                return o1.getValue().getRating(tagName, version) - o2.getValue().getRating(tagName, version);
            }
        });
        if (tagName != null && !resource.getValue().hasTag(tagName)) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName, @Nullable String version, @Nullable String schemaLocation, @NotNull PsiFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex", "guessSchema"));
        }
        if (DumbService.isDumb((Project)file2.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName, version, schemaLocation, ModuleUtilCore.findModuleForPsiElement((PsiElement)file2), file2.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file2);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (baseFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFile", "com/intellij/xml/index/XmlNamespaceIndex", "guessDtd"));
        }
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb((Project)baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)baseFile));
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() > 1) {
            final String[] split = dtdUri.split("/");
            resource = Collections.max(list, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file2 = o1.getFile();
                    for (int i = split.length - 1; i >= 0 && file2 != null; file2 = file2.getParent(), --i) {
                        String s = split[i];
                        if (s.equals(file2.getName())) continue;
                        return split.length - i;
                    }
                    return 0;
                }
            });
        } else {
            resource = list.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }
}

