/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import java.util.Iterator;
import java.util.concurrent.ConcurrentMap;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.ScriptBase;
import org.jetbrains.debugger.ScriptManagerBase;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"O\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001C\u0004\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001C\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003!-Q\u0001A\u0003\u0002\u0019\u0005!1\u0003\u0004\u0001\u0016\t\u0011\u0001\u0001\u0012A\u000b\u00021\u0005IB!\u0003\u0002\n\u0003\u0011\u0006\u00014AQ\u0003#\u000e\t\u0001BA\u0013\b\u0011\u0019i\u0011\u0001'\u0004\u001a\u0007!9Q\"\u0001M\bK+A\u0001\"\u0004\u0002\r\u0002q\u0001\u0011d\u0001E\t\u001b\u0005A:!U\u0002\u0002\u0011%)\u0003\u0002c\u0005\u000e\u00051\u0005\u0001DC\r\u0004\u0011+i\u0011\u0001G\u0006&\u0011!MQB\u0001G\u00011)I2\u0001c\u0006\u000e\u0003a\u001dQ%\u0004\u0005\r\u001b\u0005Aj!G\u0005\t\u001a59\u0011BA\u0005\u00021)I!!C\u0001\u0019\u001caiQU\u0003\u0003\u000b\u00119i9\u0001G\u0006R\u0007\u0005!i\"G\u0002\t\u00185\t\u0001tAU\u001b\t\tC\u0001RAG\u0012\u0013\u0019IQ\u0001\u0005\u0003\u0016\u00051\u0005\u0001t\u0001M\u0004\u0013\u0019IQ\u0001\u0005\u0003\u0016\u00051\u0005A\u0004\u0001\u000f\u00011\r\t6!\u0001C\u0005#\u000e!Q\u0001A\u0007\u0003\t\u0015AY\u0001"}, strings={"Lorg/jetbrains/debugger/ScriptManagerBaseEx;", "SCRIPT", "Lorg/jetbrains/debugger/ScriptBase;", "Lorg/jetbrains/debugger/ScriptManagerBase;", "()V", "idToScript", "Ljava/util/concurrent/ConcurrentMap;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getIdToScript", "()Ljava/util/concurrent/ConcurrentMap;", "clear", "", "listener", "Lorg/jetbrains/debugger/DebugEventListener;", "findScriptById", "id", "(Ljava/lang/String;)Lorg/jetbrains/debugger/ScriptBase;", "findScriptByUrl", "Lorg/jetbrains/debugger/Script;", "url", "Lcom/intellij/util/Url;", "rawUrl", "forEachScript", "scriptProcessor", "Lkotlin/Function1;", "", "rawUrlToOurUrl", "Lorg/jetbrains/annotations/Nullable;"}, moduleName="script-debugger-backend")
public abstract class ScriptManagerBaseEx<SCRIPT extends ScriptBase>
extends ScriptManagerBase<SCRIPT> {
    @NotNull
    private final ConcurrentMap<String, SCRIPT> idToScript = ContainerUtil.newConcurrentMap();

    @NotNull
    protected final ConcurrentMap<String, SCRIPT> getIdToScript() {
        return this.idToScript;
    }

    @Override
    public final void forEachScript(@NotNull Function1<? super Script, Boolean> scriptProcessor) {
        Intrinsics.checkParameterIsNotNull(scriptProcessor, (String)"scriptProcessor");
        Iterator iterator = this.idToScript.values().iterator();
        while (iterator.hasNext()) {
            ScriptBase script;
            ScriptBase scriptBase = script = (ScriptBase)iterator.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptBase, (String)"script");
            if (((Boolean)scriptProcessor.invoke((Object)scriptBase)).booleanValue()) continue;
            return;
        }
    }

    @Nullable
    public final SCRIPT findScriptById(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return (SCRIPT)((ScriptBase)this.idToScript.get(id));
    }

    public final void clear(@NotNull DebugEventListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.idToScript.clear();
        listener.scriptsCleared();
    }

    @Override
    @Nullable
    public final Script findScriptByUrl(@NotNull String rawUrl) {
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        Url url = this.rawUrlToOurUrl(rawUrl);
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"rawUrlToOurUrl(rawUrl)");
        return this.findScriptByUrl(url);
    }

    @Override
    @Nullable
    public final Script findScriptByUrl(@NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        for (ScriptBase script : this.idToScript.values()) {
            if (!url.equalsIgnoreParameters(script.getUrl())) continue;
            return script;
        }
        return null;
    }

    @NotNull
    protected Url rawUrlToOurUrl(@NotNull String rawUrl) {
        Intrinsics.checkParameterIsNotNull((Object)rawUrl, (String)"rawUrl");
        Url url = Urls.parseEncoded(rawUrl);
        if (url == null) {
            Intrinsics.throwNpe();
        }
        return url;
    }
}

