/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.xdebugger.XSourcePosition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SourceInfo
implements XSourcePosition {
    private final String functionName;
    private final VirtualFile file;
    private final int line;
    private final int column;
    private int offset;

    private SourceInfo(@Nullable String functionName, @NotNull VirtualFile file2, int line, int column) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/debugger/SourceInfo", "<init>"));
        }
        this.offset = -1;
        this.functionName = functionName;
        this.file = file2;
        this.line = line;
        this.column = column;
    }

    @Nullable
    public static SourceInfo create(@Nullable String functionName, @Nullable VirtualFile file2, int line, int column) {
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        return new SourceInfo(functionName, file2, line, column);
    }

    @Nullable
    public String getFunctionName() {
        return this.functionName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        if (this.offset == -1) {
            Document document;
            AccessToken token = ReadAction.start();
            try {
                document = this.file.isValid() ? FileDocumentManager.getInstance().getDocument(this.file) : null;
            }
            finally {
                token.finish();
            }
            if (document == null) {
                return -1;
            }
            this.offset = this.line < document.getLineCount() ? document.getLineStartOffset(this.line) : -1;
        }
        return this.offset;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SourceInfo", "getFile"));
        }
        return virtualFile;
    }

    @NotNull
    public Navigatable createNavigatable(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/debugger/SourceInfo", "createNavigatable"));
        }
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project2, this.getFile(), this.getLine(), this.getColumn());
        if (openFileDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/SourceInfo", "createNavigatable"));
        }
        return openFileDescriptor;
    }

    public String toString() {
        return this.getFile() + ":" + this.getLine() + (this.column == -1 ? "" : ":" + this.getColumn());
    }
}

