/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.frame;

import com.intellij.util.Consumer;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.settings.XDebuggerSettingsManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ContextDependentAsyncResultConsumer;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.Script;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.SuspendContext;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.frame.AsyncFramesHeader;
import org.jetbrains.debugger.frame.CallFrameView;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"A\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0005)\u0001!B\u0001\t\t\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001!\u0001\u0001\u0004\u0001\u001a\u0003a\u0005\u00115G\u0005\b\u0011\u0005iQ!C\u0002\u0005\u0002%\t\u0001D\u0001M\u0002\u0013\rA)!D\u0001\u0019\u0007%!\u0001rA\u0007\u0003\u0019\u0003AB!C\u0003\u0005\u0003!%QB\u0001G\u00011\u0015\t6!\u0001E\u0006K1!1\u0002C\u0004\u000e\u0003a=\u0011d\u0001\u0005\t\u001b\u0005A\n\"G\u0002\t\u00135\t\u00014C\u0013\u0006\t-A!\"\u0004\u0002\r\u0002a5\u0011f\u0003\u0003B\u0011!\tQ\"B\u0005\u0004\t\u0003I\u0011\u0001\u0007\u0002\u0019\u0004E\u001b\u0011!\u0002\u0001*\u0011\u0011\tE\u0004\u0003\u0004\u000e\u00051\u0005\u0001TB)\u0004\u0003\u0015\u0001\u0011\u0006\u0003\u0003B\u0011!\u001dQB\u0001G\u00011\u0011\t6!A\u0003\u0001S!!\u0011\t\u0003E\u0005\u001b\ta\t\u0001G\u0003R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"A)!D\u0001\u0019\u0007E\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/debugger/frame/ExecutionStackImpl;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "suspendContext", "Lorg/jetbrains/debugger/SuspendContext;", "Lorg/jetbrains/debugger/CallFrame;", "viewSupport", "Lorg/jetbrains/debugger/DebuggerViewSupport;", "topFrameScript", "Lorg/jetbrains/debugger/Script;", "topFrameSourceInfo", "Lorg/jetbrains/debugger/SourceInfo;", "(Lorg/jetbrains/debugger/SuspendContext;Lorg/jetbrains/debugger/DebuggerViewSupport;Lorg/jetbrains/debugger/Script;Lorg/jetbrains/debugger/SourceInfo;)V", "topCallFrameView", "Lorg/jetbrains/debugger/frame/CallFrameView;", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame"}, moduleName="script-debugger-ui")
public final class ExecutionStackImpl
extends XExecutionStack {
    private CallFrameView topCallFrameView;
    private final SuspendContext<? extends CallFrame> suspendContext;
    private final DebuggerViewSupport viewSupport;
    private final Script topFrameScript;
    private final SourceInfo topFrameSourceInfo;

    @Nullable
    public CallFrameView getTopFrame() {
        block5: {
            CallFrame topCallFrame;
            block4: {
                topCallFrame = this.suspendContext.getTopFrame();
                if (this.topCallFrameView == null) break block4;
                CallFrameView callFrameView = this.topCallFrameView;
                if (callFrameView == null) {
                    Intrinsics.throwNpe();
                }
                if (!(Intrinsics.areEqual((Object)callFrameView.getCallFrame(), (Object)topCallFrame) ^ true)) break block5;
            }
            this.topCallFrameView = topCallFrame == null ? (CallFrameView)null : new CallFrameView(topCallFrame, this.viewSupport, this.topFrameScript, this.topFrameSourceInfo, null, 16, null);
        }
        return this.topCallFrameView;
    }

    /*
     * WARNING - void declaration
     */
    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Vm vm = this.viewSupport.getVm();
        if (vm == null) {
            Intrinsics.throwNpe();
        }
        SuspendContext<? extends CallFrame> suspendContext = vm.getSuspendContextManager().getContext();
        if (suspendContext == null) {
            return;
        }
        SuspendContext<? extends CallFrame> suspendContext2 = suspendContext;
        Promise<CallFrame[]> promise2 = suspendContext2.getFrames();
        void v2 = $receiver$iv;
        if (v2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.concurrency.Promise<T>");
        }
        ((Promise)v2).done((Consumer)new ContextDependentAsyncResultConsumer<T>(suspendContext2, this, firstFrameIndex, container){
            final /* synthetic */ ExecutionStackImpl this$0;
            final /* synthetic */ int $firstFrameIndex$inlined;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container$inlined;

            /*
             * WARNING - void declaration
             */
            protected void consume(T result2, Vm vm) {
                List result3;
                CallFrame[] frames = (CallFrame[])result2;
                int count = ((Object[])frames).length - this.$firstFrameIndex$inlined;
                if (count < 1) {
                    result3 = CollectionsKt.emptyList();
                } else {
                    result3 = new ArrayList<E>(count);
                    int n = this.$firstFrameIndex$inlined;
                    int n2 = ((Object[])frames).length - 1;
                    if (n <= n2) {
                        while (true) {
                            void i;
                            if (i == false) {
                                ArrayList arrayList = (ArrayList)result3;
                                CallFrameView callFrameView = this.this$0.getTopFrame();
                                if (callFrameView == null) {
                                    Intrinsics.throwNpe();
                                }
                                arrayList.add(callFrameView);
                            } else {
                                Script script;
                                Object object;
                                CallFrame frame = frames[i];
                                String asyncFunctionName = frame.getAsyncFunctionName();
                                if (asyncFunctionName != null) {
                                    ((ArrayList)result3).add(new AsyncFramesHeader(asyncFunctionName));
                                }
                                Script script2 = (object = ExecutionStackImpl.access$getViewSupport$p(this.this$0).getVm()) != null && (object = object.getScriptManager()) != null ? object.getScript(frame) : (script = null);
                                if (script != null) {
                                    boolean isInLibraryContent;
                                    SourceInfo sourceInfo = ExecutionStackImpl.access$getViewSupport$p(this.this$0).getSourceInfo(script, frame);
                                    boolean bl = isInLibraryContent = sourceInfo != null && ExecutionStackImpl.access$getViewSupport$p(this.this$0).isInLibraryContent(sourceInfo, script);
                                    if (!isInLibraryContent || XDebuggerSettingsManager.getInstance().getDataViewSettings().isShowLibraryStackFrames()) {
                                        ((ArrayList)result3).add(new CallFrameView(frame, ExecutionStackImpl.access$getViewSupport$p(this.this$0), script, sourceInfo, isInLibraryContent));
                                    }
                                }
                            }
                            if (i == n2) break;
                            ++i;
                        }
                    }
                }
                this.$container$inlined.addStackFrames(result3, true);
            }
            {
                void $super_call_param$1;
                this.this$0 = executionStackImpl;
                this.$firstFrameIndex$inlined = n;
                this.$container$inlined = xStackFrameContainer;
                super((SuspendContext<?>)$super_call_param$1);
            }
        });
    }

    public ExecutionStackImpl(@NotNull SuspendContext<? extends CallFrame> suspendContext, @NotNull DebuggerViewSupport viewSupport, @Nullable Script topFrameScript, @Nullable SourceInfo topFrameSourceInfo) {
        Intrinsics.checkParameterIsNotNull(suspendContext, (String)"suspendContext");
        Intrinsics.checkParameterIsNotNull((Object)viewSupport, (String)"viewSupport");
        super("");
        this.suspendContext = suspendContext;
        this.viewSupport = viewSupport;
        this.topFrameScript = topFrameScript;
        this.topFrameSourceInfo = topFrameSourceInfo;
    }

    public /* synthetic */ ExecutionStackImpl(SuspendContext suspendContext, DebuggerViewSupport debuggerViewSupport, Script script, SourceInfo sourceInfo, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            sourceInfo = null;
        }
        this(suspendContext, debuggerViewSupport, script, sourceInfo);
    }

    @NotNull
    public static final /* synthetic */ DebuggerViewSupport access$getViewSupport$p(ExecutionStackImpl $this) {
        return $this.viewSupport;
    }
}

