/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005A\u0001#B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u001d)\u0001!B\u0001\r\u0003\u0015\u0001Q\u0012\b\u0005\u0001\u001b\u001dIQ!\u0003\u0003\n\u0005%\t\u00014\u0001\r\u00021\u0003Ib\u0001\u0003\u0002\u000e\t%\u0011\u0011\"\u0001M\u00021\u0005Ib\u0001#\u0002\u000e\t%\u0011\u0011\"\u0001\r\u00041\u0005I2\u0001c\u0002\u000e\u0003a!Ak!\u0003"}, strings={"getSpecifiedProperties", "Lorg/jetbrains/concurrency/Promise;", "", "Lorg/jetbrains/debugger/Variable;", "variables", "names", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "ObjectValueBaseKt"}, moduleName="script-debugger-backend")
public final class ObjectValueBaseKt {
    @NotNull
    public static final Promise<List<Variable>> getSpecifiedProperties(@NotNull List<? extends Variable> variables, @NotNull List<String> names, @NotNull EvaluateContext evaluateContext2) {
        Intrinsics.checkParameterIsNotNull(variables, (String)"variables");
        Intrinsics.checkParameterIsNotNull(names, (String)"names");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        SmartList properties = new SmartList();
        int getterCount = 0;
        for (Variable variable : variables) {
            if (!variable.isReadable() || !names.contains(variable.getName())) continue;
            if (!properties.isEmpty()) {
                Collections.sort((List)properties, (Comparator)new Comparator<Variable>(names){
                    final /* synthetic */ List $names;

                    public int compare(@NotNull Variable o1, @NotNull Variable o2) {
                        Intrinsics.checkParameterIsNotNull((Object)o1, (String)"o1");
                        Intrinsics.checkParameterIsNotNull((Object)o2, (String)"o2");
                        return this.$names.indexOf(o1.getName()) - this.$names.indexOf(o2.getName());
                    }
                    {
                        this.$names = $captured_local_variable$0;
                    }
                });
            }
            properties.add((Object)variable);
            if (variable.getValue() != null) continue;
            ++getterCount;
        }
        if (getterCount == 0) {
            Promise promise2 = Promise.resolve((Object)properties);
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(properties)");
            return promise2;
        }
        SmartList smartList = new SmartList();
        for (Variable variable : properties) {
            if (variable.getValue() != null) continue;
            ValueModifier valueModifier = variable.getValueModifier();
            PreconditionsKt.assert((valueModifier != null ? 1 : 0) != 0);
            ValueModifier valueModifier2 = valueModifier;
            if (valueModifier2 == null) {
                Intrinsics.throwNpe();
            }
            Variable variable2 = variable;
            Intrinsics.checkExpressionValueIsNotNull((Object)variable2, (String)"variable");
            smartList.add(valueModifier2.evaluateGet(variable2, evaluateContext2));
        }
        Promise promise3 = Promise.all((Collection)((Collection)smartList), (Object)properties);
        Intrinsics.checkExpressionValueIsNotNull((Object)promise3, (String)"Promise.all<List<Variable>>(promises, properties)");
        return promise3;
    }
}

