/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import java.io.File;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public final class PooledThreadExecutor {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.ide.PooledThreadExecutor");
    private static final AtomicInteger ourAliveThreads = new AtomicInteger();
    private static final AtomicInteger ourSeq = new AtomicInteger();
    private static final int ourReasonableThreadPoolSize = Registry.intValue((String)"core.pooled.threads");
    private static final Lazy<Boolean> ourLogDumps = LazyKt.lazy((Function0)new Function0<Boolean>(){

        public Boolean invoke() {
            try {
                return ApplicationInfoImpl.getShadowInstance().isEAP();
            }
            catch (Throwable ignore) {
                return false;
            }
        }
    });
    public static final ExecutorService INSTANCE = new ThreadPoolExecutor(3, Integer.MAX_VALUE, 300L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        @Override
        @NotNull
        public Thread newThread(@NotNull Runnable r) {
            if (r == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "r", "org/jetbrains/ide/PooledThreadExecutor$2", "newThread"));
            }
            int count = ourAliveThreads.incrementAndGet();
            Thread thread = new Thread(r, "ApplicationImpl pooled thread " + ourSeq.incrementAndGet()){

                @Override
                public void interrupt() {
                    LOG.debug("Interrupted worker, will remove from pool");
                    super.interrupt();
                }

                @Override
                public void run() {
                    try {
                        super.run();
                    }
                    catch (Throwable t) {
                        LOG.debug("Worker exits due to exception", t);
                    }
                    finally {
                        ourAliveThreads.decrementAndGet();
                    }
                }
            };
            if (count > ourReasonableThreadPoolSize && ((Boolean)ourLogDumps.getValue()).booleanValue()) {
                File file2 = PerformanceWatcher.getInstance().dumpThreads("newPooledThread/", true);
                LOG.info("Not enough pooled threads" + (file2 != null ? "; dumped threads into file '" + file2.getPath() + "'" : ""));
            }
            thread.setPriority(4);
            Thread thread2 = thread;
            if (thread2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/ide/PooledThreadExecutor$2", "newThread"));
            }
            return thread2;
        }
    });

    private PooledThreadExecutor() {
    }
}

