/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.ide.PooledThreadExecutor;
import org.jetbrains.io.NettyUtil;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"i\u0015\u0001Q!\u0001\u0005\b\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\rQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001\u0002B\u0003\u0001\u000b\u0005a\u0011!B\u0001\r\u0003\u0015\tAAA\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u001b\u0013AQ!D\u0001\u0019\fQ\u001b)!$\u0005\t\r5\t\u0001TB\r\u0004\u0011\u001di\u0011\u0001g\u0004U\u0007\u000biI\u0003B\"\u0011\u0011!i\u0011\u0001'\u0005\u0016\u0003aI\u0011t\u0003\u0003\u0003\u0011'iq!\u0003\u0002\n\u0003aI\u0011BA\u0005\u00021#A\"\u0002UB\u0001)\u000e\u0015QR\u0002E\u000b\u001b\u0005A\n\"F\u0001\u0019\bQ\u001b)!$\u0015\u0005\b!YQB\u0001G\u00011\u000f)\u0012\u0001g\u0003\u001a\n!]Q\"\u0001\r\r!\u000e\u0005\u0011\u0014\u0003\u0003\u0002\u00113iA!C\u0001\u0005\u00041\u0005\u0001$\u0004)\u0004\u0003e-A!\u0001E\u000e\u001b\u0005Ab\u0002UB\u00023'!\u0011\u0001#\b\u000e\u000b%\u0011\u0011\"\u0001M\u0010\u0019\u0003Ar\u0002U\u0002\u0003)\u000e\u0015Q\u0012\u0006\u0003D!!\u0001R\"\u0001M\u0006+\u0005AZ!g\u0006\u0005\u0005!\u0005RbB\u0005\u0003\u0013\u0005A:!\u0003\u0002\n\u0003aE\u0001D\u0003)\u0004\u0002Q\u001b)!\u0004\f\u0005\u0007BA\u0011#D\u0001%$E\u0011A\u0001\u0001E\u0012+\u0005A\"#g\u0004\t\"5!\u0011BA\u0005\u0002IGA*\u0003UB\u0001#\u000e\t\u0001b\u0005+\u0004\u000655\u0001rE\u0007\u00021#)\u0012\u0001\u0007\u000bU\u0007\u000b\tZ\u0002B\"\t\u0011\u0001i\u0011\u0001'\u0001\u0016\u0003a\tAdI)\u0004\u00075\u0011A1\u0001\u0005\u0003)\u000e\u0015\u00113\u0004\u0003D\u0011!\u0019Q\"\u0001M\u0001+\u0005A:\u0001H\u0012R\u0007\ri!\u0001\u0002\u0003\t\nQ\u001b)\u0001"}, strings={"host", "", "Lio/netty/handler/codec/http/HttpRequest;", "getHost", "(Lio/netty/handler/codec/http/HttpRequest;)Ljava/lang/String;", "NettyKt", "uriScheme", "Lio/netty/channel/Channel;", "getUriScheme", "(Lio/netty/channel/Channel;)Ljava/lang/String;", "oioClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "serverBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "group", "Lio/netty/channel/EventLoopGroup;", "addListener", "", "Lio/netty/channel/ChannelFuture;", "listener", "Lkotlin/Function1;", "closeAndShutdownEventLoop", "connect", "remoteAddress", "Ljava/net/InetSocketAddress;", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "maxAttemptCount", "", "stopCondition", "Lcom/intellij/openapi/util/Condition;", "Ljava/lang/Void;", "handler", "task", "releaseIfError", "T", "Lio/netty/buffer/ByteBuf;", "Lkotlin/Function0;", "(Lio/netty/buffer/ByteBuf;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "shutdownIfOio", "Lio/netty/channel/EventLoop;"}, moduleName="platform-impl")
public final class NettyKt {
    @NotNull
    public static final Bootstrap handler(Bootstrap $receiver, @NotNull Function1<? super Channel, Unit> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        $receiver.handler((ChannelHandler)new ChannelInitializer<Channel>(task){
            final /* synthetic */ Function1 $task;

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                this.$task.invoke((Object)channel);
            }
            {
                this.$task = $captured_local_variable$0;
            }
        });
        return $receiver;
    }

    @NotNull
    public static final ServerBootstrap serverBootstrap(@NotNull EventLoopGroup group) {
        Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
        ServerBootstrap bootstrap = (ServerBootstrap)new ServerBootstrap().group(group).channel(group instanceof NioEventLoopGroup ? NioServerSocketChannel.class : OioServerSocketChannel.class);
        bootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ServerBootstrap serverBootstrap = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)serverBootstrap, (String)"bootstrap");
        return serverBootstrap;
    }

    @NotNull
    public static final Bootstrap oioClientBootstrap() {
        Bootstrap bootstrap = (Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)new OioEventLoopGroup(1, (Executor)PooledThreadExecutor.INSTANCE))).channel(OioSocketChannel.class);
        ((Bootstrap)bootstrap.option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true);
        Bootstrap bootstrap2 = bootstrap;
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap2, (String)"bootstrap");
        return bootstrap2;
    }

    public static final void addListener(ChannelFuture $receiver, @NotNull Function1<? super ChannelFuture, Unit> listener) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        $receiver.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(listener){
            final /* synthetic */ Function1 $listener;

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                this.$listener.invoke((Object)channelFuture);
            }
            {
                this.$listener = function1;
            }
        });
    }

    public static final void shutdownIfOio(EventLoop $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof OioEventLoopGroup) {
            EventLoop eventLoop = $receiver;
            if (eventLoop == null) {
                throw new TypeCastException("null cannot be cast to non-null type io.netty.channel.oio.OioEventLoopGroup");
            }
            ((OioEventLoopGroup)eventLoop).shutdownGracefully(1L, 2L, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void closeAndShutdownEventLoop(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        EventLoop eventLoop = $receiver.eventLoop();
        try {
            $receiver.close().awaitUninterruptibly();
        }
        finally {
            NettyKt.shutdownIfOio(eventLoop);
        }
    }

    @JvmOverloads
    @Nullable
    public static final Channel connect(Bootstrap $receiver, @NotNull InetSocketAddress remoteAddress, @Nullable AsyncPromise<?> promise2, int maxAttemptCount, @Nullable Condition<Void> stopCondition) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)remoteAddress, (String)"remoteAddress");
        try {
            Condition condition = stopCondition;
            if (condition == null) {
                condition = Conditions.alwaysFalse();
            }
            return NettyUtil.doConnect($receiver, remoteAddress, promise2, maxAttemptCount, condition);
        }
        catch (Throwable e) {
            AsyncPromise<?> asyncPromise = promise2;
            Boolean bl = asyncPromise != null ? Boolean.valueOf(asyncPromise.setError(e)) : null;
            return null;
        }
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ Channel connect$default(Bootstrap bootstrap, InetSocketAddress inetSocketAddress, AsyncPromise asyncPromise, int n, Condition condition, int n2) {
        if ((n2 & 2) != 0) {
            asyncPromise = null;
        }
        if ((n2 & 4) != 0) {
            n = 20;
        }
        if ((n2 & 8) != 0) {
            condition = null;
        }
        return NettyKt.connect(bootstrap, inetSocketAddress, asyncPromise, n, (Condition<Void>)condition);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, @NotNull AsyncPromise<?> asyncPromise, int n) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, n, null, 8);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, @Nullable InetSocketAddress inetSocketAddress, AsyncPromise<?> asyncPromise) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, asyncPromise, 0, null, 12);
    }

    @JvmOverloads
    @Nullable
    public static Channel connect(@NotNull Bootstrap bootstrap, InetSocketAddress inetSocketAddress) {
        return NettyKt.connect$default(bootstrap, inetSocketAddress, null, 0, null, 14);
    }

    @NotNull
    public static final String getUriScheme(Channel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.pipeline().get(SslHandler.class) == null ? "http" : "https";
    }

    @NotNull
    public static final String getHost(HttpRequest $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        String string = $receiver.headers().getAsString((CharSequence)HttpHeaderNames.HOST);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"headers().getAsString(HttpHeaderNames.HOST)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final <T> T releaseIfError(ByteBuf $receiver, @NotNull Function0<? extends T> task) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull(task, (String)"task");
        try {
            return (T)task.invoke();
        }
        catch (Exception e) {
            try {
                $receiver.release();
            }
            finally {
                InlineMarker.finallyStart((int)1);
                throw (Throwable)e;
            }
        }
    }
}

