/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.SimpleTimer;
import com.intellij.openapi.util.SimpleTimerTask;
import gnu.trove.THashSet;
import gnu.trove.TObjectProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.util.List;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientListener;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.ClientManagerKt;
import org.jetbrains.io.jsonRpc.ExceptionHandler;
import org.jetbrains.io.webSocket.WebSocketServerOptions;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"k\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0005\u000b\u0005!\u0019!B\u0001\r\u0003\u0015\tA\"A\u0003\u0002\t\u0007)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0005\u0002\u000b\u0005!\u0011!B\u0001\t\f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!!!B\u0001\r\u0003\u0015\tAQA\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\"\u0015\tA\"A\u0003\u0002\u0019\u0005a\u0001!G\u0001\u0019\u0002\u0005\u000e\u0012\u0002\u0002\u0005\u0002\u001b\ta\t\u0001g\u0001\n\u0007!\u0011Q\"\u0001M\u0003\u0013\u0015!\u0011\u0001C\u0002\u000e\u00051\u0005\u0001tA)\u0004\u0003!!Qe\u0002E\u000b\u001b\u0005A2\"G\u0002\t\u00185\t\u0001tB\u0013\u0010\u00111i\u0011\u0001'\u0007\u001a\u0007!iQ\"\u0001M\u000e3\rA9\"D\u0001\u0019\u0010e\u0019\u0001BD\u0007\u000213)C\u0001B\u0006\t\u001e5\t\u0001dC\u0013\u000b\u0011=i\u0011\u0001G\u0006\u001a\r!}Q\u0002B\u0005\u0003\u0013\u0005Az\u0001\u0007\t&\u0007!\u0005R\"\u0001M\rK}A\u0011#D\u0001\u0019\u0017E\u0011A\u0001\u0001E\u00123\rA!#D\u0001\u0019\u000be\u0019\u0001RE\u0007\u00021MI\u0002\u0003c\n\u000e\u001d%Y\u0011BC\u0005\t\u0013\u001dI!!C\u0001\u0019\u0010%\u0011\u0011\"\u0001S\u00121UAJ\u0003$\u0001\u0019)%RAa\u0011\u0005\t\n5\t\u0001$\u0002\u000f$#\u000e\u0019QB\u0001C\u0006\u0011\u0019I#\u0002B!\t\u0011\u001biA!\u0003\u0002\n\u0003a=\u0001dB)\u0004\u0003\u0015\u0001\u0011F\u0003\u0003D\u0011!\u0011Q\"\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t!A\t\"K\u0006\u0005\u0003\"A\u0011\"D\u0003\u0011\u0015U\u0011A\u0012\u0001M\n1'\t6!A\u0003\u0001S!!\u0011\t\u0003\u0005\u0002\u001b\ta\t\u0001g\u0001R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/io/jsonRpc/ClientManager;", "Lcom/intellij/openapi/Disposable;", "listener", "Lorg/jetbrains/io/jsonRpc/ClientListener;", "exceptionHandler", "Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "options", "Lorg/jetbrains/io/webSocket/WebSocketServerOptions;", "(Lorg/jetbrains/io/jsonRpc/ClientListener;Lorg/jetbrains/io/jsonRpc/ExceptionHandler;Lorg/jetbrains/io/webSocket/WebSocketServerOptions;)V", "clientCount", "", "getClientCount", "()I", "clients", "Lgnu/trove/THashSet;", "Lorg/jetbrains/io/jsonRpc/Client;", "getExceptionHandler", "()Lorg/jetbrains/io/jsonRpc/ExceptionHandler;", "heartbeatTimer", "Lcom/intellij/openapi/util/SimpleTimerTask;", "kotlin.jvm.PlatformType", "addClient", "", "client", "disconnectClient", "", "context", "Lio/netty/channel/ChannelHandlerContext;", "closeChannel", "dispose", "forEachClient", "procedure", "Lgnu/trove/TObjectProcedure;", "hasClients", "send", "T", "messageId", "message", "Lio/netty/buffer/ByteBuf;", "results", "", "Lorg/jetbrains/concurrency/Promise;", "Lkotlin/Pair;"}, moduleName="built-in-server")
public final class ClientManager
implements Disposable {
    private final SimpleTimerTask heartbeatTimer;
    private final THashSet<Client> clients;
    private final ClientListener listener;
    @NotNull
    private final ExceptionHandler exceptionHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addClient(@NotNull Client client) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        THashSet<Client> lock$iv = this.clients;
        synchronized (lock$iv) {
            boolean bl = this.clients.add((Object)client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getClientCount() {
        int n;
        THashSet<Client> lock$iv = this.clients;
        synchronized (lock$iv) {
            n = this.clients.size();
        }
        return n;
    }

    public final boolean hasClients() {
        return this.getClientCount() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        try {
            this.heartbeatTimer.cancel();
        }
        finally {
            THashSet<Client> lock$iv = this.clients;
            synchronized (lock$iv) {
                this.clients.clear();
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final <T> void send(int messageId, @NotNull ByteBuf message, @Nullable List<Promise<Pair<Client, T>>> results) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.forEachClient((TObjectProcedure<Client>)((TObjectProcedure)new TObjectProcedure<Client>(this, messageId, message, results){
            private boolean first;
            final /* synthetic */ ClientManager this$0;
            final /* synthetic */ int $messageId;
            final /* synthetic */ ByteBuf $message;
            final /* synthetic */ List $results;

            public boolean execute(@NotNull Client client) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
                try {
                    Boolean bl;
                    AsyncPromise<T> asyncPromise = client.send(this.$messageId, this.first ? this.$message : this.$message.duplicate());
                    if (asyncPromise == null) {
                        Intrinsics.throwNpe();
                    }
                    AsyncPromise<T> result2 = asyncPromise;
                    this.first = false;
                    List list = this.$results;
                    if (list != null) {
                        AsyncPromise<T> asyncPromise2 = result2;
                        Intrinsics.checkExpressionValueIsNotNull(asyncPromise2, (String)"result");
                        bl = list.add(asyncPromise2);
                    } else {
                        bl = null;
                    }
                }
                catch (Throwable e) {
                    this.this$0.getExceptionHandler().exceptionCaught(e);
                }
                return true;
            }
            {
                this.this$0 = $outer;
                this.$messageId = $captured_local_variable$1;
                this.$message = $captured_local_variable$2;
                this.$results = $captured_local_variable$3;
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean disconnectClient(@NotNull ChannelHandlerContext context, @NotNull Client client, boolean closeChannel) {
        Unit unit;
        ClientListener clientListener;
        void lock$iv;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        THashSet<Client> tHashSet = this.clients;
        synchronized (lock$iv) {
            block11: {
                if (this.clients.remove((Object)client)) break block11;
                boolean bl = false;
                return bl;
            }
            Unit unit2 = Unit.INSTANCE;
        }
        try {
            context.attr(ClientManagerKt.getCLIENT()).remove();
            if (closeChannel) {
                context.channel().close();
            }
            client.rejectAsyncResults(this.exceptionHandler);
            clientListener = this.listener;
        }
        catch (Throwable throwable) {
            Unit unit3;
            ClientListener clientListener2 = this.listener;
            if (clientListener2 != null) {
                clientListener2.disconnected(client);
                unit3 = Unit.INSTANCE;
            } else {
                unit3 = null;
            }
            throw throwable;
        }
        if (clientListener != null) {
            clientListener.disconnected(client);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forEachClient(@NotNull TObjectProcedure<Client> procedure) {
        Intrinsics.checkParameterIsNotNull(procedure, (String)"procedure");
        THashSet<Client> lock$iv = this.clients;
        synchronized (lock$iv) {
            if (this.clients.isEmpty()) {
                return;
            }
            boolean bl = this.clients.forEach(procedure);
        }
    }

    @NotNull
    public final ExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public ClientManager(@Nullable ClientListener listener, @NotNull ExceptionHandler exceptionHandler, @Nullable WebSocketServerOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)exceptionHandler, (String)"exceptionHandler");
        this.listener = listener;
        this.exceptionHandler = exceptionHandler;
        SimpleTimer simpleTimer = SimpleTimer.getInstance();
        Runnable runnable2 = new Runnable(this){
            final /* synthetic */ ClientManager this$0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                THashSet lock$iv = ClientManager.access$getClients$p(this.this$0);
                synchronized (lock$iv) {
                    if (ClientManager.access$getClients$p(this.this$0).isEmpty()) {
                        return;
                    }
                    boolean bl = ClientManager.access$getClients$p(this.this$0).forEach((TObjectProcedure)heartbeatTimer.1.1.INSTANCE);
                }
            }
            {
                this.this$0 = clientManager;
            }
        };
        WebSocketServerOptions webSocketServerOptions = options;
        if (webSocketServerOptions == null) {
            webSocketServerOptions = new WebSocketServerOptions();
        }
        this.heartbeatTimer = simpleTimer.setUp(runnable2, (long)webSocketServerOptions.heartbeatDelay);
        this.clients = new THashSet();
    }

    public /* synthetic */ ClientManager(ClientListener clientListener, ExceptionHandler exceptionHandler, WebSocketServerOptions webSocketServerOptions, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            webSocketServerOptions = null;
        }
        this(clientListener, exceptionHandler, webSocketServerOptions);
    }

    @NotNull
    public static final /* synthetic */ THashSet access$getClients$p(ClientManager $this) {
        return $this.clients;
    }
}

