/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import gnu.trove.THashMap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtf8Writer;
import io.netty.buffer.ByteBufUtilEx;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Charsets;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonRpcServerKt;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.jsonRpc.MessageServer;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0003\u0004)\u0011\u0001D\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0005\b\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001C\u0002\u000b\u0005A\t\"B\u0001\t\u0001\u0015\tA!A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0005\u0005\u000b\u0005!1!B\u0001\t\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u0003!5Q!\u0001\u0003\u0004\u000b\u0005AY!B\u0001\u0005\u0007\u0015\t\u0001\u0012E\u0003\u0002\u0019\u0005)\u0011\u0001\u0002\u0002\r\u0001e\t\u0001\u0014AQ\u0007\u0013\rA\u0011!D\u0001\u0019\u0004E\u001b\u0011\u0001\u0003\u0002&H!-Q\u0002B\u0005\u0003\u0013\u0005!k\u0001\u0007\u0004\u0012\u0005\u0011\u0001\u0001RB\r\u0004\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\u00043\rA\t\"D\u0001\u0019\beY\u0001\"C\u0007\u0007\u0013\u0011!\t!\u0003\u0002\r\u0002aQ\u00014C\t\u0003\u0019\u0003A\"\"U\u0002\u0002\u0011+);\u0005B\u0001\t\u00175\t\u0001tC\r\u0004\u00111i\u0011\u0001'\u0007\u001a\u0007!iQ\"\u0001M\u000e3\u0011A\u0001\"\u0004\u0002\r\u0002a\u001d\u0011\u0004\u0002E\t\u001b\ta\t\u0001g\u0002\u001a\u000b!IQbA\u0005\u0002\t\u0007A\u001a\"\u0007\u0003\t\u001d5\u0011A\u0012\u0001M\f#\u000e\t\u0001RDS)\t\u0005Aq\"D\u0001\u0019\u0018e\u0019\u0001\u0002D\u0007\u000213IB\u0001B\u0001\t 5\t\u00014D\r\u0006\t\u0005A\u0001\"\u0004\u0002\r\u0002a\u001d\u0011$\u0002\u0003\u0002\u0011#i!\u0001$\u0001\u0019\be)A!\u0001\u0005\u000f\u001b\ta\t\u0001g\u0006\u001a\r\u0011\t\u0001\"C\u0007\u0004\u0013\u0005!\u0019\u0001g\u0005R\u0007\u0005A\u0001#j\u000b\u0005\u0003!\u0005R\"\u0001\r\u00123\rA\u0019#D\u0001\u0019\u0018e)\u0001\"C\u0007\u0004\u0013\u0005!\u0019\u0001g\u0005\u001a\t!\u0011RB\u0001G\u00011K\t6!\u0001\u0005\u0014K1!1\u0002c\n\u000e\u0003a\t\u0012d\u0001\u0005\b\u001b\u0005Az!G\u0002\t)5\t\u0001\u0014F\u0013\u0011\t\u0005AQ#D\u0001\u0019#e\u0019\u0001bB\u0007\u00021\u001fI2\u0001c\u000b\u000e\u0003a\u001d\u0011d\u0001E\u0010\u001b\u0005AZ\"\n\n\t-5\t\u0001$E\r\u0004\u0011[i\u0011\u0001g\u0002\u001a\u000b!9RbA\u0005\u0002\t\u0007AB!\u0007\u0003\u0005\u0003!=R\"\u0001\r\u0019KwA\t$D\u0001\u0019#e\u0019\u0001bB\u0007\u00021\u001fI2\u0001\u0003\u0005\u000e\u0003a\u001d\u0011d\u0001E\t\u001b\u0005A:!G\u0006\t\u001351\u0011\u0002\u0002C\u0001\u0013\ta\t\u0001\u0007\u0006\u0019\u0014E\u0011A\u0012\u0001\r\u000b#\u000e\t\u0001\"G\u0013\u0011\u0011gi\u0011\u0001G\t\u001a\u0007!9Q\"\u0001M\b3\rAy\"D\u0001\u0019\u001ce!\u0001\u0002F\u0007\u0003\u0019\u0003AJ#J\t\t55\t\u0001$E\r\u0004\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!}Q\"\u0001M\u000e3\u0015!\u0011\u0001\u0003\b\u000e\u00051\u0005\u0001tCS/\t\u0005A)$D\u0001\u0019#E\u0011A\u0001\u0001E\u00073\rAy\"D\u0001\u0019\u001ce!\u0001\u0002C\u0007\u0003\u0019\u0003A:!\u0007\u0003\t\u00125\u0011A\u0012\u0001M\u00043AA1$\u0004\b\n\u0017%Q\u0011\u0002C\u0005\b\u0013\tI\u0011\u0001g\u0004\n\u0005%\tAU\u0002\r\u001d1\u0019a\t\u0001g\u000e\u001a\u000b!IQbA\u0005\u0002\t\u0007A\u001a\"U\u0002\u0002\u0011s)[\u0006#\u000e\u000e\u0003a\t\u0012C\u0001\u0003\u0001\u0011\u001bI2\u0001\u0003\u0005\u000e\u0003a\u001d\u0011d\u0001E\t\u001b\u0005A:!\u0007\t\t75q\u0011bC\u0005\u000b\u0013!Iq!\u0003\u0002\n\u0003a=\u0011BA\u0005\u0002I\u001bAB\u0004\u0007\u0004\r\u0002a]\u0012d\u0003\u0005\n\u001b\u0019IA\u0001\"\u0001\n\u00051\u0005\u0001D\u0003M\n#\ta\t\u0001\u0007\u0006R\u0007\u0005AQ$j\u000e\t<5\t\u0001\u0004G\r\u0004\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\u00043\rA\t\"D\u0001\u0019\be\u0019\u0001BD\u0007\u00021/IR\u0001C\u0005\u000e\u0007%\tA1\u0001M\n#\u000e\t\u0001BH\u0015\b\t\u0005C\u0001\"A\u0007\u00021\u0007\t6!A\u0003\u0001S=!\u0011\t\u0003E\u0003\u001b%I!!C\u0001\u0019\b%!\u0011bA\u0005\u0002\t\u0007AB\u0001G\u0002R\u0007\u0005)\u0001!K\u0004\u0005\u0003\"AI!D\u0001\u0019\u000bE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/io/jsonRpc/JsonRpcServer;", "Lorg/jetbrains/io/jsonRpc/MessageServer;", "clientManager", "Lorg/jetbrains/io/jsonRpc/ClientManager;", "(Lorg/jetbrains/io/jsonRpc/ClientManager;)V", "domains", "Lgnu/trove/THashMap;", "", "Lcom/intellij/openapi/util/NotNullLazyValue;", "messageIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "call", "Lorg/jetbrains/concurrency/Promise;", "T", "client", "Lorg/jetbrains/io/jsonRpc/Client;", "domain", "command", "params", "", "", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)Lorg/jetbrains/concurrency/Promise;", "doEncodeMessage", "Lio/netty/buffer/ByteBuf;", "byteBufAllocator", "Lio/netty/buffer/ByteBufAllocator;", "id", "", "rawData", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;[Ljava/lang/Object;Lio/netty/buffer/ByteBuf;)Lio/netty/buffer/ByteBuf;", "encodeMessage", "messageId", "(Lio/netty/buffer/ByteBufAllocator;ILjava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Lio/netty/buffer/ByteBuf;", "encodeParameters", "", "buffer", "_sb", "Ljava/lang/StringBuilder;", "(Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;Ljava/lang/StringBuilder;)V", "messageReceived", "message", "", "processClientError", "error", "registerDomain", "name", "commands", "overridable", "", "send", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/Object;)V", "sendErrorResponse", "sendResponse", "sendToClients", "results", "", "Lkotlin/Pair;", "(ILjava/lang/String;Ljava/lang/String;Ljava/util/List;[Ljava/lang/Object;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;[Ljava/lang/Object;)V", "sendWithRawPart", "(Lorg/jetbrains/io/jsonRpc/Client;Ljava/lang/String;Ljava/lang/String;Lio/netty/buffer/ByteBuf;[Ljava/lang/Object;)Z"}, moduleName="built-in-server")
public final class JsonRpcServer
implements MessageServer {
    private final AtomicInteger messageIdCounter;
    private final THashMap<String, NotNullLazyValue<?>> domains;
    private final ClientManager clientManager;

    public final void registerDomain(@NotNull String name, @NotNull NotNullLazyValue<?> commands, boolean overridable) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        if (this.domains.containsKey((Object)name)) {
            if (overridable) {
                return;
            }
            throw (Throwable)new IllegalArgumentException(name + " is already registered");
        }
        this.domains.put((Object)name, commands);
    }

    public static /* bridge */ /* synthetic */ void registerDomain$default(JsonRpcServer jsonRpcServer, String string, NotNullLazyValue notNullLazyValue, boolean bl, int n) {
        if ((n & 4) != 0) {
            bl = false;
        }
        jsonRpcServer.registerDomain(string, notNullLazyValue, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    public void messageReceived(@NotNull Client client, @NotNull CharSequence message) {
        Method[] methods;
        Object[] parameters;
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("IN " + message);
        }
        JsonReaderEx reader = new JsonReaderEx(message);
        reader.beginArray();
        int messageId = Intrinsics.areEqual((Object)reader.peek(), (Object)JsonToken.NUMBER) ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncPromise promise2 = (AsyncPromise)client.messageCallbackMap.remove(messageId);
            if (domainName.charAt(0) == 'r') {
                if (promise2 == null) {
                    JsonRpcServerKt.access$getLOG$p().error("Response with id " + messageId + " was already processed");
                    return;
                }
                promise2.setResult(JsonUtil.nextAny(reader));
            } else {
                AsyncPromise asyncPromise = promise2;
                if (asyncPromise == null) {
                    Intrinsics.throwNpe();
                }
                asyncPromise.setError("error");
            }
            return;
        }
        NotNullLazyValue domainHolder = (NotNullLazyValue)this.domains.get((Object)domainName);
        if (domainHolder == null) {
            this.processClientError(client, "Cannot find domain " + domainName, messageId);
            return;
        }
        Object domain = domainHolder.getValue();
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, messageId, message);
            return;
        }
        if (reader.hasNext()) {
            SmartList list = new SmartList();
            JsonUtil.readListBody(reader, (List)list);
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)((Collection)list));
            Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ArrayUtil.toObjectArray(list)");
            parameters = objectArray;
        } else {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtilRt.EMPTY_OBJECT_ARRAY, (String)"ArrayUtilRt.EMPTY_OBJECT_ARRAY");
            parameters = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        boolean isStatic = domain instanceof Class;
        if (isStatic) {
            Object object = domain;
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            Method[] methodArray = ((Class)object).getDeclaredMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"(domain as Class<*>).declaredMethods");
            methods = methodArray;
        } else {
            Method[] methodArray = domain.getClass().getMethods();
            Intrinsics.checkExpressionValueIsNotNull((Object)methodArray, (String)"domain.javaClass.methods");
            methods = methodArray;
        }
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!Intrinsics.areEqual((Object)method.getName(), (Object)command)) continue;
            method.setAccessible(true);
            Object result2 = method.invoke(isStatic ? null : domain, Arrays.copyOf(parameters, parameters.length));
            if (messageId != -1) {
                if (result2 instanceof ByteBuf) {
                    ByteBuf byteBuf = (ByteBuf)result2;
                    try {
                        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
                        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, (ByteBuf)result2, null, 44));
                    }
                    catch (Exception e$iv) {
                        try {
                            void $receiver$iv;
                            $receiver$iv.release();
                        }
                        finally {
                            throw (Throwable)e$iv;
                        }
                    }
                } else {
                    void elements$iv;
                    ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
                    Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
                    Object[] $receiver$iv = new Object[]{result2};
                    ByteBuf byteBuf = null;
                    String string = null;
                    String string2 = null;
                    int n = messageId;
                    ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
                    JsonRpcServer jsonRpcServer = this;
                    Client client2 = client;
                    Object[] objectArray = (Object[])elements$iv;
                    client2.send(JsonRpcServer.encodeMessage$default(jsonRpcServer, byteBufAllocator2, n, string2, string, byteBuf, objectArray, 28));
                }
            }
            return;
        }
        this.processClientError(client, "Cannot find method " + domain + "." + command, messageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processClientError(Client client, String error, int messageId) {
        try {
            JsonRpcServerKt.access$getLOG$p().error(error);
        }
        finally {
            if (messageId != -1) {
                this.sendErrorResponse(client, messageId, error);
            }
        }
    }

    public final void sendResponse(@NotNull Client client, int messageId, @Nullable ByteBuf rawData) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, null, null, rawData, null, 44));
    }

    public static /* bridge */ /* synthetic */ void sendResponse$default(JsonRpcServer jsonRpcServer, Client client, int n, ByteBuf byteBuf, int n2) {
        if ((n2 & 4) != 0) {
            byteBuf = null;
        }
        jsonRpcServer.sendResponse(client, n, byteBuf);
    }

    /*
     * WARNING - void declaration
     */
    public final void sendErrorResponse(@NotNull Client client, int messageId, @Nullable CharSequence message) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        CharSequence[] charSequenceArray = new CharSequence[]{message};
        ByteBuf byteBuf = null;
        String string = null;
        String string2 = "e";
        int n = messageId;
        ByteBufAllocator byteBufAllocator2 = byteBufAllocator;
        JsonRpcServer jsonRpcServer = this;
        Client client2 = client;
        Object[] objectArray = (Object[])elements$iv;
        client2.send(JsonRpcServer.encodeMessage$default(jsonRpcServer, byteBufAllocator2, n, string2, string, byteBuf, objectArray, 24));
    }

    public final boolean sendWithRawPart(@NotNull Client client, @NotNull String domain, @NotNull String command, @NotNull ByteBuf rawData, @NotNull Object[] params) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)rawData, (String)"rawData");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        return client.send(this.encodeMessage(byteBufAllocator, -1, domain, command, rawData, params)).cause() == null;
    }

    public final void send(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        client.send(JsonRpcServer.encodeMessage$default(this, byteBufAllocator, -1, domain, command, null, params, 16));
    }

    @NotNull
    public final <T> Promise<T> call(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)client), (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        int messageId = this.messageIdCounter.getAndIncrement();
        ByteBufAllocator byteBufAllocator = client.getByteBufAllocator();
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"client.byteBufAllocator");
        ByteBuf message = JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16);
        AsyncPromise asyncPromise = client.send(messageId, message);
        if (asyncPromise == null) {
            Intrinsics.throwNpe();
        }
        return (Promise)asyncPromise;
    }

    public final <T> void sendToClients(@NotNull String domain, @NotNull String command, @Nullable List<Promise<Pair<Client, T>>> results, Object ... params) {
        Intrinsics.checkParameterIsNotNull((Object)domain, (String)"domain");
        Intrinsics.checkParameterIsNotNull((Object)command, (String)"command");
        Intrinsics.checkParameterIsNotNull((Object)params, (String)"params");
        if (this.clientManager.hasClients()) {
            this.sendToClients(results == null ? -1 : this.messageIdCounter.getAndIncrement(), domain, command, results, params);
        }
    }

    private final <T> void sendToClients(int messageId, String domain, String command, List<Promise<Pair<Client, T>>> results, Object[] params) {
        ByteBufAllocator byteBufAllocator = ByteBufAllocator.DEFAULT;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBufAllocator, (String)"ByteBufAllocator.DEFAULT");
        this.clientManager.send(messageId, JsonRpcServer.encodeMessage$default(this, byteBufAllocator, messageId, domain, command, null, params, 16), results);
    }

    private final ByteBuf encodeMessage(ByteBufAllocator byteBufAllocator, int messageId, String domain, String command, ByteBuf rawData, Object[] params) {
        ByteBuf buffer = this.doEncodeMessage(byteBufAllocator, messageId, domain, command, params, rawData);
        if (JsonRpcServerKt.access$getLOG$p().isDebugEnabled()) {
            JsonRpcServerKt.access$getLOG$p().debug("OUT " + buffer.toString(Charsets.getUTF_8()));
        }
        return buffer;
    }

    static /* bridge */ /* synthetic */ ByteBuf encodeMessage$default(JsonRpcServer jsonRpcServer, ByteBufAllocator byteBufAllocator, int n, String string, String string2, ByteBuf byteBuf, Object[] objectArray, int n2) {
        if ((n2 & 2) != 0) {
            n = -1;
        }
        if ((n2 & 4) != 0) {
            string = null;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            byteBuf = null;
        }
        if ((n2 & 0x20) != 0) {
            Intrinsics.checkExpressionValueIsNotNull((Object)ArrayUtil.EMPTY_OBJECT_ARRAY, (String)"ArrayUtil.EMPTY_OBJECT_ARRAY");
            objectArray = ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        return jsonRpcServer.encodeMessage(byteBufAllocator, n, string, string2, byteBuf, objectArray);
    }

    private final ByteBuf doEncodeMessage(ByteBufAllocator byteBufAllocator, int id, String domain, String command, Object[] params, ByteBuf rawData) {
        ByteBuf buffer = byteBufAllocator.ioBuffer();
        JsonRpcServerKt.access$writeByte(buffer, '[');
        StringBuilder sb = null;
        if (id != -1) {
            sb = new StringBuilder();
            CharSequence charSequence = sb.append(id);
            Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"sb.append(id)");
            JsonRpcServerKt.access$writeAscii(buffer, charSequence);
            sb.setLength(0);
        }
        if (domain != null) {
            if (id != -1) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            }
            JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(JsonRpcServerKt.access$writeByte(buffer, '\"'), domain), '\"');
            if (command != null) {
                JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeAscii(JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeByte(buffer, ','), '\"'), command), '\"');
            }
        }
        ByteBuf effectiveBuffer = buffer;
        if (ArraysKt.isNotEmpty((Object[])params) || rawData != null) {
            JsonRpcServerKt.access$writeByte(JsonRpcServerKt.access$writeByte(buffer, ','), '[');
            ByteBuf byteBuf = buffer;
            Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
            this.encodeParameters(byteBuf, params, sb);
            if (rawData != null) {
                if (ArraysKt.isNotEmpty((Object[])params)) {
                    JsonRpcServerKt.access$writeByte(buffer, ',');
                }
                effectiveBuffer = (ByteBuf)byteBufAllocator.compositeBuffer().addComponent(buffer).addComponent(rawData);
                buffer = byteBufAllocator.ioBuffer();
            }
            JsonRpcServerKt.access$writeByte(buffer, ']');
        }
        JsonRpcServerKt.access$writeByte(buffer, ']');
        ByteBuf byteBuf = buffer;
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuf, (String)"buffer");
        return JsonRpcServerKt.access$addBuffer(effectiveBuffer, byteBuf);
    }

    private final void encodeParameters(ByteBuf buffer, Object[] params, StringBuilder _sb) {
        StringBuilder sb = _sb;
        JsonWriter writer = null;
        boolean hasPrev = false;
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (hasPrev) {
                JsonRpcServerKt.access$writeByte(buffer, ',');
            } else {
                hasPrev = true;
            }
            if (param instanceof CharSequence) {
                JsonUtil.escape((CharSequence)param, buffer);
                continue;
            }
            if (param == null) {
                JsonRpcServerKt.access$writeAscii(buffer, "null");
                continue;
            }
            if (param instanceof Boolean) {
                JsonRpcServerKt.access$writeAscii(buffer, param.toString());
                continue;
            }
            if (param instanceof Number) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                if (param instanceof Integer) {
                    sb.append(((Number)param).intValue());
                } else if (param instanceof Long) {
                    sb.append(((Number)param).longValue());
                } else if (param instanceof Float) {
                    sb.append(((Number)param).floatValue());
                } else if (param instanceof Double) {
                    sb.append(((Number)param).doubleValue());
                } else {
                    sb.append(param.toString());
                }
                JsonRpcServerKt.access$writeAscii(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (param instanceof Consumer) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                Object object = param;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.util.Consumer<java.lang.StringBuilder>");
                }
                ((Consumer)object).consume((Object)sb);
                ByteBufUtilEx.writeUtf8(buffer, sb);
                sb.setLength(0);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter((Writer)new ByteBufUtf8Writer(buffer));
            }
            TypeAdapter typeAdapter = JsonRpcServerKt.access$getGson$p().getAdapter(param.getClass());
            if (typeAdapter == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.google.gson.TypeAdapter<kotlin.Any>");
            }
            typeAdapter.write(writer, param);
        }
    }

    public JsonRpcServer(@NotNull ClientManager clientManager) {
        Intrinsics.checkParameterIsNotNull((Object)clientManager, (String)"clientManager");
        this.clientManager = clientManager;
        this.messageIdCounter = new AtomicInteger();
        this.domains = new THashMap();
    }
}

