/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.Gray;
import com.intellij.ui.components.AbstractScrollBarUI;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.TwoWayAnimator;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JComponent;

final class DefaultScrollBarUI
extends AbstractScrollBarUI {
    private float myTrackValue;
    private float myThumbValue;
    private TwoWayAnimator myTrackAnimator = new TwoWayAnimator("ScrollBarTrack", 6, 125, 150, 300){

        @Override
        void onFrame(int frame, int maxFrame) {
            DefaultScrollBarUI.this.myTrackValue = (float)frame / (float)maxFrame;
            DefaultScrollBarUI.this.setTrackVisible(frame > 0);
            DefaultScrollBarUI.this.repaint();
        }
    };
    private TwoWayAnimator myThumbAnimator = new TwoWayAnimator("ScrollBarThumb", 6, 125, 150, 300){

        @Override
        void onFrame(int frame, int maxFrame) {
            DefaultScrollBarUI.this.myThumbValue = (float)frame / (float)maxFrame;
            DefaultScrollBarUI.this.repaint();
        }
    };

    DefaultScrollBarUI() {
    }

    @Override
    int getThickness() {
        return this.scale(this.isOpaque() ? 13 : 14);
    }

    @Override
    int getMinimalThickness() {
        return this.scale(10);
    }

    @Override
    void onTrackHover(boolean hover) {
        if (hover) {
            this.myTrackAnimator.startForward();
        } else {
            this.myTrackAnimator.startBackward();
        }
    }

    @Override
    void onThumbHover(boolean hover) {
        if (hover) {
            this.myThumbAnimator.startForward();
        } else {
            this.myThumbAnimator.startBackward();
        }
    }

    @Override
    void paintTrack(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        Rectangle bounds = this.getAnimatedBounds(x, y, width, height, c, false);
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.1f * this.myTrackValue));
        g.setColor((Color)Gray.x80);
        g.fillRect(bounds.x, bounds.y, bounds.width, bounds.height);
        g.setComposite(old);
    }

    @Override
    void paintThumb(Graphics2D g, int x, int y, int width, int height, JComponent c) {
        Rectangle bounds = this.getAnimatedBounds(x, y, width, height, c, Registry.is((String)"ide.scroll.thumb.small.if.opaque"));
        Composite old = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.35f + 0.25f * this.myThumbValue));
        g.setColor((Color)Gray.x80);
        g.fillRect(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
        g.setColor((Color)(UIUtil.isUnderDarcula() ? Gray.x94 : Gray.x6E));
        g.drawRect(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
        g.setComposite(old);
    }

    private Rectangle getAnimatedBounds(int x, int y, int width, int height, JComponent c, boolean small) {
        Rectangle bounds = new Rectangle(x, y, width, height);
        if (!c.isOpaque()) {
            JBScrollPane.Alignment alignment = JBScrollPane.Alignment.get(c);
            if (alignment == JBScrollPane.Alignment.LEFT || alignment == JBScrollPane.Alignment.RIGHT) {
                int value = this.getAnimatedValue(width - this.getMinimalThickness());
                if (value > 0) {
                    bounds.width -= value;
                    if (alignment == JBScrollPane.Alignment.RIGHT) {
                        bounds.x += value;
                    }
                }
            } else {
                int value = this.getAnimatedValue(height - this.getMinimalThickness());
                if (value > 0) {
                    bounds.height -= value;
                    if (alignment == JBScrollPane.Alignment.BOTTOM) {
                        bounds.y += value;
                    }
                }
            }
        } else if (small) {
            ++bounds.x;
            ++bounds.y;
            bounds.width -= 2;
            bounds.height -= 2;
        }
        return bounds;
    }

    private int getAnimatedValue(int value) {
        if (!Registry.is((String)"ide.scroll.bar.expand.animation")) {
            return value;
        }
        if (this.myTrackValue <= 0.0f) {
            return value;
        }
        if (this.myTrackValue >= 1.0f) {
            return 0;
        }
        return (int)(0.5f + (float)value * (1.0f - this.myTrackValue));
    }
}

