/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.components;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeGlassPane;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.DefaultScrollBarUI;
import com.intellij.ui.components.JBViewport;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ui.ButtonlessScrollBarUI;
import com.intellij.util.ui.JBInsets;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.plaf.ScrollBarUI;
import javax.swing.plaf.ScrollPaneUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBScrollPane
extends JScrollPane {
    private int myViewportBorderWidth = -1;
    private boolean myHasOverlayScrollbars;

    public JBScrollPane(int viewportWidth) {
        this.init(false);
        this.myViewportBorderWidth = viewportWidth;
        this.updateViewportBorder();
    }

    public JBScrollPane() {
        this.init();
    }

    public JBScrollPane(Component view) {
        super(view);
        this.init();
    }

    public JBScrollPane(int vsbPolicy, int hsbPolicy) {
        super(vsbPolicy, hsbPolicy);
        this.init();
    }

    public JBScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
        super(view, vsbPolicy, hsbPolicy);
        this.init();
    }

    public static JScrollPane findScrollPane(Component c) {
        Container vp;
        if (c == null) {
            return null;
        }
        if (!(c instanceof JViewport) && (vp = c.getParent()) instanceof JViewport) {
            c = vp;
        }
        if (!((c = c.getParent()) instanceof JScrollPane)) {
            return null;
        }
        return (JScrollPane)c;
    }

    private void init() {
        this.init(true);
    }

    private void init(boolean setupCorners) {
        this.setLayout(Registry.is((String)"ide.scroll.new.layout") ? new Layout() : new ScrollPaneLayout());
        if (setupCorners) {
            this.setupCorners();
        }
    }

    protected void setupCorners() {
        this.setBorder(IdeBorderFactory.createBorder());
        this.setCorner("UPPER_RIGHT_CORNER", new Corner("UPPER_RIGHT_CORNER"));
        this.setCorner("UPPER_LEFT_CORNER", new Corner("UPPER_LEFT_CORNER"));
        this.setCorner("LOWER_RIGHT_CORNER", new Corner("LOWER_RIGHT_CORNER"));
        this.setCorner("LOWER_LEFT_CORNER", new Corner("LOWER_LEFT_CORNER"));
    }

    @Override
    public void setUI(ScrollPaneUI ui) {
        super.setUI(ui);
        this.updateViewportBorder();
    }

    @Override
    public boolean isOptimizedDrawingEnabled() {
        if (this.getLayout() instanceof Layout) {
            return JBScrollPane.isOptimizedDrawingEnabledFor(this.getVerticalScrollBar()) && JBScrollPane.isOptimizedDrawingEnabledFor(this.getHorizontalScrollBar());
        }
        return !this.myHasOverlayScrollbars;
    }

    private static boolean isOptimizedDrawingEnabledFor(JScrollBar bar) {
        return bar == null || bar.isOpaque() || !bar.isVisible();
    }

    private void updateViewportBorder() {
        this.setViewportBorder(new ViewportBorder(this.myViewportBorderWidth >= 0 ? this.myViewportBorderWidth : 1));
    }

    public static ViewportBorder createIndentBorder() {
        return new ViewportBorder(2);
    }

    @Override
    public JScrollBar createVerticalScrollBar() {
        return new MyScrollBar(1);
    }

    @Override
    @NotNull
    public JScrollBar createHorizontalScrollBar() {
        MyScrollBar myScrollBar = new MyScrollBar(0);
        if (myScrollBar == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/components/JBScrollPane", "createHorizontalScrollBar"));
        }
        return myScrollBar;
    }

    @Override
    protected JViewport createViewport() {
        return new JBViewport();
    }

    @Override
    public void layout() {
        LayoutManager layout = this.getLayout();
        ScrollPaneLayout scrollLayout = layout instanceof ScrollPaneLayout ? (ScrollPaneLayout)layout : null;
        super.layout();
        if (layout instanceof Layout) {
            return;
        }
        this.myHasOverlayScrollbars = scrollLayout != null ? this.relayoutScrollbars(this, scrollLayout, this.myHasOverlayScrollbars) : false;
    }

    private boolean relayoutScrollbars(@NotNull JComponent container, @NotNull ScrollPaneLayout layout, boolean forceRelayout) {
        boolean hasOverlayScrollbars;
        if (container == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "container", "com/intellij/ui/components/JBScrollPane", "relayoutScrollbars"));
        }
        if (layout == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/ui/components/JBScrollPane", "relayoutScrollbars"));
        }
        JViewport viewport = layout.getViewport();
        if (viewport == null) {
            return false;
        }
        JScrollBar vsb = layout.getVerticalScrollBar();
        JScrollBar hsb = layout.getHorizontalScrollBar();
        JViewport colHead = layout.getColumnHeader();
        JViewport rowHead = layout.getRowHeader();
        Rectangle viewportBounds = viewport.getBounds();
        boolean extendViewportUnderVScrollbar = vsb != null && this.shouldExtendViewportUnderScrollbar(vsb);
        boolean extendViewportUnderHScrollbar = hsb != null && this.shouldExtendViewportUnderScrollbar(hsb);
        boolean bl = hasOverlayScrollbars = extendViewportUnderVScrollbar || extendViewportUnderHScrollbar;
        if (!hasOverlayScrollbars && !forceRelayout) {
            return false;
        }
        container.setComponentZOrder(viewport, container.getComponentCount() - 1);
        if (vsb != null) {
            container.setComponentZOrder(vsb, 0);
        }
        if (hsb != null) {
            container.setComponentZOrder(hsb, 0);
        }
        if (extendViewportUnderVScrollbar) {
            int x2 = Math.max(vsb.getX() + vsb.getWidth(), viewportBounds.x + viewportBounds.width);
            viewportBounds.x = Math.min(viewportBounds.x, vsb.getX());
            viewportBounds.width = x2 - viewportBounds.x;
        }
        if (extendViewportUnderHScrollbar) {
            int y2 = Math.max(hsb.getY() + hsb.getHeight(), viewportBounds.y + viewportBounds.height);
            viewportBounds.y = Math.min(viewportBounds.y, hsb.getY());
            viewportBounds.height = y2 - viewportBounds.y;
        }
        if (extendViewportUnderVScrollbar) {
            if (hsb != null) {
                Rectangle scrollbarBounds = hsb.getBounds();
                scrollbarBounds.width = viewportBounds.x + viewportBounds.width - scrollbarBounds.x;
                hsb.setBounds(scrollbarBounds);
            }
            if (colHead != null) {
                Rectangle headerBounds = colHead.getBounds();
                headerBounds.width = viewportBounds.width;
                colHead.setBounds(headerBounds);
            }
            JBScrollPane.hideFromView(layout.getCorner("UPPER_RIGHT_CORNER"));
            JBScrollPane.hideFromView(layout.getCorner("LOWER_RIGHT_CORNER"));
        }
        if (extendViewportUnderHScrollbar) {
            if (vsb != null) {
                Rectangle scrollbarBounds = vsb.getBounds();
                scrollbarBounds.height = viewportBounds.y + viewportBounds.height - scrollbarBounds.y;
                vsb.setBounds(scrollbarBounds);
            }
            if (rowHead != null) {
                Rectangle headerBounds = rowHead.getBounds();
                headerBounds.height = viewportBounds.height;
                rowHead.setBounds(headerBounds);
            }
            JBScrollPane.hideFromView(layout.getCorner("LOWER_LEFT_CORNER"));
            JBScrollPane.hideFromView(layout.getCorner("LOWER_RIGHT_CORNER"));
        }
        viewport.setBounds(viewportBounds);
        return hasOverlayScrollbars;
    }

    private boolean shouldExtendViewportUnderScrollbar(@Nullable JScrollBar scrollbar) {
        if (scrollbar == null || !scrollbar.isVisible()) {
            return false;
        }
        return this.isOverlaidScrollbar(scrollbar);
    }

    protected boolean isOverlaidScrollbar(@Nullable JScrollBar scrollbar) {
        if (!ButtonlessScrollBarUI.isMacOverlayScrollbarSupported()) {
            return false;
        }
        ScrollBarUI vsbUI = scrollbar == null ? null : scrollbar.getUI();
        return vsbUI instanceof ButtonlessScrollBarUI && !((ButtonlessScrollBarUI)vsbUI).alwaysShowTrack();
    }

    private static void hideFromView(Component component) {
        if (component == null) {
            return;
        }
        component.setBounds(-10, -10, 1, 1);
    }

    public static boolean canBePreprocessed(MouseEvent e, JScrollBar bar) {
        ScrollBarUI ui;
        if ((e.getID() == 503 || e.getID() == 501) && (ui = bar.getUI()) instanceof BasicScrollBarUI) {
            BasicScrollBarUI bui = (BasicScrollBarUI)ui;
            try {
                Rectangle rect = (Rectangle)ReflectionUtil.getDeclaredMethod(BasicScrollBarUI.class, (String)"getThumbBounds", (Class[])ArrayUtil.EMPTY_CLASS_ARRAY).invoke((Object)bui, new Object[0]);
                Point point = SwingUtilities.convertPoint(e.getComponent(), e.getX(), e.getY(), bar);
                return !rect.contains(point);
            }
            catch (Exception e1) {
                return true;
            }
        }
        return true;
    }

    private static class Layout
    extends ScrollPaneLayout {
        private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);

        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            Border border;
            boolean hsbOnTop;
            JScrollPane pane = (JScrollPane)parent;
            Rectangle bounds = new Rectangle(pane.getWidth(), pane.getHeight());
            JBInsets.removeFrom((Rectangle)bounds, (Insets)pane.getInsets());
            Object property = pane.getClientProperty(Flip.class);
            Flip flip = property instanceof Flip ? (Flip)((Object)property) : Flip.NONE;
            boolean bl = hsbOnTop = flip == Flip.BOTH || flip == Flip.VERTICAL;
            boolean vsbOnLeft = pane.getComponentOrientation().isLeftToRight() ? flip == Flip.BOTH || flip == Flip.HORIZONTAL : flip == Flip.NONE || flip == Flip.VERTICAL;
            Rectangle rowHeadBounds = new Rectangle(bounds.x, 0, 0, 0);
            if (this.rowHead != null && this.rowHead.isVisible()) {
                rowHeadBounds.width = Layout.min(bounds.width, this.rowHead.getPreferredSize().width);
                bounds.width -= rowHeadBounds.width;
                if (vsbOnLeft) {
                    rowHeadBounds.x += bounds.width;
                } else {
                    bounds.x += rowHeadBounds.width;
                }
            }
            Rectangle colHeadBounds = new Rectangle(0, bounds.y, 0, 0);
            if (this.colHead != null && this.colHead.isVisible()) {
                colHeadBounds.height = Layout.min(bounds.height, this.colHead.getPreferredSize().height);
                bounds.height -= colHeadBounds.height;
                if (hsbOnTop) {
                    colHeadBounds.y += bounds.height;
                } else {
                    bounds.y += colHeadBounds.height;
                }
            }
            Insets insets = (border = pane.getViewportBorder()) == null ? null : border.getBorderInsets(parent);
            JBInsets.removeFrom((Rectangle)bounds, (Insets)insets);
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            boolean isEmpty = bounds.width < 0 || bounds.height < 0;
            Component view = this.viewport == null ? null : this.viewport.getView();
            Dimension viewPreferredSize = view == null ? new Dimension() : view.getPreferredSize();
            Dimension viewportExtentSize = this.viewport == null ? new Dimension() : this.viewport.toViewCoordinates(bounds.getSize());
            Scrollable scrollable = null;
            boolean viewTracksViewportWidth = false;
            boolean viewTracksViewportHeight = false;
            if (!isEmpty && view instanceof Scrollable) {
                scrollable = (Scrollable)((Object)view);
                viewTracksViewportWidth = scrollable.getScrollableTracksViewportWidth();
                viewTracksViewportHeight = scrollable.getScrollableTracksViewportHeight();
            }
            boolean vsbOpaque = false;
            boolean vsbNeeded = false;
            int vsbPolicy = pane.getVerticalScrollBarPolicy();
            if (!isEmpty && vsbPolicy != 21) {
                vsbNeeded = vsbPolicy == 22 || !viewTracksViewportHeight && viewPreferredSize.height > viewportExtentSize.height;
            }
            Rectangle vsbBounds = new Rectangle(0, bounds.y - insets.top, 0, 0);
            if (this.vsb != null) {
                vsbOpaque = this.vsb.isOpaque();
                if (vsbNeeded) {
                    this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                    if (vsbOpaque && this.viewport != null) {
                        viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                    }
                }
            }
            boolean hsbOpaque = false;
            boolean hsbNeeded = false;
            int hsbPolicy = pane.getHorizontalScrollBarPolicy();
            if (!isEmpty && hsbPolicy != 31) {
                hsbNeeded = hsbPolicy == 32 || !viewTracksViewportWidth && viewPreferredSize.width > viewportExtentSize.width;
            }
            Rectangle hsbBounds = new Rectangle(bounds.x - insets.left, 0, 0, 0);
            if (this.hsb != null) {
                hsbOpaque = this.hsb.isOpaque();
                if (hsbNeeded) {
                    this.adjustForHSB(bounds, insets, hsbBounds, hsbOpaque, hsbOnTop);
                    if (hsbOpaque && this.viewport != null && this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                        viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                        boolean bl2 = vsbNeeded = viewPreferredSize.height > viewportExtentSize.height;
                        if (vsbNeeded) {
                            this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                        }
                    }
                }
            }
            if (this.viewport != null) {
                this.viewport.setBounds(bounds);
                pane.setComponentZOrder(this.viewport, pane.getComponentCount() - 1);
                if (scrollable != null && hsbOpaque && vsbOpaque) {
                    viewTracksViewportWidth = scrollable.getScrollableTracksViewportWidth();
                    viewTracksViewportHeight = scrollable.getScrollableTracksViewportHeight();
                    viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                    boolean vsbNeededOld = vsbNeeded;
                    if (this.vsb != null && vsbPolicy == 20) {
                        boolean vsbNeededNew;
                        boolean bl3 = vsbNeededNew = !viewTracksViewportHeight && viewPreferredSize.height > viewportExtentSize.height;
                        if (vsbNeeded != vsbNeededNew) {
                            vsbNeeded = vsbNeededNew;
                            if (vsbNeeded) {
                                this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                            } else if (vsbOpaque) {
                                bounds.width += vsbBounds.width;
                            }
                            if (vsbOpaque) {
                                viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                            }
                        }
                    }
                    boolean hsbNeededOld = hsbNeeded;
                    if (this.hsb != null && hsbPolicy == 30) {
                        boolean hsbNeededNew;
                        boolean bl4 = hsbNeededNew = !viewTracksViewportWidth && viewPreferredSize.width > viewportExtentSize.width;
                        if (hsbNeeded != hsbNeededNew) {
                            hsbNeeded = hsbNeededNew;
                            if (hsbNeeded) {
                                this.adjustForHSB(bounds, insets, hsbBounds, hsbOpaque, hsbOnTop);
                            } else if (hsbOpaque) {
                                bounds.height += hsbBounds.height;
                            }
                            if (hsbOpaque && this.vsb != null && !vsbNeeded && vsbPolicy != 21) {
                                viewportExtentSize = this.viewport.toViewCoordinates(bounds.getSize());
                                boolean bl5 = vsbNeeded = viewPreferredSize.height > viewportExtentSize.height;
                                if (vsbNeeded) {
                                    this.adjustForVSB(bounds, insets, vsbBounds, vsbOpaque, vsbOnLeft);
                                }
                            }
                        }
                    }
                    if (hsbNeededOld != hsbNeeded || vsbNeededOld != vsbNeeded) {
                        this.viewport.setBounds(bounds);
                    }
                }
            }
            rowHeadBounds.y = bounds.y - insets.top;
            rowHeadBounds.height = bounds.height + insets.top + insets.bottom;
            if (this.rowHead != null) {
                this.rowHead.setBounds(rowHeadBounds);
                this.rowHead.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.RIGHT : Alignment.LEFT));
            }
            colHeadBounds.x = bounds.x - insets.left;
            colHeadBounds.width = bounds.width + insets.left + insets.right;
            if (this.colHead != null) {
                this.colHead.setBounds(colHeadBounds);
                this.colHead.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.BOTTOM : Alignment.TOP));
            }
            int overlapWidth = 0;
            int overlapHeight = 0;
            if (vsbNeeded && !vsbOpaque && hsbNeeded && !hsbOpaque) {
                overlapWidth = vsbBounds.width;
            }
            vsbBounds.y = bounds.y - insets.top;
            vsbBounds.height = bounds.height + insets.top + insets.bottom;
            if (this.vsb != null) {
                this.vsb.setVisible(vsbNeeded);
                if (vsbNeeded) {
                    if (vsbOpaque && this.colHead != null && UIManager.getBoolean("ScrollPane.fillUpperCorner") && (vsbOnLeft ? this.upperLeft : this.upperRight) == null) {
                        if (!hsbOnTop) {
                            vsbBounds.y -= colHeadBounds.height;
                        }
                        vsbBounds.height += colHeadBounds.height;
                    }
                    int overlapY = !hsbOnTop ? 0 : overlapHeight;
                    this.vsb.setBounds(vsbBounds.x, vsbBounds.y + overlapY, vsbBounds.width, vsbBounds.height - overlapHeight);
                    this.vsb.putClientProperty(Alignment.class, (Object)(vsbOnLeft ? Alignment.LEFT : Alignment.RIGHT));
                    pane.setComponentZOrder(this.vsb, 0);
                }
                if (!vsbOpaque) {
                    if (!vsbOnLeft) {
                        vsbBounds.x += vsbBounds.width;
                    }
                    vsbBounds.width = 0;
                }
            }
            hsbBounds.x = bounds.x - insets.left;
            hsbBounds.width = bounds.width + insets.left + insets.right;
            if (this.hsb != null) {
                this.hsb.setVisible(hsbNeeded);
                if (hsbNeeded) {
                    if (hsbOpaque && this.rowHead != null && UIManager.getBoolean("ScrollPane.fillLowerCorner") && (vsbOnLeft ? this.lowerRight : this.lowerLeft) == null) {
                        if (!vsbOnLeft) {
                            hsbBounds.x -= rowHeadBounds.width;
                        }
                        hsbBounds.width += rowHeadBounds.width;
                    }
                    int overlapX = !vsbOnLeft ? 0 : overlapWidth;
                    this.hsb.setBounds(hsbBounds.x + overlapX, hsbBounds.y, hsbBounds.width - overlapWidth, hsbBounds.height);
                    this.hsb.putClientProperty(Alignment.class, (Object)(hsbOnTop ? Alignment.TOP : Alignment.BOTTOM));
                }
                if (!hsbOpaque) {
                    if (!hsbOnTop) {
                        hsbBounds.y += hsbBounds.height;
                    }
                    hsbBounds.height = 0;
                }
            }
            if (this.lowerLeft != null) {
                this.lowerLeft.setBounds(vsbOnLeft ? vsbBounds.x : rowHeadBounds.x, hsbOnTop ? colHeadBounds.y : hsbBounds.y, vsbOnLeft ? vsbBounds.width : rowHeadBounds.width, hsbOnTop ? colHeadBounds.height : hsbBounds.height);
            }
            if (this.lowerRight != null) {
                this.lowerRight.setBounds(vsbOnLeft ? rowHeadBounds.x : vsbBounds.x, hsbOnTop ? colHeadBounds.y : hsbBounds.y, vsbOnLeft ? rowHeadBounds.width : vsbBounds.width, hsbOnTop ? colHeadBounds.height : hsbBounds.height);
            }
            if (this.upperLeft != null) {
                this.upperLeft.setBounds(vsbOnLeft ? vsbBounds.x : rowHeadBounds.x, hsbOnTop ? hsbBounds.y : colHeadBounds.y, vsbOnLeft ? vsbBounds.width : rowHeadBounds.width, hsbOnTop ? hsbBounds.height : colHeadBounds.height);
            }
            if (this.upperRight != null) {
                this.upperRight.setBounds(vsbOnLeft ? rowHeadBounds.x : vsbBounds.x, hsbOnTop ? hsbBounds.y : colHeadBounds.y, vsbOnLeft ? rowHeadBounds.width : vsbBounds.width, hsbOnTop ? hsbBounds.height : colHeadBounds.height);
            }
        }

        private void adjustForVSB(Rectangle bounds, Insets insets, Rectangle vsbBounds, boolean vsbOpaque, boolean vsbOnLeft) {
            vsbBounds.width = Layout.min(bounds.width, this.vsb.getPreferredSize().width);
            if (vsbOnLeft) {
                vsbBounds.x = bounds.x - insets.left;
                if (vsbOpaque) {
                    bounds.x += vsbBounds.width;
                }
            } else {
                vsbBounds.x = bounds.x + bounds.width + insets.right - vsbBounds.width;
            }
            if (vsbOpaque) {
                bounds.width -= vsbBounds.width;
            }
        }

        private void adjustForHSB(Rectangle bounds, Insets insets, Rectangle hsbBounds, boolean hsbOpaque, boolean hsbOnTop) {
            hsbBounds.height = Layout.min(bounds.height, this.hsb.getPreferredSize().height);
            if (hsbOnTop) {
                hsbBounds.y = bounds.y - insets.top;
                if (hsbOpaque) {
                    bounds.y += hsbBounds.height;
                }
            } else {
                hsbBounds.y = bounds.y + bounds.height + insets.bottom - hsbBounds.height;
            }
            if (hsbOpaque) {
                bounds.height -= hsbBounds.height;
            }
        }

        private static int min(int one, int two) {
            return Math.max(0, Math.min(one, two));
        }
    }

    static enum Alignment {
        TOP,
        LEFT,
        RIGHT,
        BOTTOM;


        static Alignment get(JComponent component) {
            if (component != null) {
                Object property = component.getClientProperty(Alignment.class);
                if (property instanceof Alignment) {
                    return (Alignment)((Object)property);
                }
                Container parent = component.getParent();
                if (parent instanceof JScrollPane) {
                    JScrollPane pane = (JScrollPane)parent;
                    if (component == pane.getColumnHeader()) {
                        return TOP;
                    }
                    if (component == pane.getHorizontalScrollBar()) {
                        return BOTTOM;
                    }
                    boolean ltr = pane.getComponentOrientation().isLeftToRight();
                    if (component == pane.getVerticalScrollBar()) {
                        return ltr ? RIGHT : LEFT;
                    }
                    if (component == pane.getRowHeader()) {
                        return ltr ? LEFT : RIGHT;
                    }
                }
            }
            return null;
        }
    }

    public static enum Flip {
        NONE,
        VERTICAL,
        HORIZONTAL,
        BOTH;

    }

    private static class ViewportBorder
    extends LineBorder {
        public ViewportBorder(int thickness) {
            super(null, thickness);
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            this.updateColor(c);
            super.paintBorder(c, g, x, y, width, height);
        }

        private void updateColor(Component c) {
            if (!(c instanceof JScrollPane)) {
                return;
            }
            JViewport vp = ((JScrollPane)c).getViewport();
            if (vp == null) {
                return;
            }
            Component view = vp.getView();
            if (view == null) {
                return;
            }
            this.lineColor = view.getBackground();
        }
    }

    private static class Corner
    extends JPanel {
        private final String myPos;

        public Corner(String pos) {
            this.myPos = pos;
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBackgroundDefault());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor((Color)ButtonlessScrollBarUI.getTrackBorderColorDefault());
            int x2 = this.getWidth() - 1;
            int y2 = this.getHeight() - 1;
            if (this.myPos == "UPPER_LEFT_CORNER" || this.myPos == "UPPER_RIGHT_CORNER") {
                g.drawLine(0, y2, x2, y2);
            }
            if (this.myPos == "LOWER_LEFT_CORNER" || this.myPos == "LOWER_RIGHT_CORNER") {
                g.drawLine(0, 0, x2, 0);
            }
            if (this.myPos == "UPPER_LEFT_CORNER" || this.myPos == "LOWER_LEFT_CORNER") {
                g.drawLine(x2, 0, x2, y2);
            }
            if (this.myPos == "UPPER_RIGHT_CORNER" || this.myPos == "LOWER_RIGHT_CORNER") {
                g.drawLine(0, 0, 0, y2);
            }
        }
    }

    private class MyScrollBar
    extends JScrollPane.ScrollBar
    implements IdeGlassPane.TopComponent {
        public MyScrollBar(int orientation) {
            super(JBScrollPane.this, orientation);
        }

        @Override
        public void updateUI() {
            this.setUI(!SystemInfo.isMac && Registry.is((String)"ide.scroll.new.layout") ? new DefaultScrollBarUI() : ButtonlessScrollBarUI.createNormal());
        }

        @Override
        public boolean canBePreprocessed(MouseEvent e) {
            return JBScrollPane.canBePreprocessed(e, this);
        }
    }
}

