/*
 * Decompiled with CFR 0.152.
 */
package lombok.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationsUtil {
    public static final Pattern PRIMITIVE_TYPE_NAME_PATTERN = Pattern.compile("^(boolean|byte|short|int|long|float|double|char)$");
    public static final Pattern NON_NULL_PATTERN = Pattern.compile("^(?:nonnull)$", 2);
    public static final Pattern NULLABLE_PATTERN = Pattern.compile("^(?:nullable|checkfornull)$", 2);

    private TransformationsUtil() {
    }

    public static String toGetterName(CharSequence fieldName, boolean isBoolean) {
        String prefix;
        String string = prefix = isBoolean ? "is" : "get";
        if (fieldName.length() == 0) {
            return prefix;
        }
        if (isBoolean && ((Object)fieldName).toString().startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
            return ((Object)fieldName).toString();
        }
        return TransformationsUtil.buildName(prefix, ((Object)fieldName).toString());
    }

    public static String toSetterName(CharSequence fieldName, boolean isBoolean) {
        if (fieldName.length() == 0) {
            return "set";
        }
        if (isBoolean && ((Object)fieldName).toString().startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
            return "set" + ((Object)fieldName).toString().substring(2);
        }
        return TransformationsUtil.buildName("set", ((Object)fieldName).toString());
    }

    private static String buildName(String prefix, String suffix) {
        if (suffix.length() == 0) {
            return prefix;
        }
        char first = suffix.charAt(0);
        if (Character.isLowerCase(first)) {
            boolean useUpperCase = suffix.length() > 2 && (Character.isTitleCase(suffix.charAt(1)) || Character.isUpperCase(suffix.charAt(1)));
            suffix = String.format("%s%s", Character.valueOf(useUpperCase ? Character.toUpperCase(first) : Character.toTitleCase(first)), suffix.subSequence(1, suffix.length()));
        }
        return String.format("%s%s", prefix, suffix);
    }

    public static List<String> toAllGetterNames(CharSequence fieldName, boolean isBoolean) {
        if (!isBoolean) {
            return Collections.singletonList(TransformationsUtil.toGetterName(fieldName, false));
        }
        ArrayList<String> baseNames = new ArrayList<String>();
        baseNames.add(((Object)fieldName).toString());
        if (((Object)fieldName).toString().startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
            baseNames.add(((Object)fieldName).toString().substring(2));
        }
        HashSet<String> names = new HashSet<String>();
        for (String baseName : baseNames) {
            if (baseName.length() > 0 && Character.isLowerCase(baseName.charAt(0))) {
                baseName = Character.toTitleCase(baseName.charAt(0)) + baseName.substring(1);
            }
            names.add("is" + baseName);
            names.add("get" + baseName);
        }
        return new ArrayList<String>(names);
    }

    public static List<String> toAllSetterNames(CharSequence fieldName, boolean isBoolean) {
        if (!isBoolean) {
            return Collections.singletonList(TransformationsUtil.toSetterName(fieldName, false));
        }
        ArrayList<String> baseNames = new ArrayList<String>();
        baseNames.add(((Object)fieldName).toString());
        if (((Object)fieldName).toString().startsWith("is") && fieldName.length() > 2 && !Character.isLowerCase(fieldName.charAt(2))) {
            baseNames.add(((Object)fieldName).toString().substring(2));
        }
        HashSet<String> names = new HashSet<String>();
        for (String baseName : baseNames) {
            if (baseName.length() > 0 && Character.isLowerCase(baseName.charAt(0))) {
                baseName = Character.toTitleCase(baseName.charAt(0)) + baseName.substring(1);
            }
            names.add("set" + baseName);
        }
        return new ArrayList<String>(names);
    }
}

