/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.icons.AllIcons;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.indexing.JavaFxControllerClassIndex;

public class JavaFxRelatedItemLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaFxRelatedItemLineMarkerProvider.class.getName()));

    protected void collectNavigationMarkers(@NotNull PsiElement element, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiClass containingClass;
        PsiField field;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/JavaFxRelatedItemLineMarkerProvider", "collectNavigationMarkers"));
        }
        if (element instanceof PsiField && JavaFxPsiUtil.isVisibleInFxml((PsiMember)(field = (PsiField)element)) && !field.hasModifierProperty("static") && !field.hasModifierProperty("final") && (containingClass = field.getContainingClass()) != null && containingClass.hasModifierProperty("public") && containingClass.getQualifiedName() != null) {
            PsiMethod[] constructors = containingClass.getConstructors();
            boolean defaultConstructor = constructors.length == 0;
            for (PsiMethod constructor : constructors) {
                if (constructor.getParameterList().getParametersCount() != 0) continue;
                defaultConstructor = true;
                break;
            }
            if (!defaultConstructor) {
                return;
            }
            ArrayList targets = new ArrayList();
            JavaFxRelatedItemLineMarkerProvider.collectTargets(field, targets, new Function<PsiElement, GotoRelatedItem>(){

                public GotoRelatedItem fun(PsiElement element) {
                    return new GotoRelatedItem(element);
                }
            }, true);
            if (targets.isEmpty()) {
                return;
            }
            result.add((RelatedItemLineMarkerInfo)new RelatedItemLineMarkerInfo((PsiElement)field, field.getNameIdentifier().getTextRange(), AllIcons.FileTypes.Xml, 6, null, (GutterIconNavigationHandler)new JavaFXIdIconNavigationHandler(), GutterIconRenderer.Alignment.LEFT, targets));
        }
    }

    private static <T> void collectTargets(PsiField field, final ArrayList<T> targets, final Function<PsiElement, T> fun, final boolean stopAtFirst) {
        PsiClass containingClass = field.getContainingClass();
        LOG.assertTrue(containingClass != null);
        String qualifiedName = containingClass.getQualifiedName();
        LOG.assertTrue(qualifiedName != null);
        List<VirtualFile> fxmls = JavaFxControllerClassIndex.findFxmlsWithController(field.getProject(), qualifiedName);
        if (fxmls.isEmpty()) {
            return;
        }
        ReferencesSearch.search((PsiElement)field, (SearchScope)GlobalSearchScope.filesScope((Project)field.getProject(), fxmls)).forEach((Processor)new Processor<PsiReference>(){

            public boolean process(PsiReference reference) {
                PsiElement referenceElement = reference.getElement();
                if (referenceElement == null) {
                    return true;
                }
                PsiFile containingFile = referenceElement.getContainingFile();
                if (containingFile == null) {
                    return true;
                }
                if (!JavaFxFileTypeFactory.isFxml(containingFile)) {
                    return true;
                }
                if (!(referenceElement instanceof XmlAttributeValue)) {
                    return true;
                }
                XmlAttributeValue attributeValue = (XmlAttributeValue)referenceElement;
                PsiElement parent = attributeValue.getParent();
                if (!(parent instanceof XmlAttribute)) {
                    return true;
                }
                if (!"fx:id".equals(((XmlAttribute)parent).getName())) {
                    return true;
                }
                targets.add(fun.fun((Object)parent));
                return !stopAtFirst;
            }
        });
    }

    private static class JavaFXIdIconNavigationHandler
    implements GutterIconNavigationHandler<PsiField> {
        private JavaFXIdIconNavigationHandler() {
        }

        public void navigate(MouseEvent e, PsiField field) {
            ArrayList relatedItems = new ArrayList();
            JavaFxRelatedItemLineMarkerProvider.collectTargets(field, relatedItems, Function.ID, false);
            if (relatedItems.size() == 1) {
                NavigationUtil.activateFileWithPsiElement((PsiElement)((PsiElement)relatedItems.get(0)));
                return;
            }
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])relatedItems.toArray(new PsiElement[relatedItems.size()]), (String)("<html>Choose component with fx:id <b>" + field.getName() + "<b></html>"));
            popup.show(new RelativePoint(e));
        }
    }
}

