/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.logging.internal.Console;
import org.gradle.logging.internal.DefaultStatusBarFormatter;
import org.gradle.logging.internal.Label;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.logging.internal.progress.ProgressOperation;
import org.gradle.logging.internal.progress.ProgressOperations;

public class ConsoleBackedProgressRenderer
implements OutputEventListener {
    private final OutputEventListener listener;
    private final Console console;
    private final ProgressOperations operations = new ProgressOperations();
    private final DefaultStatusBarFormatter statusBarFormatter;
    private Label statusBar;

    public ConsoleBackedProgressRenderer(OutputEventListener listener, Console console, DefaultStatusBarFormatter statusBarFormatter) {
        this.listener = listener;
        this.console = console;
        this.statusBarFormatter = statusBarFormatter;
    }

    public void onOutput(OutputEvent event) {
        try {
            if (event instanceof ProgressStartEvent) {
                ProgressStartEvent startEvent = (ProgressStartEvent)event;
                ProgressOperation op = this.operations.start(startEvent.getShortDescription(), startEvent.getStatus(), startEvent.getOperationId(), startEvent.getParentId());
                this.updateText(op);
            } else if (event instanceof ProgressCompleteEvent) {
                ProgressOperation op = this.operations.complete(((ProgressCompleteEvent)event).getOperationId());
                this.updateText(op.getParent());
            } else if (event instanceof ProgressEvent) {
                ProgressEvent progressEvent = (ProgressEvent)event;
                ProgressOperation op = this.operations.progress(progressEvent.getStatus(), progressEvent.getOperationId());
                this.updateText(op);
            }
            this.listener.onOutput(event);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to process incoming event '" + event + "' (" + event.getClass().getSimpleName() + ")", e);
        }
    }

    private void updateText(ProgressOperation op) {
        if (this.statusBar == null) {
            this.statusBar = this.console.getStatusBar();
        }
        this.statusBar.setText(this.statusBarFormatter.format(op));
    }
}

