/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Closeable;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.logging.ConsoleOutput;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.internal.LoggingOutputInternal;
import org.gradle.logging.internal.LoggingSystem;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.StreamBackedStandardOutputListener;

public class DefaultLoggingManager
implements LoggingManagerInternal,
Closeable {
    private boolean started;
    private final StartableLoggingSystem loggingSystem;
    private final StartableLoggingSystem stdOutLoggingSystem;
    private final StartableLoggingSystem stdErrLoggingSystem;
    private final StartableLoggingSystem javaUtilLoggingSystem;
    private final LoggingOutputInternal loggingOutput;
    private final Set<StandardOutputListener> stdoutListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<StandardOutputListener> stderrListeners = new LinkedHashSet<StandardOutputListener>();
    private final Set<OutputEventListener> outputEventListeners = new LinkedHashSet<OutputEventListener>();

    public DefaultLoggingManager(LoggingSystem loggingSystem, LoggingSystem javaUtilLoggingSystem, LoggingSystem stdOutLoggingSystem, LoggingSystem stdErrLoggingSystem, LoggingOutputInternal loggingOutput) {
        this.loggingOutput = loggingOutput;
        this.loggingSystem = new StartableLoggingSystem(loggingSystem, null);
        this.stdOutLoggingSystem = new StartableLoggingSystem(stdOutLoggingSystem, null);
        this.stdErrLoggingSystem = new StartableLoggingSystem(stdErrLoggingSystem, null);
        this.javaUtilLoggingSystem = new StartableLoggingSystem(javaUtilLoggingSystem, null);
    }

    public DefaultLoggingManager start() {
        this.started = true;
        for (StandardOutputListener stdoutListener : this.stdoutListeners) {
            this.loggingOutput.addStandardOutputListener(stdoutListener);
        }
        for (StandardOutputListener stderrListener : this.stderrListeners) {
            this.loggingOutput.addStandardErrorListener(stderrListener);
        }
        for (OutputEventListener outputEventListener : this.outputEventListeners) {
            this.loggingOutput.addOutputEventListener(outputEventListener);
        }
        this.loggingSystem.start();
        this.javaUtilLoggingSystem.start();
        this.stdOutLoggingSystem.start();
        this.stdErrLoggingSystem.start();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultLoggingManager stop() {
        try {
            CompositeStoppable.stoppable((Object[])new Object[]{this.loggingSystem, this.javaUtilLoggingSystem, this.stdOutLoggingSystem, this.stdErrLoggingSystem}).stop();
            for (StandardOutputListener stdoutListener : this.stdoutListeners) {
                this.loggingOutput.removeStandardOutputListener(stdoutListener);
            }
            for (StandardOutputListener stderrListener : this.stderrListeners) {
                this.loggingOutput.removeStandardErrorListener(stderrListener);
            }
            for (OutputEventListener listener : this.outputEventListeners) {
                this.loggingOutput.removeOutputEventListener(listener);
            }
        }
        finally {
            this.started = false;
        }
        return this;
    }

    public void close() {
        this.stop();
    }

    public DefaultLoggingManager setLevel(LogLevel logLevel) {
        this.loggingSystem.setLevel(logLevel);
        return this;
    }

    public LogLevel getLevel() {
        return this.loggingSystem.level;
    }

    public DefaultLoggingManager captureSystemSources() {
        this.stdOutLoggingSystem.setLevel(LogLevel.QUIET);
        this.stdErrLoggingSystem.setLevel(LogLevel.ERROR);
        this.javaUtilLoggingSystem.setLevel(LogLevel.DEBUG);
        return this;
    }

    public LogLevel getStandardOutputCaptureLevel() {
        return this.stdOutLoggingSystem.level;
    }

    public DefaultLoggingManager captureStandardOutput(LogLevel level) {
        this.stdOutLoggingSystem.setLevel(level);
        return this;
    }

    public DefaultLoggingManager captureStandardError(LogLevel level) {
        this.stdErrLoggingSystem.setLevel(level);
        return this;
    }

    public LogLevel getStandardErrorCaptureLevel() {
        return this.stdErrLoggingSystem.level;
    }

    public void addStandardOutputListener(StandardOutputListener listener) {
        if (this.stdoutListeners.add(listener) && this.started) {
            this.loggingOutput.addStandardOutputListener(listener);
        }
    }

    public void addStandardErrorListener(StandardOutputListener listener) {
        if (this.stderrListeners.add(listener) && this.started) {
            this.loggingOutput.addStandardErrorListener(listener);
        }
    }

    public void addStandardOutputListener(OutputStream outputStream) {
        this.addStandardOutputListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void addStandardErrorListener(OutputStream outputStream) {
        this.addStandardErrorListener(new StreamBackedStandardOutputListener(outputStream));
    }

    public void removeStandardOutputListener(StandardOutputListener listener) {
        if (this.stdoutListeners.remove(listener) && this.started) {
            this.loggingOutput.removeStandardOutputListener(listener);
        }
    }

    public void removeStandardErrorListener(StandardOutputListener listener) {
        if (this.stderrListeners.remove(listener) && this.started) {
            this.loggingOutput.removeStandardErrorListener(listener);
        }
    }

    public void addOutputEventListener(OutputEventListener listener) {
        if (this.outputEventListeners.add(listener) && this.started) {
            this.loggingOutput.addOutputEventListener(listener);
        }
    }

    public void removeOutputEventListener(OutputEventListener listener) {
        if (this.outputEventListeners.remove(listener) && this.started) {
            this.loggingOutput.removeOutputEventListener(listener);
        }
    }

    public void removeAllOutputEventListeners() {
        this.loggingOutput.removeAllOutputEventListeners();
    }

    public void attachProcessConsole(ConsoleOutput consoleOutput) {
        this.loggingOutput.attachProcessConsole(consoleOutput);
    }

    public void attachAnsiConsole(OutputStream outputStream) {
        this.loggingOutput.attachAnsiConsole(outputStream);
    }

    public void attachSystemOutAndErr() {
        this.loggingOutput.attachSystemOutAndErr();
    }

    private static class StartableLoggingSystem
    implements Stoppable {
        private final LoggingSystem loggingSystem;
        private LogLevel level;
        private LoggingSystem.Snapshot originalState;

        private StartableLoggingSystem(LoggingSystem loggingSystem, LogLevel level) {
            this.loggingSystem = loggingSystem;
            this.level = level;
        }

        public void start() {
            this.originalState = this.level != null ? this.loggingSystem.on(this.level, this.level) : this.loggingSystem.snapshot();
        }

        public void setLevel(LogLevel logLevel) {
            if (this.level == logLevel) {
                return;
            }
            this.level = logLevel;
            if (this.originalState == null) {
                return;
            }
            this.loggingSystem.on(logLevel, logLevel);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            try {
                if (this.originalState != null) {
                    this.loggingSystem.restore(this.originalState);
                }
            }
            finally {
                this.originalState = null;
            }
        }
    }
}

