/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.ProtoBuf;
import org.jetbrains.kotlin.serialization.deserialization.NameResolver;
import org.jetbrains.kotlin.serialization.deserialization.TypeTable;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"%\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0002\t\u001f!1\t\u0002\u0007\u00013\u0005A\n!)\u000b\n\t!\tQB\u0001G\u00011\u0007IA\u0001\u0003\u0002\u000e\u00051\u0005\u0001TA\u0005\u0004\u0011\ri\u0011\u0001g\u0002\n\u0007!!Q\"\u0001M\u0005#\u000e\t\u0001\"BS\u0006\t\r;\u00012C\u0007\u0003\u0019\u0003A\u001a!j\u0003\u0005\u0007\u001eA!\"\u0004\u0002\r\u0002a\u0015Q\u0015\u0002\u0003D\u000f!UQ\"\u0001M\u0004K\u0013!1i\u0002\u0005\f\u001b\u0005AJ!*\u000e\u0005\u0007\u000eA9\"D\u0001\u0019\u0001e)A!\u0001\u0005\u0002\u001b\ta\t\u0001g\u0001\u001a\u000b\u0011\t\u0001BA\u0007\u0003\u0019\u0003A*!\u0007\u0003\u0005\u0003!\u0019Q\"\u0001M\u00043\u0011!\u0011\u0001\u0003\u0003\u000e\u0003a%Qe\u0001\u0005\r\u001b\u0005A*!K\u0006\u0005\u0007\"A\u0011!\u0004\u0002\r\u0002a\r\u0011k\u0001\u0003\u0006\u00015\u0011A1\u0002\u0005\u0007S)!1\t\u0003\u0005\u0004\u001b\u0005A:!U\u0002\u0005\u000b\u0001i!\u0001\"\u0004\t\u000f%ZAa\u0011\u0005\t\u00055\u0011A\u0012\u0001M\u0003#\u000e!Q\u0001A\u0007\u0003\t\u001fA\u0001\"\u000b\u0006\u0005\u0007\"AA!D\u0001\u0019\nE\u001bA!\u0002\u0001\u000e\u0005\u0011E\u0001\"\u0003"}, strings={"Lorg/jetbrains/kotlin/serialization/deserialization/ProtoContainer;", "", "classProto", "Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameResolver", "Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "typeTable", "Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "(Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;)V", "getClassProto", "()Lorg/jetbrains/kotlin/serialization/ProtoBuf$Class;", "getNameResolver", "()Lorg/jetbrains/kotlin/serialization/deserialization/NameResolver;", "getPackageFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getTypeTable", "()Lorg/jetbrains/kotlin/serialization/deserialization/TypeTable;", "component1", "component2", "component3", "component4", "copy", "getFqName"}, moduleName="deserialization")
public final class ProtoContainer {
    @Nullable
    private final ProtoBuf.Class classProto;
    @Nullable
    private final FqName packageFqName;
    @NotNull
    private final NameResolver nameResolver;
    @NotNull
    private final TypeTable typeTable;

    @NotNull
    public final FqName getFqName() {
        FqName fqName = this.packageFqName;
        if (fqName == null) {
            ProtoBuf.Class clazz = this.classProto;
            if (clazz == null) {
                Intrinsics.throwNpe();
            }
            FqName fqName2 = this.nameResolver.getClassId(clazz.getFqName()).asSingleFqName();
            fqName = fqName2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"nameResolver.getClassId(\u2026qName()).asSingleFqName()");
        }
        return fqName;
    }

    @Nullable
    public final ProtoBuf.Class getClassProto() {
        return this.classProto;
    }

    @Nullable
    public final FqName getPackageFqName() {
        return this.packageFqName;
    }

    @NotNull
    public final NameResolver getNameResolver() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable getTypeTable() {
        return this.typeTable;
    }

    public ProtoContainer(@Nullable ProtoBuf.Class classProto, @Nullable FqName packageFqName, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        this.classProto = classProto;
        this.packageFqName = packageFqName;
        this.nameResolver = nameResolver;
        this.typeTable = typeTable;
        PreconditionsKt.assert((boolean)(this.classProto != null ^ this.packageFqName != null));
    }

    @Nullable
    public final ProtoBuf.Class component1() {
        return this.classProto;
    }

    @Nullable
    public final FqName component2() {
        return this.packageFqName;
    }

    @NotNull
    public final NameResolver component3() {
        return this.nameResolver;
    }

    @NotNull
    public final TypeTable component4() {
        return this.typeTable;
    }

    @NotNull
    public final ProtoContainer copy(@Nullable ProtoBuf.Class classProto, @Nullable FqName packageFqName, @NotNull NameResolver nameResolver, @NotNull TypeTable typeTable) {
        Intrinsics.checkParameterIsNotNull((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkParameterIsNotNull((Object)typeTable, (String)"typeTable");
        return new ProtoContainer(classProto, packageFqName, nameResolver, typeTable);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ProtoContainer copy$default(ProtoContainer protoContainer, ProtoBuf.Class clazz, FqName fqName, NameResolver nameResolver, TypeTable typeTable, int n) {
        if ((n & 1) != 0) {
            clazz = protoContainer.classProto;
        }
        if ((n & 2) != 0) {
            fqName = protoContainer.packageFqName;
        }
        if ((n & 4) != 0) {
            nameResolver = protoContainer.nameResolver;
        }
        if ((n & 8) != 0) {
            typeTable = protoContainer.typeTable;
        }
        return protoContainer.copy(clazz, fqName, nameResolver, typeTable);
    }

    public String toString() {
        return "ProtoContainer(classProto=" + this.classProto + ", packageFqName=" + this.packageFqName + ", nameResolver=" + this.nameResolver + ", typeTable=" + this.typeTable + ")";
    }

    public int hashCode() {
        ProtoBuf.Class clazz = this.classProto;
        FqName fqName = this.packageFqName;
        NameResolver nameResolver = this.nameResolver;
        TypeTable typeTable = this.typeTable;
        return (((clazz != null ? clazz.hashCode() : 0) * 31 + (fqName != null ? fqName.hashCode() : 0)) * 31 + (nameResolver != null ? nameResolver.hashCode() : 0)) * 31 + (typeTable != null ? typeTable.hashCode() : 0);
    }

    public boolean equals(Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ProtoContainer)) break block3;
                ProtoContainer protoContainer = (ProtoContainer)object;
                if (!Intrinsics.areEqual((Object)this.classProto, (Object)protoContainer.classProto) || !Intrinsics.areEqual((Object)this.packageFqName, (Object)protoContainer.packageFqName) || !Intrinsics.areEqual((Object)this.nameResolver, (Object)protoContainer.nameResolver) || !Intrinsics.areEqual((Object)this.typeTable, (Object)protoContainer.typeTable)) break block3;
            }
            return true;
        }
        return false;
    }
}

