/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.repo;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.RepoStateException;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Hex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgNameWithHashInfo;
import org.zmlx.hg4idea.HgVcs;
import org.zmlx.hg4idea.util.HgVersion;

public class HgRepositoryReader {
    private static final Logger LOG = Logger.getInstance(HgRepositoryReader.class);
    private static final Pattern HASH_NAME = Pattern.compile("\\s*([0-9a-fA-F]{40})[:?|\\s+](.+)");
    private static final Pattern HASH_STATUS_NAME = Pattern.compile("\\s*([0-9a-fA-F]+)\\s+\\w\\s+(.+)");
    @NotNull
    private final File myHgDir;
    @NotNull
    private File myBranchHeadsFile;
    @NotNull
    private final File myCacheDir;
    @NotNull
    private final File myCurrentBranch;
    @NotNull
    private final File myBookmarksFile;
    @NotNull
    private final File myCurrentBookmark;
    @NotNull
    private final File myTagsFile;
    @NotNull
    private final File myLocalTagsFile;
    @NotNull
    private final File myDirStateFile;
    @NotNull
    private final File mySubrepoFile;
    @NotNull
    private final File myMqInternalDir;
    @NotNull
    private final VcsLogObjectsFactory myVcsObjectsFactory;
    private final boolean myStatusInBranchFile;
    @NotNull
    private final HgVcs myVcs;

    public HgRepositoryReader(@NotNull HgVcs vcs, @NotNull File hgDir) {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/zmlx/hg4idea/repo/HgRepositoryReader", "<init>"));
        }
        if (hgDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgDir", "org/zmlx/hg4idea/repo/HgRepositoryReader", "<init>"));
        }
        this.myHgDir = hgDir;
        DvcsUtil.assertFileExists((File)this.myHgDir, (String)(".hg directory not found in " + this.myHgDir));
        this.myVcs = vcs;
        HgVersion version = this.myVcs.getVersion();
        this.myStatusInBranchFile = version.hasBranch2();
        this.myCacheDir = new File(this.myHgDir, "cache");
        this.myBranchHeadsFile = HgRepositoryReader.identifyBranchHeadFile(version, this.myCacheDir);
        this.myCurrentBranch = new File(this.myHgDir, "branch");
        this.myBookmarksFile = new File(this.myHgDir, "bookmarks");
        this.myCurrentBookmark = new File(this.myHgDir, "bookmarks.current");
        this.myLocalTagsFile = new File(this.myHgDir, "localtags");
        this.myTagsFile = new File(this.myHgDir.getParentFile(), ".hgtags");
        this.mySubrepoFile = new File(this.myHgDir.getParentFile(), ".hgsubstate");
        this.myDirStateFile = new File(this.myHgDir, "dirstate");
        this.myMqInternalDir = new File(this.myHgDir, "patches");
        this.myVcsObjectsFactory = (VcsLogObjectsFactory)ServiceManager.getService((Project)vcs.getProject(), VcsLogObjectsFactory.class);
    }

    @NotNull
    private static File identifyBranchHeadFile(@NotNull HgVersion version, @NotNull File parentCacheFile) {
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "org/zmlx/hg4idea/repo/HgRepositoryReader", "identifyBranchHeadFile"));
        }
        if (parentCacheFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentCacheFile", "org/zmlx/hg4idea/repo/HgRepositoryReader", "identifyBranchHeadFile"));
        }
        if (version.hasBranch2()) {
            File file = new File(parentCacheFile, "branch2-served");
            File file2 = file.exists() ? file : new File(parentCacheFile, "branch2-base");
            if (file2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "identifyBranchHeadFile"));
            }
            return file2;
        }
        if (version.hasBranchHeadsBaseServed()) {
            File file = new File(parentCacheFile, "branchheads-served");
            File file3 = file.exists() ? file : new File(parentCacheFile, "branchheads-base");
            if (file3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "identifyBranchHeadFile"));
            }
            return file3;
        }
        File file = new File(parentCacheFile, "branchheads");
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "identifyBranchHeadFile"));
        }
        return file;
    }

    @Nullable
    public String readCurrentRevision() {
        if (!this.isDirStateInfoAvailable()) {
            return null;
        }
        try {
            return Hex.encodeHexString((byte[])HgRepositoryReader.readHashBytesFromFile(this.myDirStateFile));
        }
        catch (IOException e) {
            LOG.error("IOException while trying to read current repository state information.", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private static byte[] readHashBytesFromFile(@NotNull File file) throws IOException {
        byte[] bytes;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readHashBytesFromFile"));
        }
        FileInputStream stream = new FileInputStream(file);
        try {
            bytes = FileUtil.loadBytes((InputStream)stream, (int)20);
        }
        finally {
            ((InputStream)stream).close();
        }
        if (bytes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readHashBytesFromFile"));
        }
        return bytes;
    }

    @Nullable
    public String readCurrentTipRevision() {
        String[] branchesWithHeads;
        if (!this.isBranchInfoAvailable()) {
            return null;
        }
        try {
            branchesWithHeads = DvcsUtil.tryLoadFile((File)this.myBranchHeadsFile).split("\n");
        }
        catch (RepoStateException e) {
            LOG.error((Throwable)e);
            return null;
        }
        String head = branchesWithHeads[0];
        Matcher matcher = HASH_NAME.matcher(head);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private boolean isBranchInfoAvailable() {
        this.myBranchHeadsFile = HgRepositoryReader.identifyBranchHeadFile(this.myVcs.getVersion(), this.myCacheDir);
        return !this.isFresh() && this.myBranchHeadsFile.exists();
    }

    private boolean isDirStateInfoAvailable() {
        return this.myDirStateFile.exists();
    }

    @NotNull
    public String readCurrentBranch() {
        String string = this.branchExist() ? DvcsUtil.tryLoadFileOrReturn((File)this.myCurrentBranch, (String)"default") : "default";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readCurrentBranch"));
        }
        return string;
    }

    @NotNull
    public Map<String, LinkedHashSet<Hash>> readBranches() {
        HashMap<String, LinkedHashSet<Hash>> branchesWithHashes = new HashMap<String, LinkedHashSet<Hash>>();
        if (this.isBranchInfoAvailable()) {
            Pattern activeBranchPattern = this.myStatusInBranchFile ? HASH_STATUS_NAME : HASH_NAME;
            String[] branchesWithHeads = DvcsUtil.tryLoadFileOrReturn((File)this.myBranchHeadsFile, (String)"").split("\n");
            for (int i = 1; i < branchesWithHeads.length; ++i) {
                Matcher matcher = activeBranchPattern.matcher(branchesWithHeads[i]);
                if (!matcher.matches()) continue;
                String name = matcher.group(2);
                if (branchesWithHashes.containsKey(name)) {
                    ((LinkedHashSet)branchesWithHashes.get(name)).add(this.myVcsObjectsFactory.createHash(matcher.group(1)));
                    continue;
                }
                LinkedHashSet<Hash> hashes = new LinkedHashSet<Hash>();
                hashes.add(this.myVcsObjectsFactory.createHash(matcher.group(1)));
                branchesWithHashes.put(name, hashes);
            }
        }
        HashMap<String, LinkedHashSet<Hash>> hashMap = branchesWithHashes;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readBranches"));
        }
        return hashMap;
    }

    private boolean isMergeInProgress() {
        return new File(this.myHgDir, "merge").exists();
    }

    private boolean hasSubrepos() {
        return this.mySubrepoFile.exists();
    }

    private boolean isRebaseInProgress() {
        return new File(this.myHgDir, "rebasestate").exists();
    }

    private boolean isCherryPickInProgress() {
        return new File(this.myHgDir, "graftstate").exists();
    }

    @NotNull
    public Repository.State readState() {
        if (this.isRebaseInProgress()) {
            Repository.State state = Repository.State.REBASING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readState"));
            }
            return state;
        }
        if (this.isCherryPickInProgress()) {
            Repository.State state = Repository.State.GRAFTING;
            if (state == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readState"));
            }
            return state;
        }
        Repository.State state = this.isMergeInProgress() ? Repository.State.MERGING : Repository.State.NORMAL;
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readState"));
        }
        return state;
    }

    public boolean isFresh() {
        return !this.myCacheDir.exists();
    }

    private boolean branchExist() {
        return this.myCurrentBranch.exists();
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readBookmarks() {
        Collection<HgNameWithHashInfo> collection = this.readReferences(this.myBookmarksFile);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readBookmarks"));
        }
        return collection;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readTags() {
        Collection<HgNameWithHashInfo> collection = this.readReferences(this.myTagsFile);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readTags"));
        }
        return collection;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readLocalTags() {
        Collection<HgNameWithHashInfo> collection = this.readReferences(this.myLocalTagsFile);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readLocalTags"));
        }
        return collection;
    }

    @NotNull
    private Collection<HgNameWithHashInfo> readReferences(@NotNull File fileWithReferences) {
        if (fileWithReferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithReferences", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readReferences"));
        }
        HashSet result = ContainerUtil.newHashSet();
        this.readReferences(fileWithReferences, result);
        HashSet hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readReferences"));
        }
        return hashSet;
    }

    private void readReferences(@NotNull File fileWithReferences, @NotNull Collection<HgNameWithHashInfo> resultRefs) {
        String[] namesWithHashes;
        if (fileWithReferences == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileWithReferences", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readReferences"));
        }
        if (resultRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resultRefs", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readReferences"));
        }
        if (!fileWithReferences.exists()) {
            return;
        }
        for (String str : namesWithHashes = DvcsUtil.tryLoadFileOrReturn((File)fileWithReferences, (String)"").split("\n")) {
            Matcher matcher = HASH_NAME.matcher(str);
            if (!matcher.matches()) continue;
            resultRefs.add(new HgNameWithHashInfo(matcher.group(2), this.myVcsObjectsFactory.createHash(matcher.group(1))));
        }
    }

    @Nullable
    public String readCurrentBookmark() {
        return this.myCurrentBookmark.exists() ? DvcsUtil.tryLoadFileOrReturn((File)this.myCurrentBookmark, (String)"") : null;
    }

    @NotNull
    public Collection<HgNameWithHashInfo> readSubrepos() {
        if (!this.hasSubrepos()) {
            Set<HgNameWithHashInfo> set = Collections.emptySet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readSubrepos"));
            }
            return set;
        }
        Collection<HgNameWithHashInfo> collection = this.readReferences(this.mySubrepoFile);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readSubrepos"));
        }
        return collection;
    }

    @NotNull
    public List<HgNameWithHashInfo> readMQAppliedPatches() {
        ArrayList mqPatchRefs = ContainerUtil.newArrayList();
        this.readReferences(new File(this.myMqInternalDir, "status"), mqPatchRefs);
        ArrayList arrayList = mqPatchRefs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readMQAppliedPatches"));
        }
        return arrayList;
    }

    @NotNull
    public List<String> readMqPatchNames() {
        File seriesFile = new File(this.myMqInternalDir, "series");
        List list = seriesFile.exists() ? StringUtil.split((String)DvcsUtil.tryLoadFileOrReturn((File)seriesFile, (String)""), (String)"\n") : ContainerUtil.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/zmlx/hg4idea/repo/HgRepositoryReader", "readMqPatchNames"));
        }
        return list;
    }
}

