/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.IntProgression;
import kotlin.ReplaceWith;
import kotlin.Sequence;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.FileAlreadyExistsException;
import kotlin.io.FilePathComponents;
import kotlin.io.FilesKt;
import kotlin.io.FilesKt__UtilsKt;
import kotlin.io.FilesKt__UtilsKt$sam$FileFilter$460519df;
import kotlin.io.NoSuchFileException;
import kotlin.io.OnErrorAction;
import kotlin.io.TerminateException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinMultifileClassPart;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@KotlinMultifileClassPart(version={1, 0, 1}, abiVersion=32, data={"S\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005!1!B\u0001\t\u000f\u0015\tAqB\u0003\u0002\u0011\u0017)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!%Q!\u0001\u0003\u0002\u000b\u0005AA!B\u0001\u0005\u0005\u0015\t\u0001\u0012C\u0003\u0001\u000b\u0005a\u0011!B\u0001\u0005\u0003\u0015\t\u0001\u0002E\u0003\u0002\u0019\u0005)\u0011\u0001b\u0004\u000e,!IQ\"\u0001M\u00013\u0011!\u0011\u0001c\u0005\u000e\u0003a!\u0011$\u0002\u0003\u0002\u0011)i!\u0001$\u0001\u0019\te)A!\u0001\u0005\u0001\u001b\ta\t\u0001'\u0001U\u0007\riY\u0003#\u0006\u000e\u0003a\u0005\u0011\u0004\u0002\u0003\u0002\u0011'i\u0011\u0001\u0007\u0003\u001a\u000b\u0011\t\u0001BC\u0007\u0003\u0019\u0003AB!G\u0003\u0005\u0003!\u0001QB\u0001G\u00011\u0003!6aAG\b\t\u000fA1\"D\u0001\u0019\tU\t\u0001\u0004\u0002+\u0004\u00075]\u0002rC\u0007\u000211)\u0012\u0001'\u0001\u001a\n!eQ\"\u0001M\u0001!\u000e\u0005\u0011T\u0004\u0003\u0002\u00115i!\"\u0003\u0002\n\u0003a\u0005\u0011BA\u0005\u000219I!!C\u0001\u0019\u001eam\u0001kA\u0001U\u0007\ri\u0011\u0004C\b\u000e\u0003a}Q#\u0001M\u00013\u0013AI\"D\u0001\u0019\u0002A\u001b\t!g\u0003\u0005\u0003!\u0001R\"\u0001\r\r!\u000e\t\u00114\u0002\u0003\u0002\u0011Ci\u0011\u0001G\tQ\u0007\u0007!6aAG\u0007\u0011Gi\u0011\u0001\u0007\u0007\u0016\u0003a\u0005AkA\u0002\u000e\u0019!\u0011R\"\u0001\r\r+\u0005A\n!'\u0003\t&5\t\u0001\u0014\u0001)\u0004\u0002Q\u001b1!\u0004\u0007\t%5\t\u0001\u0004D\u000b\u00021\u0003IJ\u0001#\n\u000e\u0003a!\u0001k!\u0001U\u0007\ri\t\u0004C\n\u000e\u000b%\u0011\u0011\"\u0001M\u0001\u0019\u0003A:#F\u0001\u0019\u0002eU\u0001\u0002F\u0007\b\u0013\tI\u0011\u0001'\u0001\n\u0005%\t\u0001\u0004\u0004M\u0015!\u000e\u0005\u0011kA\u0001\t+Q\u001b1!$\u0004\t,5\t\u0001\u0014A\u000b\u00021\u0003!6aAG\u000e\t\u0005AY#\u0004\u0003\n\u0005%\t\u0001\u0014\u0001\r\u0017+\u0011I!!C\u0001\u0019\u0002a1BkA\u0002\u000e\u0010\u0011\t\u00012F\u0007\u00021[)\u0012\u0001'\fU\u0007\riy\u0001b\u0002\t/5\t\u0001\u0004B\u000b\u00021\u0011!6aA\u0007\u000e\t\u000fAy#D\u0001\u0019\tU\t\u0001\u0014AM\u0005\u0011ai\u0011\u0001'\u0001Q\u0007\u0003!6aA\u0007\u000e\t\u000fA\t$D\u0001\u0019\tU\t\u0001\u0014AM\u0005\u0011ei\u0011\u0001'\u0001Q\u0007\u0003!6aA\u0007\u000e\t\u000fA\u0019$D\u0001\u0019\u0002U\t\u0001\u0014AM\u0005\u0011ei\u0011\u0001'\u0001Q\u0007\u0003!6aA\u0007\u000e\u0011ii!\u0001$\u0001\u0019\u0002U\t\u0001\u0014AM\u0005\u0011ei\u0011\u0001'\u0001Q\u0007\u0003!6aA\u0007\r\u0011ki\u0011\u0001'\u0001\u0016\u0003a\u0005\u0011\u0014\u0002\u0005\u001a\u001b\u0005A\n\u0001UB\u0001)\u000e\u0019Q\u0002\u0004\u0005\u001c\u001b\u0005A\n!F\u0001\u0019\u0002e%\u0001rG\u0007\u00021\u0003\u00016\u0011\u0001+\u0004\u00075a\u0001bG\u0007\u00021\u0003)\u0012\u0001'\u0001\u001a\n!]R\"\u0001\r\u0005!\u000e\u0005AkA\u0002\u000e\u0019!aR\"\u0001M\u0001+\u0005A\n!'\u0003\t85\t\u0001\u0014\u0001)\u0004\u0002Q\u001b1!\u0004\u0007\t95\t\u0001\u0014A\u000b\u00021\u0003IJ\u0001c\u000e\u000e\u0003a!\u0001k!\u0001U\u0007\riy\u0001b\u0002\t:5\t\u0001\u0004B\u000b\u00021\u0003!6aAG\b\t\u000fAI$D\u0001\u0019\tU\t\u0001\u0004\u0002+\u0004\u00075a\u0001\"H\u0007\u000211)\u0012\u0001'\u0001\u001a\n!\u0015R\"\u0001M\u0001!\u000e\u0005AkA\u0002\u000e\u0019!iR\"\u0001\r\r+\u0005A\n!'\u0003\t&5\t\u0001\u0004\u0002)\u0004\u0002Q\u001b1!\u0004\u0007\t<5\t\u0001\u0004B\u000b\u00021\u0003IJ\u0001C\r\u000e\u0003a\u0005\u0001k!\u0001U\u0007\ria\u0002B\u0001\t=5\u0011A\u0012\u0001\r\u0005+\u0005A\n!'\u0003\t35\t\u0001\u0014\u0001)\u0004\u0002Q\u001b1!%\t\u0005\b\"A\u0001!D\u0001\u0019\u0002U\t\u0001\u0014\u0001\u000f$#\u000e1\u0011B\u0001\u0003\u0002\u0011\u0007i!\u0001\u0002\u0002\t\u0006Q\u001b1!e\u0007\u0005\u0007\"A9!D\u0001\u0019\tU\t\u0001\u0014\u0001\u000f$#\u000e\u0019QB\u0001C\u0005\u0011\u0015!6aAI\u000e\t\rC\u00012B\u0007\u00021\u0011)\u0012\u0001'\u0001\u001dGE\u001b1!\u0004\u0002\u0005\r!)AkA\u0002\u0012\u001c\u0011\u0019\u0005\u0002#\u0004\u000e\u0003a!Q#\u0001M\u00019\r\n6aA\u0007\u0003\t\u001dAQ\u0001V\u0002\u0004#G!9\t\u0003E\b\u001b\ta\t\u0001'\u0001\u0016\u0003a\u0005AdI)\u0004\r%\u0011A\u0001\u0003E\u0002\u001b\t!\t\u0002#\u0002U\u0007\r\u0001"}, strings={"directory", "Ljava/io/File;", "directory$annotations", "(Ljava/io/File;)V", "getDirectory", "(Ljava/io/File;)Ljava/io/File;", "FilesKt__UtilsKt", "extension", "", "getExtension", "(Ljava/io/File;)Ljava/lang/String;", "invariantSeparatorsPath", "getInvariantSeparatorsPath", "nameWithoutExtension", "getNameWithoutExtension", "parent", "parent$annotations", "getParent", "createTempDir", "prefix", "suffix", "createTempFile", "allSeparatorsToSystem", "copyRecursively", "", "dst", "onError", "Lkotlin/Function2;", "Ljava/io/IOException;", "Lkotlin/io/OnErrorAction;", "copyTo", "", "overwrite", "bufferSize", "", "deleteRecursively", "endsWith", "other", "listFiles", "", "filter", "Lkotlin/Function1;", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)[Ljava/io/File;", "normalize", "", "Lkotlin/io/FilePathComponents;", "pathSeparatorsToSystem", "relativePath", "descendant", "relativeTo", "base", "relativeToFile", "relativeToOrNull", "relativeToOrSelf", "resolve", "relative", "resolveSibling", "separatorsToSystem", "startsWith", "toRelativeString", "toRelativeStringOrNull"}, multifileClassName="kotlin/io/FilesKt")
final class FilesKt__UtilsKt {
    @NotNull
    public static final File createTempDir(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        File dir = File.createTempFile(prefix, suffix, directory);
        dir.delete();
        if (dir.mkdir()) {
            File file = dir;
            Intrinsics.checkExpressionValueIsNotNull(file, "dir");
            return file;
        }
        throw (Throwable)new IOException("Unable to create temporary directory " + dir);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File createTempDir$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempDir(string, string2, file);
    }

    @NotNull
    public static final File createTempFile(@NotNull String prefix, @Nullable String suffix, @Nullable File directory) {
        Intrinsics.checkParameterIsNotNull(prefix, "prefix");
        File file = File.createTempFile(prefix, suffix, directory);
        Intrinsics.checkExpressionValueIsNotNull(file, "File.createTempFile(prefix, suffix, directory)");
        return file;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ File createTempFile$default(String string, String string2, File file, int n) {
        if ((n & 1) != 0) {
            string = "tmp";
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        if ((n & 4) != 0) {
            file = null;
        }
        return FilesKt.createTempFile(string, string2, file);
    }

    @Deprecated(message="This property has unclear semantics and will be removed soon.")
    private static final /* synthetic */ void directory$annotations(File file) {
    }

    @NotNull
    public static final File getDirectory(File $receiver) {
        File file;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        if ($receiver.isDirectory()) {
            file = $receiver;
        } else {
            file = $receiver.getParentFile();
            if (file == null) {
                Intrinsics.throwNpe();
            }
        }
        return file;
    }

    @Deprecated(message="Use 'parentFile' property instead.", replaceWith=@ReplaceWith(expression="parentFile", imports={}), level=DeprecationLevel.ERROR)
    private static final /* synthetic */ void parent$annotations(File file) {
    }

    @Nullable
    public static final File getParent(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getParentFile();
    }

    @NotNull
    public static final String getExtension(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return StringsKt.substringAfterLast($receiver.getName(), '.', "");
    }

    @Deprecated(message="Use File.path instead", replaceWith=@ReplaceWith(expression="File(this).path", imports={"java.io.File"}))
    @NotNull
    public static final String separatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String otherSep = Intrinsics.areEqual(File.separator, "/") ? "\\" : "/";
        String string = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.separator");
        return StringsKt.replace$default($receiver, otherSep, string, false, 4);
    }

    @Deprecated(message="This function is deprecated")
    @NotNull
    public static final String pathSeparatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        String otherSep = Intrinsics.areEqual(File.pathSeparator, ":") ? ";" : ":";
        String string = File.pathSeparator;
        Intrinsics.checkExpressionValueIsNotNull(string, "File.pathSeparator");
        return StringsKt.replace$default($receiver, otherSep, string, false, 4);
    }

    @Deprecated(message="This function is deprecated")
    @NotNull
    public static final String allSeparatorsToSystem(String $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FilesKt.pathSeparatorsToSystem(FilesKt.separatorsToSystem($receiver));
    }

    @Deprecated(message="File has already system separators.")
    @NotNull
    public static final String separatorsToSystem(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return FilesKt.separatorsToSystem($receiver.toString());
    }

    @NotNull
    public static final String getInvariantSeparatorsPath(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return File.separatorChar != '/' ? StringsKt.replace$default($receiver.getPath(), File.separatorChar, '/', false, 4) : $receiver.getPath();
    }

    @NotNull
    public static final String getNameWithoutExtension(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return StringsKt.substringBeforeLast$default($receiver.getName(), ".", null, 2);
    }

    @Deprecated(message="This function will change return type to File soon. Use toRelativeString instead.", replaceWith=@ReplaceWith(expression="toRelativeString(base)", imports={}))
    @NotNull
    public static final String relativeTo(File $receiver, @NotNull File base) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        return FilesKt.toRelativeString($receiver, base);
    }

    @NotNull
    public static final String toRelativeString(File $receiver, @NotNull File base) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull($receiver, base);
        if (string == null) {
            throw (Throwable)new IllegalArgumentException("this and base files have different roots: " + $receiver + " and " + base);
        }
        return string;
    }

    @Deprecated(message="This function will be renamed to relativeTo soon.")
    @NotNull
    public static final File relativeToFile(File $receiver, @NotNull File base) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        return new File(FilesKt.relativeTo($receiver, base));
    }

    @NotNull
    public static final File relativeToOrSelf(File $receiver, @NotNull File base) {
        File file;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull($receiver, base);
        if (string != null) {
            String $receiver$iv = string;
            String it = $receiver$iv;
            file = new File(it);
        } else {
            file = $receiver;
        }
        return file;
    }

    @Nullable
    public static final File relativeToOrNull(File $receiver, @NotNull File base) {
        File file;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(base, "base");
        String string = FilesKt__UtilsKt.toRelativeStringOrNull($receiver, base);
        if (string != null) {
            String $receiver$iv = string;
            String it = $receiver$iv;
            file = new File(it);
        } else {
            file = null;
        }
        return file;
    }

    /*
     * WARNING - void declaration
     */
    private static final String toRelativeStringOrNull(File $receiver, File base) {
        int i;
        void $receiver$iv;
        FilePathComponents thisComponents = FilesKt__UtilsKt.normalize(FilesKt.toComponents($receiver));
        FilePathComponents baseComponents = FilesKt__UtilsKt.normalize(FilesKt.toComponents(base));
        if (Intrinsics.areEqual(thisComponents.getRoot(), baseComponents.getRoot()) ^ true) {
            return null;
        }
        int baseCount = baseComponents.getSize();
        int thisCount = thisComponents.getSize();
        File file = $receiver;
        File $receiver22 = (File)$receiver$iv;
        int maxSameCount = Math.min(thisCount, baseCount);
        for (i = 0; i < maxSameCount && Intrinsics.areEqual(thisComponents.getSegments().get(i), baseComponents.getSegments().get(i)); ++i) {
        }
        int sameCount = i;
        StringBuilder res = new StringBuilder();
        IntProgression intProgression = RangesKt.downTo(baseCount - 1, sameCount);
        int $receiver22 = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        int n3 = $receiver22;
        int n4 = n;
        if (n2 > 0 ? n3 <= n4 : n3 >= n4) {
            while (true) {
                void i2;
                if (Intrinsics.areEqual(baseComponents.getSegments().get((int)i2).getName(), "..")) {
                    return null;
                }
                res.append("..");
                if (i2 != sameCount) {
                    res.append(File.separatorChar);
                }
                if (i2 == n) break;
                i2 += n2;
            }
        }
        if (sameCount < thisCount) {
            if (sameCount < baseCount) {
                res.append(File.separatorChar);
            }
            Iterable iterable = CollectionsKt.drop((Iterable)thisComponents.getSegments(), sameCount);
            Appendable appendable = res;
            CharSequence charSequence = File.separator;
            Intrinsics.checkExpressionValueIsNotNull(charSequence, "File.separator");
            CollectionsKt.joinTo$default(iterable, appendable, charSequence, null, null, 0, null, null, 124);
        }
        return res.toString();
    }

    @Deprecated(message="Use relativeTo() function instead")
    @NotNull
    public static final String relativePath(File $receiver, @NotNull File descendant) {
        String string;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(descendant, "descendant");
        String prefix = FilesKt.getDirectory($receiver).getCanonicalPath();
        String answer = descendant.getCanonicalPath();
        String string2 = prefix;
        Intrinsics.checkExpressionValueIsNotNull(string2, "prefix");
        if (StringsKt.startsWith$default(answer, string2, false, 2)) {
            int prefixSize = prefix.length();
            string = answer.length() > prefixSize ? StringsKt.substring(answer, prefixSize + 1) : "";
        } else {
            string = answer;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static final long copyTo(File $receiver, @NotNull File dst, boolean overwrite, int bufferSize) {
        long l;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(dst, "dst");
        if (!$receiver.exists()) {
            throw (Throwable)new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null);
        }
        if ($receiver.isDirectory()) {
            throw (Throwable)new IllegalArgumentException("Use copyRecursively to copy a directory " + $receiver);
        }
        if (dst.exists()) {
            if (!overwrite) {
                throw (Throwable)new FileAlreadyExistsException($receiver, dst, "The destination file already exists");
            }
            if (dst.isDirectory() && ArraysKt.any((Object[])dst.listFiles())) {
                String string = $receiver.getName();
                Intrinsics.checkExpressionValueIsNotNull(string, "name");
                return FilesKt.copyTo($receiver, FilesKt.resolve(dst, string), overwrite, bufferSize);
            }
        }
        File file = dst.getParentFile();
        Boolean bl = file != null ? Boolean.valueOf(file.mkdirs()) : null;
        dst.delete();
        FileInputStream input = new FileInputStream($receiver);
        Closeable closeable = input;
        boolean closed$iv = false;
        try {
            Long l2;
            void $receiver$iv2;
            FileInputStream it = (FileInputStream)$receiver$iv;
            FileOutputStream output = new FileOutputStream(dst);
            Closeable closeable2 = output;
            boolean closed$iv2 = false;
            try {
                FileOutputStream it2 = (FileOutputStream)$receiver$iv2;
                l2 = ByteStreamsKt.copyTo(input, output, bufferSize);
            }
            catch (Exception e$iv) {
                closed$iv2 = true;
                try {
                    $receiver$iv2.close();
                }
                catch (Exception closeException$iv) {
                    // empty catch block
                }
                throw (Throwable)e$iv;
            }
            finally {
                if (!closed$iv2) {
                    $receiver$iv2.close();
                }
            }
            l = ((Number)l2).longValue();
        }
        catch (Exception e$iv) {
            closed$iv = true;
            try {
                $receiver$iv.close();
            }
            catch (Exception closeException$iv) {
                // empty catch block
            }
            throw (Throwable)e$iv;
        }
        finally {
            if (!closed$iv) {
                $receiver$iv.close();
            }
        }
        return l;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(File file, File file2, boolean bl, int n, int n2) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            n = FilesKt.getDefaultBufferSize();
        }
        return FilesKt.copyTo(file, file2, bl, n);
    }

    public static final boolean copyRecursively(File $receiver, @NotNull File dst, @NotNull Function2<? super File, ? super IOException, ? extends OnErrorAction> onError) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(dst, "dst");
        Intrinsics.checkParameterIsNotNull(onError, "onError");
        if (!$receiver.exists()) {
            return Intrinsics.areEqual((Object)onError.invoke($receiver, new NoSuchFileException($receiver, null, "The source file doesn't exist", 2, null)), (Object)OnErrorAction.TERMINATE) ^ true;
        }
        try {
            Iterator<File> iterator2 = FilesKt.walkTopDown($receiver).fail((Function2<? super File, ? super IOException, Unit>)new Function2<File, IOException, Unit>(onError){
                final /* synthetic */ Function2 $onError;

                public final void invoke(@NotNull File f, @NotNull IOException e) {
                    Intrinsics.checkParameterIsNotNull(f, "f");
                    Intrinsics.checkParameterIsNotNull(e, "e");
                    if (Intrinsics.areEqual((Object)((Object)((OnErrorAction)((Object)this.$onError.invoke(f, e)))), (Object)((Object)OnErrorAction.TERMINATE))) {
                        throw (Throwable)new TerminateException(f);
                    }
                }
                {
                    this.$onError = function2;
                    super(2);
                }
            }).iterator();
            while (iterator2.hasNext()) {
                File src = iterator2.next();
                if (!src.exists()) {
                    if (!Intrinsics.areEqual((Object)onError.invoke(src, new NoSuchFileException(src, null, "The source file doesn't exist", 2, null)), (Object)OnErrorAction.TERMINATE)) continue;
                    return false;
                }
                String relPath = FilesKt.relativeTo(src, $receiver);
                File dstFile = new File(dst, relPath);
                if (!(!dstFile.exists() || src.isDirectory() && dstFile.isDirectory())) {
                    if (!Intrinsics.areEqual((Object)onError.invoke(dstFile, new FileAlreadyExistsException(src, dstFile, "The destination file already exists")), (Object)OnErrorAction.TERMINATE)) continue;
                    return false;
                }
                if (src.isDirectory()) {
                    dstFile.mkdirs();
                    continue;
                }
                if (FilesKt.copyTo$default(src, dstFile, true, 0, 4) == src.length() || !Intrinsics.areEqual((Object)onError.invoke(src, new IOException("src.length() != dst.length()")), (Object)OnErrorAction.TERMINATE)) continue;
                return false;
            }
            return true;
        }
        catch (TerminateException e) {
            return false;
        }
    }

    public static /* bridge */ /* synthetic */ boolean copyRecursively$default(File file, File file2, Function2 function2, int n) {
        if ((n & 2) != 0) {
            function2 = copyRecursively.1.INSTANCE;
        }
        return FilesKt.copyRecursively(file, file2, function2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean deleteRecursively(File $receiver) {
        void var3_3;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Sequence sequence2 = FilesKt.walkBottomUp($receiver);
        boolean initial$iv = $receiver.exists();
        boolean accumulator$iv = initial$iv;
        for (Object element$iv : $receiver$iv) {
            void it;
            File file = (File)element$iv;
            boolean res = accumulator$iv;
            accumulator$iv = it.delete() && res;
        }
        return (boolean)var3_3;
    }

    @Nullable
    public static final File[] listFiles(File $receiver, @NotNull Function1<? super File, Boolean> filter) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(filter, "filter");
        Function1<? super File, Boolean> function1 = filter;
        return $receiver.listFiles((FileFilter)(function1 == null ? null : new FilesKt__UtilsKt$sam$FileFilter$460519df(function1)));
    }

    public static final boolean startsWith(File $receiver, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        FilePathComponents components = FilesKt.toComponents($receiver);
        FilePathComponents otherComponents = FilesKt.toComponents(other);
        if (Intrinsics.areEqual(components.getRoot(), otherComponents.getRoot()) ^ true) {
            return false;
        }
        return components.getSize() < otherComponents.getSize() ? false : ((Object)components.getSegments().subList(0, otherComponents.getSize())).equals(otherComponents.getSegments());
    }

    public static final boolean startsWith(File $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return FilesKt.startsWith($receiver, new File(other));
    }

    public static final boolean endsWith(File $receiver, @NotNull File other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        FilePathComponents components = FilesKt.toComponents($receiver);
        FilePathComponents otherComponents = FilesKt.toComponents(other);
        if (otherComponents.isRooted()) {
            return Intrinsics.areEqual($receiver, other);
        }
        int shift = components.getSize() - otherComponents.getSize();
        return shift < 0 ? false : ((Object)components.getSegments().subList(shift, components.getSize())).equals(otherComponents.getSegments());
    }

    public static final boolean endsWith(File $receiver, @NotNull String other) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(other, "other");
        return FilesKt.endsWith($receiver, new File(other));
    }

    @NotNull
    public static final File normalize(File $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        FilePathComponents receiver$iv = FilesKt.toComponents($receiver);
        FilePathComponents $receiver2 = receiver$iv;
        File file = $receiver2.getRoot();
        Iterable iterable = FilesKt__UtilsKt.normalize($receiver2.getSegments());
        CharSequence charSequence = File.separator;
        Intrinsics.checkExpressionValueIsNotNull(charSequence, "File.separator");
        return FilesKt.resolve(file, CollectionsKt.joinToString$default(iterable, charSequence, null, null, 0, null, null, 62));
    }

    private static final FilePathComponents normalize(FilePathComponents $receiver) {
        return new FilePathComponents($receiver.getRoot(), FilesKt__UtilsKt.normalize($receiver.getSegments()));
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    private static final List<File> normalize(List<? extends File> $receiver) {
        list = new ArrayList<E>($receiver.size());
        block4: for (File file : $receiver) {
            v0 = var4_4 = file.getName();
            if (v0 != null) {
                switch (v0.hashCode()) {
                    case 1472: {
                        if (!var4_4.equals("..")) ** break;
                        break;
                    }
                    case 46: {
                        if (!var4_4.equals(".")) ** break;
                        continue block4;
                    }
                }
                if (!list.isEmpty() && Intrinsics.areEqual(((File)CollectionsKt.last(list)).getName(), "..") ^ true) {
                    list.remove(list.size() - 1);
                    continue;
                }
                list.add(file);
                continue;
            }
            list.add(file);
        }
        return list;
    }

    @NotNull
    public static final File resolve(File $receiver, @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        if (FilesKt.isRooted(relative)) {
            return relative;
        }
        String baseName = $receiver.toString();
        return StringsKt.isEmpty((CharSequence)baseName) || StringsKt.endsWith$default((CharSequence)baseName, File.separatorChar, false, 2) ? new File(baseName + relative) : new File(baseName + File.separatorChar + relative);
    }

    @NotNull
    public static final File resolve(File $receiver, @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        return FilesKt.resolve($receiver, new File(relative));
    }

    @NotNull
    public static final File resolveSibling(File $receiver, @NotNull File relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        FilePathComponents components = FilesKt.toComponents($receiver);
        File parentSubPath = components.getSize() == 0 ? new File("..") : components.subPath(0, components.getSize() - 1);
        return FilesKt.resolve(FilesKt.resolve(components.getRoot(), parentSubPath), relative);
    }

    @NotNull
    public static final File resolveSibling(File $receiver, @NotNull String relative) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(relative, "relative");
        return FilesKt.resolveSibling($receiver, new File(relative));
    }
}

