/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme;

import com.android.tools.idea.editors.theme.ColorPalette;
import com.android.tools.idea.editors.theme.ThemeEditorConstants;
import com.android.tools.idea.editors.theme.ThemeEditorTable;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AttributesPanel {
    private static final boolean ENABLE_ADVANCED_MODE = false;
    private static final int MAX_SIZE_THEME_SELECTOR = 25;
    public static final Border BORDER = JBUI.Borders.empty((int)10, (int)10);
    public static final Border LABEL_BORDER = BorderFactory.createEmptyBorder(ThemeEditorConstants.ATTRIBUTE_ROW_GAP, 0, ThemeEditorConstants.ATTRIBUTE_ROW_GAP, 0);
    public static final String THEME_SELECTOR_NAME = "Theme Selector";
    public static final String MODULE_SELECTOR_NAME = "Module Selector";
    private JComboBox myThemeCombo;
    private JCheckBox myAdvancedFilterCheckBox;
    private JButton myBackButton;
    private JBLabel mySubStyleLabel;
    private ThemeEditorTable myAttributesTable;
    private final JBScrollPane myAttributesScrollPane;
    private JPanel myRightPanel;
    private JComboBox myAttrGroupCombo;
    private ColorPalette myPalette;
    private JBScrollPane myPaletteScrollPane;
    private JComboBox myModuleCombo;
    private JBLabel myThemeLabel;
    private JBLabel myModuleLabel;

    public AttributesPanel() {
        this.$$$setupUI$$$();
        this.myThemeCombo.setMinimumSize(ThemeEditorConstants.ATTRIBUTES_PANEL_COMBO_MIN_SIZE);
        this.myModuleCombo.setMinimumSize(ThemeEditorConstants.ATTRIBUTES_PANEL_COMBO_MIN_SIZE);
        this.myBackButton.setIcon(AllIcons.Actions.Back);
        this.myBackButton.setBorder(BORDER);
        this.myThemeLabel.setBorder(LABEL_BORDER);
        this.myModuleLabel.setBorder(LABEL_BORDER);
        this.myThemeLabel.setText(String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), "Theme"));
        this.myModuleLabel.setText(String.format("<html><nobr><b><font color=\"#%1$s\">%2$s", ColorUtil.toHex((Color)ThemeEditorConstants.RESOURCE_ITEM_COLOR), "Module"));
        this.myPaletteScrollPane.setVisible(false);
        this.myAdvancedFilterCheckBox.setVisible(false);
        this.myAttrGroupCombo.setVisible(false);
        new ComboboxSpeedSearch(this.myThemeCombo);
        this.myBackButton.setToolTipText("Back to the theme");
        this.myAttributesTable.setSelectionMode(0);
        this.myAttributesTable.setTableHeader(null);
        new TableSpeedSearch((JTable)((Object)this.myAttributesTable)){

            protected int getElementCount() {
                return ((JTable)this.myComponent).getRowCount() * ((JTable)this.myComponent).getColumnCount();
            }
        };
        this.mySubStyleLabel.setVisible(false);
        this.mySubStyleLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.myPalette.setShowCheckeredBackground(true);
        this.myThemeCombo.setMinimumSize(new Dimension(JBUI.scale((int)10), this.myThemeCombo.getMinimumSize().height));
        this.myThemeCombo.setPreferredSize(new Dimension(JBUI.scale((int)10), this.myThemeCombo.getPreferredSize().height));
        this.myThemeCombo.setMaximumRowCount(25);
        this.myThemeCombo.setName(THEME_SELECTOR_NAME);
        this.myModuleCombo.setName(MODULE_SELECTOR_NAME);
        this.myModuleCombo.setRenderer(new ListCellRendererWrapper<Module>(){

            public void customize(JList list, Module value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getName());
            }
        });
        this.myAttributesScrollPane = new JBScrollPane((Component)this.myRightPanel, 20, 31);
        this.myAttributesTable.setBackground(null);
        this.myAttributesScrollPane.setBackground(null);
        this.myAttributesScrollPane.getViewport().setBackground(null);
        this.myAttributesScrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.myAttributesScrollPane.getVerticalScrollBar().setBlockIncrement(10);
    }

    public void setSelectedTheme(@Nullable String themeName) {
        this.myThemeCombo.getModel().setSelectedItem(themeName);
        this.myThemeCombo.hidePopup();
    }

    public void setAdvancedMode(boolean isAdvanced) {
        this.myAdvancedFilterCheckBox.setSelected(isAdvanced);
    }

    public boolean isAdvancedMode() {
        return this.myAdvancedFilterCheckBox.isSelected();
    }

    public void setSubstyleName(@Nullable String substyleName) {
        if (substyleName == null) {
            this.mySubStyleLabel.setVisible(false);
        } else {
            this.mySubStyleLabel.setVisible(true);
            this.mySubStyleLabel.setText("\u27a5 " + substyleName);
        }
    }

    public void setModuleModel(@NotNull ComboBoxModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/editors/theme/AttributesPanel", "setModuleModel"));
        }
        this.myModuleCombo.setModel(model);
        boolean isVisible = model.getSize() > 1;
        this.myModuleCombo.setVisible(isVisible);
        this.myModuleLabel.setVisible(isVisible);
    }

    public void addModuleChangedActionListener(@NotNull ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/editors/theme/AttributesPanel", "addModuleChangedActionListener"));
        }
        this.myModuleCombo.addActionListener(listener);
    }

    public JComboBox getThemeCombo() {
        return this.myThemeCombo;
    }

    public JComboBox getAttrGroupCombo() {
        return this.myAttrGroupCombo;
    }

    public ThemeEditorTable getAttributesTable() {
        return this.myAttributesTable;
    }

    public JButton getBackButton() {
        return this.myBackButton;
    }

    public JCheckBox getAdvancedFilterCheckBox() {
        return this.myAdvancedFilterCheckBox;
    }

    public JComponent getRightPanel() {
        return this.myAttributesScrollPane;
    }

    public ColorPalette getPalette() {
        return this.myPalette;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        ColorPalette colorPalette;
        JBScrollPane jBScrollPane;
        JComboBox jComboBox3;
        JCheckBox jCheckBox;
        JButton jButton;
        ThemeEditorTable themeEditorTable;
        JBLabel jBLabel3;
        JPanel jPanel;
        this.myRightPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(22, 17, 0, 24), null, 0, 0, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), 0, 0, false, false));
        jPanel.add((Component)jPanel2, "Center");
        this.mySubStyleLabel = jBLabel3 = new JBLabel();
        jBLabel3.setHorizontalTextPosition(2);
        jBLabel3.setEnabled(true);
        jBLabel3.setHorizontalAlignment(2);
        jBLabel3.setText("Dummy text");
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myAttributesTable = themeEditorTable = new ThemeEditorTable();
        ((JTable)((Object)themeEditorTable)).setRowMargin(0);
        ((JTable)((Object)themeEditorTable)).setShowHorizontalLines(false);
        ((JTable)((Object)themeEditorTable)).setShowVerticalLines(false);
        ((JTable)((Object)themeEditorTable)).setIntercellSpacing(new Dimension(1, 0));
        themeEditorTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        jPanel2.add((Component)((Object)themeEditorTable), new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myBackButton = jButton = new JButton();
        jButton.setText("");
        jPanel2.add((Component)jButton, new GridConstraints(3, 0, 1, 1, 0, 3, 1, 0, null, null, null));
        this.myAdvancedFilterCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Advanced");
        jPanel2.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAttrGroupCombo = jComboBox3 = new JComboBox();
        jPanel2.add(jComboBox3, new GridConstraints(3, 2, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myPaletteScrollPane = jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(4, 1, 1, 2, 0, 0, 3, 0, null, null, null));
        this.myPalette = colorPalette = new ColorPalette();
        jBScrollPane.setViewportView(colorPalette);
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(1, 1, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 1, null, null, null));
        this.myThemeCombo = jComboBox2 = new JComboBox();
        jPanel3.add(jComboBox2, new GridConstraints(4, 0, 1, 1, 8, 1, 6, 0, null, null, null));
        this.myModuleCombo = jComboBox = new JComboBox();
        jPanel3.add(jComboBox, new GridConstraints(1, 0, 1, 1, 8, 1, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel3.add((Component)spacer2, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
        this.myThemeLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Theme");
        jPanel3.add((Component)jBLabel2, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myModuleLabel = jBLabel = new JBLabel();
        jBLabel.setText("Module");
        jPanel3.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JSeparator jSeparator = new JSeparator();
        jSeparator.setOrientation(0);
        jPanel2.add((Component)jSeparator, new GridConstraints(5, 0, 1, 3, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel2.add((Component)spacer3, new GridConstraints(6, 1, 1, 2, 0, 2, 1, 0, null, new Dimension(-1, 14), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRightPanel;
    }
}

