/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.ddmlib.IDevice;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.repository.descriptors.IdDisplay;
import com.android.tools.idea.run.AvdComboBox;
import com.android.tools.idea.run.DeviceChooser;
import com.android.tools.idea.run.DeviceChooserListener;
import com.android.tools.idea.run.DeviceSelectionUtils;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Alarm;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExtendedDeviceChooserDialog
extends DialogWrapper {
    private final Project myProject;
    private final DeviceChooser myDeviceChooser;
    private JPanel myPanel;
    private JRadioButton myChooserRunningDeviceRadioButton;
    private JPanel myDeviceChooserWrapper;
    private JCheckBox myReuseSelectionCheckbox;
    private JRadioButton myLaunchEmulatorRadioButton;
    private final AvdComboBox myAvdCombo;
    private JLabel myAvdLabel;
    private JPanel myComboBoxWrapper;
    @NonNls
    private static final String SELECTED_AVD_PROPERTY = "ANDROID_EXTENDED_DEVICE_CHOOSER_AVD";
    @NonNls
    private static final String SELECTED_SERIALS_PROPERTY = "ANDROID_EXTENDED_DEVICE_CHOOSER_SERIALS";

    public ExtendedDeviceChooserDialog(final @NotNull AndroidFacet facet, @NotNull IAndroidTarget projectTarget, boolean multipleSelection, boolean showReuseDevicesCheckbox, boolean selectReuseDevicesCheckbox) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/run/ExtendedDeviceChooserDialog", "<init>"));
        }
        if (projectTarget == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "projectTarget", "com/android/tools/idea/run/ExtendedDeviceChooserDialog", "<init>"));
        }
        super(facet.getModule().getProject(), true, DialogWrapper.IdeModalityType.PROJECT);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(AndroidBundle.message("choose.device.dialog.title", objectArray));
        this.myProject = facet.getModule().getProject();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        String serialsStr = properties.getValue(SELECTED_SERIALS_PROPERTY);
        String[] selectedSerials = serialsStr != null ? serialsStr.split(" ") : null;
        this.getOKAction().setEnabled(false);
        this.myDeviceChooser = new DeviceChooser(multipleSelection, this.getOKAction(), facet, projectTarget, null);
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myDeviceChooser);
        this.myDeviceChooser.addListener(new DeviceChooserListener(){

            @Override
            public void selectedDevicesChanged() {
                ExtendedDeviceChooserDialog.this.myLaunchEmulatorRadioButton.setSelected(!ExtendedDeviceChooserDialog.this.myDeviceChooser.hasDevices());
                ExtendedDeviceChooserDialog.this.myChooserRunningDeviceRadioButton.setSelected(ExtendedDeviceChooserDialog.this.myDeviceChooser.hasDevices());
                ExtendedDeviceChooserDialog.this.updateEnabled();
            }
        });
        this.myAvdCombo = new AvdComboBox(this.myProject, false, true){

            @Override
            public Module getModule() {
                return facet.getModule();
            }
        };
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myAvdCombo);
        this.myAvdCombo.getComboBox().setRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value == null) {
                    this.append(AndroidBundle.message("android.ddms.nodevices", new Object[0]), ExtendedDeviceChooserDialog.this.myAvdCombo.getComboBox().isEnabled() ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                } else {
                    this.append(((IdDisplay)value).getDisplay());
                }
            }
        });
        this.myComboBoxWrapper.add((Component)((Object)this.myAvdCombo));
        this.myAvdLabel.setLabelFor((Component)((Object)this.myAvdCombo));
        this.myDeviceChooserWrapper.add(this.myDeviceChooser.getPanel());
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExtendedDeviceChooserDialog.this.updateEnabled();
            }
        };
        this.myLaunchEmulatorRadioButton.addActionListener(listener);
        this.myChooserRunningDeviceRadioButton.addActionListener(listener);
        this.myAvdCombo.getComboBox().addActionListener(listener);
        this.init();
        this.myDeviceChooser.init(selectedSerials);
        this.myLaunchEmulatorRadioButton.setSelected(!this.myDeviceChooser.hasDevices());
        this.myChooserRunningDeviceRadioButton.setSelected(this.myDeviceChooser.hasDevices());
        this.myAvdCombo.startUpdatingAvds(ModalityState.stateForComponent((Component)this.myPanel));
        String savedAvd = PropertiesComponent.getInstance((Project)this.myProject).getValue(SELECTED_AVD_PROPERTY);
        String avdToSelect = null;
        if (savedAvd != null) {
            ComboBoxModel model = this.myAvdCombo.getComboBox().getModel();
            int n = model.getSize();
            for (int i = 0; i < n; ++i) {
                String id;
                IdDisplay item = (IdDisplay)model.getElementAt(i);
                String string = id = item == null ? null : item.getId();
                if (!savedAvd.equals(id)) continue;
                avdToSelect = id;
                break;
            }
        }
        if (avdToSelect != null) {
            this.myAvdCombo.getComboBox().setSelectedItem(new IdDisplay(avdToSelect, ""));
        } else if (this.myAvdCombo.getComboBox().getModel().getSize() > 0) {
            this.myAvdCombo.getComboBox().setSelectedIndex(0);
        }
        this.myReuseSelectionCheckbox.setVisible(showReuseDevicesCheckbox);
        this.myReuseSelectionCheckbox.setSelected(selectReuseDevicesCheckbox);
        this.updateEnabled();
        this.initValidation();
    }

    private void updateOkButton() {
        if (this.myLaunchEmulatorRadioButton.isSelected()) {
            this.getOKAction().setEnabled(this.getSelectedAvd() != null);
        } else {
            for (IDevice selectedDevice : this.getSelectedDevices()) {
                if (selectedDevice.isOffline()) continue;
                this.getOKAction().setEnabled(true);
                break;
            }
        }
    }

    private void updateEnabled() {
        this.myAvdCombo.setEnabled(this.myLaunchEmulatorRadioButton.isSelected());
        this.myAvdLabel.setEnabled(this.myLaunchEmulatorRadioButton.isSelected());
        this.myDeviceChooser.setEnabled(this.myChooserRunningDeviceRadioButton.isSelected());
        this.updateOkButton();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDeviceChooser.getPreferredFocusComponent();
    }

    @Nullable
    protected String getHelpId() {
        return "reference.android.chooseDevice";
    }

    protected void doOKAction() {
        this.myDeviceChooser.finish();
        PropertiesComponent properties = PropertiesComponent.getInstance((Project)this.myProject);
        properties.setValue(SELECTED_SERIALS_PROPERTY, DeviceSelectionUtils.serialize(this.getSelectedDevices()));
        IdDisplay selectedAvd = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        if (selectedAvd != null) {
            properties.setValue(SELECTED_AVD_PROPERTY, selectedAvd.getId());
        } else {
            properties.unsetValue(SELECTED_AVD_PROPERTY);
        }
        super.doOKAction();
    }

    protected String getDimensionServiceKey() {
        return "AndroidExtendedDeviceChooserDialog";
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    @Nullable
    protected ValidationInfo doValidate() {
        return this.myDeviceChooser.doValidate();
    }

    @NotNull
    protected Alarm.ThreadToUse getValidationThreadToUse() {
        Alarm.ThreadToUse threadToUse = Alarm.ThreadToUse.POOLED_THREAD;
        if (threadToUse == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ExtendedDeviceChooserDialog", "getValidationThreadToUse"));
        }
        return threadToUse;
    }

    @NotNull
    public IDevice[] getSelectedDevices() {
        IDevice[] iDeviceArray = this.myDeviceChooser.getSelectedDevices();
        if (iDeviceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ExtendedDeviceChooserDialog", "getSelectedDevices"));
        }
        return iDeviceArray;
    }

    @Nullable
    public String getSelectedAvd() {
        IdDisplay value = (IdDisplay)this.myAvdCombo.getComboBox().getSelectedItem();
        return value == null ? null : value.getId();
    }

    public boolean isToLaunchEmulator() {
        return this.myLaunchEmulatorRadioButton.isSelected();
    }

    public boolean useSameDevicesAgain() {
        return this.myReuseSelectionCheckbox.isSelected();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JCheckBox jCheckBox;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myDeviceChooserWrapper = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myReuseSelectionCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Use same device for future launches");
        jPanel3.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myChooserRunningDeviceRadioButton = jRadioButton2 = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton2, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.running.device.radio"));
        jRadioButton2.setSelected(true);
        jPanel3.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myLaunchEmulatorRadioButton = jRadioButton = new JRadioButton();
        this.$$$loadButtonText$$$(jRadioButton, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.launch.emulator.radio"));
        jPanel3.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myAvdLabel = jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, ResourceBundle.getBundle("messages/AndroidBundle").getString("android.extended.device.chooser.avd.label"));
        jPanel3.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 2));
        this.myComboBoxWrapper = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(3, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

