/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.impl.compiled.SignatureParsing;
import com.intellij.psi.impl.compiled.StubBuildingVisitor;
import com.intellij.util.Function;
import com.intellij.util.cls.ClsFormatException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.Type;

public class GroovyTraitFieldsFileIndex
extends FileBasedIndexExtension<Integer, Collection<TraitFieldDescriptor>>
implements DataIndexer<Integer, Collection<TraitFieldDescriptor>, FileContent>,
DataExternalizer<Collection<TraitFieldDescriptor>> {
    public static final ID<Integer, Collection<TraitFieldDescriptor>> INDEX_ID = ID.create((String)"groovy.trait.fields");
    public static final String HELPER_SUFFIX = "$Trait$FieldHelper.class";
    public static final FileBasedIndex.InputFilter INPUT_FILTER = new DefaultFileTypeSpecificInputFilter(new FileType[]{JavaClassFileType.INSTANCE}){

        public boolean acceptInput(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex$1", "acceptInput"));
            }
            return StringUtil.endsWith((CharSequence)file.getNameSequence(), (CharSequence)GroovyTraitFieldsFileIndex.HELPER_SUFFIX);
        }
    };
    private static final Logger LOG = Logger.getInstance(GroovyTraitFieldsFileIndex.class);
    private static final String INSTANCE_PREFIX = "$ins";
    private static final String STATIC_PREFIX = "$static";
    private static final String PRIVATE_PREFIX = "$0";
    private static final String PUBLIC_PREFIX = "$1";
    private static final String DELIMITER = "__";

    @NotNull
    public ID<Integer, Collection<TraitFieldDescriptor>> getName() {
        ID<Integer, Collection<TraitFieldDescriptor>> iD = INDEX_ID;
        if (iD == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "getName"));
        }
        return iD;
    }

    @NotNull
    public DataIndexer<Integer, Collection<TraitFieldDescriptor>, FileContent> getIndexer() {
        GroovyTraitFieldsFileIndex groovyTraitFieldsFileIndex = this;
        if (groovyTraitFieldsFileIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "getIndexer"));
        }
        return groovyTraitFieldsFileIndex;
    }

    @NotNull
    public KeyDescriptor<Integer> getKeyDescriptor() {
        EnumeratorIntegerDescriptor enumeratorIntegerDescriptor = EnumeratorIntegerDescriptor.INSTANCE;
        if (enumeratorIntegerDescriptor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "getKeyDescriptor"));
        }
        return enumeratorIntegerDescriptor;
    }

    @NotNull
    public DataExternalizer<Collection<TraitFieldDescriptor>> getValueExternalizer() {
        GroovyTraitFieldsFileIndex groovyTraitFieldsFileIndex = this;
        if (groovyTraitFieldsFileIndex == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "getValueExternalizer"));
        }
        return groovyTraitFieldsFileIndex;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        FileBasedIndex.InputFilter inputFilter = INPUT_FILTER;
        if (inputFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "getInputFilter"));
        }
        return inputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 2;
    }

    @NotNull
    public Map<Integer, Collection<TraitFieldDescriptor>> map(@NotNull FileContent inputData) {
        Map<Integer, Collection<TraitFieldDescriptor>> map;
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "map"));
        }
        try {
            map = GroovyTraitFieldsFileIndex.mapInner(inputData);
        }
        catch (Exception e) {
            LOG.warn((Throwable)e);
            Map<Integer, Collection<TraitFieldDescriptor>> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "map"));
            }
            return map2;
        }
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "map"));
        }
        return map;
    }

    @NotNull
    private static Map<Integer, Collection<TraitFieldDescriptor>> mapInner(@NotNull FileContent inputData) {
        if (inputData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputData", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "mapInner"));
        }
        final int key = FileBasedIndex.getFileId((VirtualFile)inputData.getFile());
        final HashMap result = ContainerUtil.newHashMap();
        new ClassReader(inputData.getContent()).accept(new ClassVisitor(327680){

            public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
                this.processField(access, name, desc, signature);
                return null;
            }

            private void processField(int access, String name, String desc, String signature) {
                Collection values;
                if ((access & 0x1000) == 0) {
                    return;
                }
                Pair<Boolean, String> p = this.parse(GroovyTraitFieldsFileIndex.STATIC_PREFIX, GroovyTraitFieldsFileIndex.INSTANCE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isStatic = (Boolean)p.first;
                name = (String)p.second;
                p = this.parse(GroovyTraitFieldsFileIndex.PUBLIC_PREFIX, GroovyTraitFieldsFileIndex.PRIVATE_PREFIX, name);
                if (p.first == null) {
                    return;
                }
                boolean isPublic = (Boolean)p.first;
                name = (String)p.second;
                String typeString = this.fieldType(desc, signature);
                if (typeString == null) {
                    return;
                }
                int delimiter = name.indexOf(GroovyTraitFieldsFileIndex.DELIMITER);
                if (delimiter > -1) {
                    name = name.substring(delimiter + GroovyTraitFieldsFileIndex.DELIMITER.length());
                }
                if ((values = (Collection)result.get(key)) == null) {
                    values = ContainerUtil.newArrayList();
                    result.put(key, values);
                }
                values.add(new TraitFieldDescriptor(isStatic, isPublic, typeString, name));
            }

            private Pair<Boolean, String> parse(String prefix, String prefix2, String input) {
                if (input.startsWith(prefix)) {
                    return Pair.create((Object)true, (Object)input.substring(prefix.length()));
                }
                if (input.startsWith(prefix2)) {
                    return Pair.create((Object)false, (Object)input.substring(prefix2.length()));
                }
                return Pair.create(null, (Object)input);
            }

            private String fieldType(String desc, String signature) {
                if (signature != null) {
                    try {
                        return SignatureParsing.parseTypeString((CharacterIterator)new StringCharacterIterator(signature), (Function)StubBuildingVisitor.GUESSING_MAPPER);
                    }
                    catch (ClsFormatException clsFormatException) {
                        // empty catch block
                    }
                }
                String raw = Type.getType((String)desc).getClassName();
                return (String)StubBuildingVisitor.GUESSING_MAPPER.fun((Object)raw);
            }
        }, 1);
        HashMap hashMap = result;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "mapInner"));
        }
        return hashMap;
    }

    public void save(@NotNull DataOutput out, Collection<TraitFieldDescriptor> values) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "out", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "save"));
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)values.size());
        for (TraitFieldDescriptor descriptor : values) {
            DataInputOutputUtil.writeSINT((DataOutput)out, (int)(descriptor.isStatic ? 1 : 0));
            DataInputOutputUtil.writeSINT((DataOutput)out, (int)(descriptor.isPublic ? 1 : 0));
            IOUtil.writeUTF((DataOutput)out, (String)descriptor.typeString);
            IOUtil.writeUTF((DataOutput)out, (String)descriptor.name);
        }
    }

    public Collection<TraitFieldDescriptor> read(@NotNull DataInput in) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex", "read"));
        }
        int size = DataInputOutputUtil.readINT((DataInput)in);
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)size);
        while (size-- > 0) {
            result.add(new TraitFieldDescriptor(DataInputOutputUtil.readSINT((DataInput)in) > 0, DataInputOutputUtil.readSINT((DataInput)in) > 0, IOUtil.readUTF((DataInput)in), IOUtil.readUTF((DataInput)in)));
        }
        return result;
    }

    public static class TraitFieldDescriptor {
        public final boolean isStatic;
        public final boolean isPublic;
        @NotNull
        public final String typeString;
        @NotNull
        public final String name;

        TraitFieldDescriptor(boolean aStatic, boolean aPublic, @NotNull String typeString, @NotNull String name) {
            if (typeString == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeString", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex$TraitFieldDescriptor", "<init>"));
            }
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/resolve/GroovyTraitFieldsFileIndex$TraitFieldDescriptor", "<init>"));
            }
            this.isStatic = aStatic;
            this.isPublic = aPublic;
            this.typeString = typeString;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TraitFieldDescriptor that = (TraitFieldDescriptor)o;
            if (this.isStatic != that.isStatic) {
                return false;
            }
            if (this.isPublic != that.isPublic) {
                return false;
            }
            if (!this.typeString.equals(that.typeString)) {
                return false;
            }
            return this.name.equals(that.name);
        }

        public int hashCode() {
            int result = this.isStatic ? 1 : 0;
            result = 31 * result + (this.isPublic ? 1 : 0);
            result = 31 * result + this.typeString.hashCode();
            result = 31 * result + this.name.hashCode();
            return result;
        }
    }
}

