/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.refactoring.inline;

import com.intellij.lang.findUsages.DescriptiveNameUtil;
import com.intellij.lang.refactoring.InlineHandler;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GrClassSubstitution;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.util.GrVariableDeclarationOwner;
import org.jetbrains.plugins.groovy.refactoring.GroovyRefactoringBundle;
import org.jetbrains.plugins.groovy.refactoring.inline.GrInlineFieldUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.GrVariableInliner;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyInlineMethodUtil;
import org.jetbrains.plugins.groovy.refactoring.inline.GroovyMethodInliner;

public class GroovyInlineHandler
implements InlineHandler {
    @Nullable
    public InlineHandler.Settings prepareInlineElement(@NotNull PsiElement element, @Nullable Editor editor, boolean invokedOnReference) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/refactoring/inline/GroovyInlineHandler", "prepareInlineElement"));
        }
        if (element instanceof GrField) {
            return GrInlineFieldUtil.inlineFieldSettings((GrField)element, editor, invokedOnReference);
        }
        if (element instanceof GrMethod) {
            return GroovyInlineMethodUtil.inlineMethodSettings((GrMethod)element, editor, invokedOnReference);
        }
        if (element instanceof GrTypeDefinition || element instanceof GrClassSubstitution) {
            return null;
        }
        if (element instanceof PsiMember) {
            String message = GroovyRefactoringBundle.message("cannot.inline.0.", GroovyInlineHandler.getFullName(element));
            CommonRefactoringUtil.showErrorHint((Project)element.getProject(), (Editor)editor, (String)message, (String)"", (String)"refactoring.inlineField");
            return InlineHandler.Settings.CANNOT_INLINE_SETTINGS;
        }
        return null;
    }

    private static String getFullName(PsiElement psi) {
        String name = DescriptiveNameUtil.getDescriptiveName((PsiElement)psi);
        return (UsageViewUtil.getType((PsiElement)psi) + " " + name).trim();
    }

    public void removeDefinition(PsiElement element, InlineHandler.Settings settings) {
        PsiElement owner = element.getParent().getParent();
        if (element instanceof GrVariable && owner instanceof GrVariableDeclarationOwner) {
            ((GrVariableDeclarationOwner)owner).removeVariable((GrVariable)element);
        }
        if (element instanceof GrMethod) {
            element.delete();
        }
    }

    @Nullable
    public InlineHandler.Inliner createInliner(PsiElement element, InlineHandler.Settings settings) {
        if (element instanceof GrVariable) {
            return new GrVariableInliner((GrVariable)element, settings);
        }
        if (element instanceof GrMethod) {
            return new GroovyMethodInliner((GrMethod)element);
        }
        return null;
    }
}

