/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.descriptorUtils;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.js.descriptorUtils.DescriptorUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001f\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!B\u0001\u0005\u0005\u0015\t\u0001bB\u0003\u0001\u000b\u0005AY!\u0002\u0001\u0006\u00031\tQ\u0002\u0004\u0005\u0004\u001b\u0005A:!F\u0001\u0019\u0003e%\u0001\u0002B\u0007\u00021\u0013\u00016\u0011\u0001+\u0004\u000655\u0001\"B\u0007\u00021\u0013)\u0012\u0001g\u0003U\u0007\u000b\tj\u0002B\"\t\u0011\u0001i!\u0001$\u0001\u0019\u0002U\t\u0001$\u0001\u000f$#\u000e\u0019QB\u0001C\u0002\u0011\t!6Q\u0001"}, strings={"nameIfStandardType", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/types/KotlinType;", "getNameIfStandardType", "(Lorg/jetbrains/kotlin/types/KotlinType;)Lorg/jetbrains/kotlin/name/Name;", "DescriptorUtilsKt", "getJetTypeFqName", "", "printTypeArguments", "", "hasPrimaryConstructor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;"}, moduleName="kotlin-compiler")
public final class DescriptorUtilsKt {
    @Nullable
    public static final Name getNameIfStandardType(KotlinType $receiver) {
        Object object;
        ClassifierDescriptor descriptor2;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor classifierDescriptor = descriptor2 = $receiver.getConstructor().getDeclarationDescriptor();
        if (Intrinsics.areEqual(classifierDescriptor != null ? classifierDescriptor.getContainingDeclaration() : null, (object = descriptor2) != null && (object = org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt.getBuiltIns((DeclarationDescriptor)object)) != null ? ((KotlinBuiltIns)object).getBuiltInsPackageFragment() : null)) {
            ClassifierDescriptor classifierDescriptor2 = descriptor2;
            return classifierDescriptor2 != null ? classifierDescriptor2.getName() : null;
        }
        return null;
    }

    @NotNull
    public static final String getJetTypeFqName(KotlinType $receiver, boolean printTypeArguments) {
        String typeArgumentsAsString;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ClassifierDescriptor declaration = PreconditionsKt.requireNotNull($receiver.getConstructor().getDeclarationDescriptor());
        if (declaration instanceof TypeParameterDescriptor) {
            String string = StringUtil.join((Collection)((TypeParameterDescriptor)declaration).getUpperBounds(), new Function<? super T, String>(printTypeArguments){
                final /* synthetic */ boolean $printTypeArguments;

                @NotNull
                public final String fun(KotlinType type2) {
                    return DescriptorUtilsKt.getJetTypeFqName(type2, this.$printTypeArguments);
                }
                {
                    this.$printTypeArguments = bl;
                }
            }, "&");
            Intrinsics.checkExpressionValueIsNotNull(string, "StringUtil.join(declarat\u2026intTypeArguments) }, \"&\")");
            return string;
        }
        List<TypeProjection> typeArguments = $receiver.getArguments();
        if (printTypeArguments && !typeArguments.isEmpty()) {
            String joinedTypeArguments2 = StringUtil.join((Collection)typeArguments, (Function)getJetTypeFqName.joinedTypeArguments.1.INSTANCE, ", ");
            typeArgumentsAsString = "<" + joinedTypeArguments2 + ">";
        } else {
            typeArgumentsAsString = "";
        }
        return DescriptorUtils.getFqName(declaration).asString() + typeArgumentsAsString;
    }

    public static final boolean hasPrimaryConstructor(ClassDescriptor $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver.getUnsubstitutedPrimaryConstructor() != null;
    }
}

