/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.intrinsic.functions.factories;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperation;
import com.google.dart.compiler.backend.js.ast.JsBinaryOperator;
import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsPrefixOperation;
import com.google.dart.compiler.backend.js.ast.JsUnaryOperator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.js.patterns.DescriptorPredicate;
import org.jetbrains.kotlin.js.patterns.NamePredicate;
import org.jetbrains.kotlin.js.patterns.PatternBuilder;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.basic.FunctionIntrinsic;
import org.jetbrains.kotlin.js.translate.intrinsic.functions.factories.FunctionIntrinsicFactory;
import org.jetbrains.kotlin.js.translate.operation.OperatorTable;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.JsDescriptorUtils;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public enum PrimitiveUnaryOperationFIF implements FunctionIntrinsicFactory
{
    INSTANCE;

    private static final NamePredicate UNARY_OPERATIONS;
    @NotNull
    private static final DescriptorPredicate UNARY_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final Predicate<FunctionDescriptor> PRIMITIVE_UNARY_OPERATION_NAMES;
    @NotNull
    private static final DescriptorPredicate NO_PARAMETERS;
    @NotNull
    private static final Predicate<FunctionDescriptor> PATTERN;
    @NotNull
    private static final DescriptorPredicate INC_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final DescriptorPredicate DEC_OPERATION_FOR_PRIMITIVE_NUMBER;
    @NotNull
    private static final FunctionIntrinsic NUMBER_INC_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic NUMBER_DEC_INTRINSIC;
    @NotNull
    private static final FunctionIntrinsic CHAR_PLUS;
    @NotNull
    private static final FunctionIntrinsic CHAR_MINUS;
    @NotNull
    private static final FunctionIntrinsic CHAR_INC;
    @NotNull
    private static final FunctionIntrinsic CHAR_DEC;

    @Override
    @Nullable
    public FunctionIntrinsic getIntrinsic(@NotNull FunctionDescriptor descriptor2) {
        JsUnaryOperator jsOperator;
        if (descriptor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF", "getIntrinsic"));
        }
        if (!PATTERN.apply(descriptor2)) {
            return null;
        }
        if (PatternBuilder.pattern("Char.unaryPlus()").apply(descriptor2)) {
            return CHAR_PLUS;
        }
        if (PatternBuilder.pattern("Char.unaryMinus()").apply(descriptor2)) {
            return CHAR_MINUS;
        }
        if (PatternBuilder.pattern("Char.plus()").apply(descriptor2)) {
            return CHAR_PLUS;
        }
        if (PatternBuilder.pattern("Char.minus()").apply(descriptor2)) {
            return CHAR_MINUS;
        }
        if (PatternBuilder.pattern("Char.inc()").apply(descriptor2)) {
            return CHAR_INC;
        }
        if (PatternBuilder.pattern("Char.dec()").apply(descriptor2)) {
            return CHAR_DEC;
        }
        if (INC_OPERATION_FOR_PRIMITIVE_NUMBER.apply(descriptor2)) {
            return NUMBER_INC_INTRINSIC;
        }
        if (DEC_OPERATION_FOR_PRIMITIVE_NUMBER.apply(descriptor2)) {
            return NUMBER_DEC_INTRINSIC;
        }
        Name name = descriptor2.getName();
        if ("inv".equals(name.asString())) {
            jsOperator = JsUnaryOperator.BIT_NOT;
        } else {
            KtToken jetToken = OperatorConventions.UNARY_OPERATION_NAMES_WITH_DEPRECATED_INVERTED.get(name);
            jsOperator = OperatorTable.getUnaryOperator(jetToken);
        }
        final JsUnaryOperator finalJsOperator = jsOperator;
        return new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$8", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$8", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.size() == 0) : "Unary operator should not have arguments.";
                JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(finalJsOperator, receiver);
                if (jsPrefixOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$8", "apply"));
                }
                return jsPrefixOperation;
            }
        };
    }

    static {
        UNARY_OPERATIONS = new NamePredicate(OperatorNameConventions.UNARY_OPERATION_NAMES);
        UNARY_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS_MAPPED_TO_PRIMITIVE_JS, UNARY_OPERATIONS);
        PRIMITIVE_UNARY_OPERATION_NAMES = Predicates.or(UNARY_OPERATION_FOR_PRIMITIVE_NUMBER, PatternBuilder.pattern("Boolean.not"), PatternBuilder.pattern("Int.inv"));
        NO_PARAMETERS = new DescriptorPredicate(){

            @Override
            public boolean apply(@Nullable FunctionDescriptor descriptor2) {
                assert (descriptor2 != null) : "argument for DescriptorPredicate.apply should not be null";
                return !JsDescriptorUtils.hasParameters(descriptor2);
            }
        };
        PATTERN = Predicates.and(PRIMITIVE_UNARY_OPERATION_NAMES, NO_PARAMETERS);
        INC_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, "inc");
        DEC_OPERATION_FOR_PRIMITIVE_NUMBER = PatternBuilder.pattern(NamePredicate.PRIMITIVE_NUMBERS, "dec");
        NUMBER_INC_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$2", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$2", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.size() == 0);
                JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.ADD, receiver, context.program().getNumberLiteral(1));
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$2", "apply"));
                }
                return jsBinaryOperation;
            }
        };
        NUMBER_DEC_INTRINSIC = new FunctionIntrinsic(){

            @Override
            @NotNull
            public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
                if (arguments2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$3", "apply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$3", "apply"));
                }
                assert (receiver != null);
                assert (arguments2.size() == 0);
                JsBinaryOperation jsBinaryOperation = new JsBinaryOperation(JsBinaryOperator.SUB, receiver, context.program().getNumberLiteral(1));
                if (jsBinaryOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$3", "apply"));
                }
                return jsBinaryOperation;
            }
        };
        CHAR_PLUS = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                if (receiver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4", "doApply"));
                }
                JsExpression jsExpression = JsAstUtils.charToInt(receiver);
                if (jsExpression == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$4", "doApply"));
                }
                return jsExpression;
            }
        };
        CHAR_MINUS = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                if (receiver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$5", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$5", "doApply"));
                }
                JsPrefixOperation jsPrefixOperation = new JsPrefixOperation(JsUnaryOperator.NEG, JsAstUtils.charToInt(receiver));
                if (jsPrefixOperation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$5", "doApply"));
                }
                return jsPrefixOperation;
            }
        };
        CHAR_INC = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                if (receiver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6", "doApply"));
                }
                JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("charInc", receiver);
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$6", "doApply"));
                }
                return jsInvocation;
            }
        };
        CHAR_DEC = new UnaryOperationInstrinsicBase(){

            @Override
            @NotNull
            public JsExpression doApply(@NotNull JsExpression receiver, @NotNull TranslationContext context) {
                if (receiver == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "receiver", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7", "doApply"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7", "doApply"));
                }
                JsInvocation jsInvocation = JsAstUtils.invokeKotlinFunction("charDec", receiver);
                if (jsInvocation == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$7", "doApply"));
                }
                return jsInvocation;
            }
        };
    }

    private static abstract class UnaryOperationInstrinsicBase
    extends FunctionIntrinsic {
        private UnaryOperationInstrinsicBase() {
        }

        @NotNull
        public abstract JsExpression doApply(@NotNull JsExpression var1, @NotNull TranslationContext var2);

        @Override
        @NotNull
        public JsExpression apply(@Nullable JsExpression receiver, @NotNull List<JsExpression> arguments2, @NotNull TranslationContext context) {
            if (arguments2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase", "apply"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase", "apply"));
            }
            assert (receiver != null);
            assert (arguments2.size() == 0);
            JsExpression jsExpression = this.doApply(receiver, context);
            if (jsExpression == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/js/translate/intrinsic/functions/factories/PrimitiveUnaryOperationFIF$UnaryOperationInstrinsicBase", "apply"));
            }
            return jsExpression;
        }
    }
}

