/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.google.dart.compiler.backend.js.ast.JsExpression;
import com.google.dart.compiler.backend.js.ast.JsFunction;
import com.google.dart.compiler.backend.js.ast.JsInvocation;
import com.google.dart.compiler.backend.js.ast.JsName;
import com.google.dart.compiler.backend.js.ast.JsNameRef;
import com.google.dart.compiler.backend.js.ast.JsParameter;
import com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import com.google.dart.compiler.backend.js.ast.JsScope;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.context.TranslationContext;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;

@KotlinFileFacade(version={1, 0, 1}, abiVersion=32, data={"\u001d\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u00015%\u0002\u0002A\u0007\u00021\u0003I2\u0001C\u0001\u000e\u0003a\r\u0011d\u0001\u0005\u0003\u001b\u0005A\u001a!G\u0002\t\u00065\t\u0001dA\r\u0004\u0011\u000fi\u0011\u0001\u0007\u0003U\u0007\u0013\u0001"}, strings={"generateDelegateCall", "Lcom/google/dart/compiler/backend/js/ast/JsPropertyInitializer;", "fromDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "toDescriptor", "thisObject", "Lcom/google/dart/compiler/backend/js/ast/JsExpression;", "context", "Lorg/jetbrains/kotlin/js/translate/context/TranslationContext;", "UtilsKt"}, moduleName="kotlin-compiler")
public final class UtilsKt {
    @NotNull
    public static final JsPropertyInitializer generateDelegateCall(@NotNull FunctionDescriptor fromDescriptor, @NotNull FunctionDescriptor toDescriptor, @NotNull JsExpression thisObject, @NotNull TranslationContext context) {
        Intrinsics.checkParameterIsNotNull(fromDescriptor, "fromDescriptor");
        Intrinsics.checkParameterIsNotNull(toDescriptor, "toDescriptor");
        Intrinsics.checkParameterIsNotNull(thisObject, "thisObject");
        Intrinsics.checkParameterIsNotNull(context, "context");
        JsName delegateMemberFunctionName = context.getNameForDescriptor(fromDescriptor);
        JsName overriddenMemberFunctionName = context.getNameForDescriptor(toDescriptor);
        JsNameRef overriddenMemberFunctionRef = new JsNameRef(overriddenMemberFunctionName, thisObject);
        SmartList<JsParameter> parameters2 = new SmartList<JsParameter>();
        SmartList<JsNameRef> args = new SmartList<JsNameRef>();
        JsScope functionScope = context.getScopeForDescriptor(fromDescriptor);
        if (DescriptorUtils.isExtension(fromDescriptor)) {
            JsName extensionFunctionReceiverName = functionScope.declareName(Namer.getReceiverParameterName());
            parameters2.add(new JsParameter(extensionFunctionReceiverName));
            args.add(new JsNameRef(extensionFunctionReceiverName));
        }
        for (ValueParameterDescriptor param : fromDescriptor.getValueParameters()) {
            String paramName = param.getName().asString();
            JsName jsParamName = functionScope.declareName(paramName);
            parameters2.add(new JsParameter(jsParamName));
            args.add(new JsNameRef(jsParamName));
        }
        JsFunction functionObject = TranslationUtils.simpleReturnFunction(context.getScopeForDescriptor(fromDescriptor), new JsInvocation((JsExpression)overriddenMemberFunctionRef, (List<JsExpression>)args));
        functionObject.getParameters().addAll((Collection<JsParameter>)parameters2);
        return new JsPropertyInitializer(delegateMemberFunctionName.makeRef(), functionObject);
    }
}

