/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.PreconditionsKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.load.java.BuiltinSpecialProperties;
import org.jetbrains.kotlin.load.java.SpecialBuiltinMembers;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"?\u0015\tA\"A\u0003\u0002\u0011\u0001)\u0011\u0001B\u0001\u0006\u0003!\tR!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001\u0003\n\u0006\u00031\tQ!\u0001\u0005\u0011\u000b\u0001)\u0011\u0001D\u0001\u0006\u0003\u0011\u0019Q!\u0001E\u0006\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u0001bB\u0003\u0001\t\r\fA\u0002A\r\u00021\u0003\t;\u0001B\u0001R\u0007\u0005A\u0011!\n\u0006\t\u00105!\u0011BA\u0005\u00021\u0011AJ!G\u0002\t\u00115\t\u0001\u0004B\u0013\b\u0011#i\u0011\u0001G\u0005\u001a\u0007!MQ\"\u0001\r\u000bK\u0019A)\"\u0004\u0002\r\u0002aYQ#\u0001\r\u000bK\u0019!\u0011\u0001c\u0006\u000e\u0003aIQ#\u0001\r\u000bS)!\u0011\t\u0003E\u0002\u001b\u0011I!!C\u0001\u0019\u0006a\u0011\u0011kA\u0001\u0006\u0001%\u0002B!\u0011\u0005\t\u00075Q\u0011BA\u0005\u00021\u0011IQ!\u0003\u0003\n\u0005%\t\u0001\u0004\u0002M\u00051\u000f\t6!A\u0003\u0001S?!\u0011\t\u0003\u0005\u0006\u001b'I!!C\u0001\u0019\u0006%%\u0011r\u0001\r\u0005#\u000e\tA1\u0002M\u0004#\u000e\tQ\u0001AU\u0010\t\u0001C\u0001BBG\u0007\u0013\u0013I9\u0001\u0007\u0003R\u0007\u0005!Y\u0001\u0007\u0002R\u0007\u0011)\u0001!\u0004\u0002\u0005\u000e!9\u0001"}, strings={"Lorg/jetbrains/kotlin/load/java/BuiltinSpecialProperties;", "", "()V", "FQ_NAMES", "", "Lorg/jetbrains/kotlin/name/FqName;", "GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP", "", "Lorg/jetbrains/kotlin/name/Name;", "", "PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP", "Lorg/jetbrains/annotations/NotNull;", "SHORT_NAMES", "getSHORT_NAMES$kotlin_compiler", "()Ljava/util/Set;", "getPropertyNameCandidatesBySpecialGetterName", "name1", "hasBuiltinSpecialPropertyFqName", "", "callableMemberDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "getBuiltinSpecialPropertyGetterName", "", "hasBuiltinSpecialPropertyFqNameImpl"}, moduleName="kotlin-compiler")
public final class BuiltinSpecialProperties {
    private static final Map<FqName, Name> PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP;
    private static final Map<Name, List<Name>> GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP;
    private static final Set<FqName> FQ_NAMES;
    @NotNull
    public static final Set<Name> SHORT_NAMES;
    public static final BuiltinSpecialProperties INSTANCE;
    public static final BuiltinSpecialProperties INSTANCE$;

    @NotNull
    public final Set<Name> getSHORT_NAMES$kotlin_compiler() {
        return SHORT_NAMES;
    }

    public final boolean hasBuiltinSpecialPropertyFqName(@NotNull CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkParameterIsNotNull(callableMemberDescriptor, "callableMemberDescriptor");
        if (SHORT_NAMES.contains(callableMemberDescriptor.getName()) ^ true) {
            return false;
        }
        return this.hasBuiltinSpecialPropertyFqNameImpl(callableMemberDescriptor);
    }

    private final boolean hasBuiltinSpecialPropertyFqNameImpl(CallableMemberDescriptor $receiver) {
        boolean bl;
        block3: {
            if (CollectionsKt.contains((Iterable)FQ_NAMES, DescriptorUtilsKt.fqNameOrNull($receiver))) {
                return true;
            }
            if (!SpecialBuiltinMembers.isFromBuiltins($receiver)) {
                return false;
            }
            Iterable $receiver$iv = $receiver.getOverriddenDescriptors();
            for (Object element$iv : $receiver$iv) {
                CallableMemberDescriptor it;
                CallableMemberDescriptor callableMemberDescriptor = it = (CallableMemberDescriptor)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(callableMemberDescriptor, "it");
                if (!INSTANCE.hasBuiltinSpecialPropertyFqName(callableMemberDescriptor)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final List<Name> getPropertyNameCandidatesBySpecialGetterName(@NotNull Name name1) {
        Intrinsics.checkParameterIsNotNull(name1, "name1");
        List<Name> list = GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP.get(name1);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Nullable
    public final String getBuiltinSpecialPropertyGetterName(CallableMemberDescriptor $receiver) {
        Unit unit;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        boolean value$iv = SpecialBuiltinMembers.isFromBuiltins($receiver);
        if (PreconditionsKt.getASSERTIONS_ENABLED()) {
            if (!value$iv) {
                String message$iv = "This method is defined only for builtin members, but " + $receiver + " found";
                throw (Throwable)((Object)new AssertionError((Object)message$iv));
            }
            unit = Unit.INSTANCE;
        } else {
            unit = Unit.INSTANCE;
        }
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtilsKt.firstOverridden(DescriptorUtilsKt.getPropertyIfAccessor($receiver), getBuiltinSpecialPropertyGetterName.descriptor.1.INSTANCE);
        if (callableMemberDescriptor == null) {
            return null;
        }
        CallableMemberDescriptor descriptor2 = callableMemberDescriptor;
        Name name = PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP.get(DescriptorUtilsKt.getFqNameSafe(descriptor2));
        return name != null ? name.asString() : null;
    }

    /*
     * WARNING - void declaration
     */
    private BuiltinSpecialProperties() {
        void var3_3;
        void $receiver$iv$iv;
        INSTANCE = this;
        INSTANCE$ = this;
        PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP = MapsKt.mapOf(TuplesKt.to(new FqName("kotlin.Enum.name"), Name.identifier("name")), TuplesKt.to(new FqName("kotlin.Enum.ordinal"), Name.identifier("ordinal")), TuplesKt.to(new FqName("kotlin.Collection.size"), Name.identifier("size")), TuplesKt.to(new FqName("kotlin.Map.size"), Name.identifier("size")), TuplesKt.to(new FqName("kotlin.CharSequence.length"), Name.identifier("length")), TuplesKt.to(new FqName("kotlin.Map.keys"), Name.identifier("keySet")), TuplesKt.to(new FqName("kotlin.Map.values"), Name.identifier("values")), TuplesKt.to(new FqName("kotlin.Map.entries"), Name.identifier("entrySet")));
        GETTER_JVM_NAME_TO_PROPERTIES_SHORT_NAME_MAP = SpecialBuiltinMembers.access$getInversedShortNamesMap(PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP);
        Object $receiver$iv = PROPERTY_FQ_NAME_TO_JVM_GETTER_NAME_MAP;
        FQ_NAMES = $receiver$iv.keySet();
        $receiver$iv = FQ_NAMES;
        Object $i$f$keySet = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            FqName fqName2 = (FqName)item$iv$iv;
            Collection collection = destination$iv$iv;
            Name name = it.shortName();
            collection.add(name);
        }
        SHORT_NAMES = CollectionsKt.toSet((List)var3_3);
    }

    static {
        new BuiltinSpecialProperties();
    }
}

