/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModalityKt;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtil;
import org.jetbrains.kotlin.fileClasses.JvmFileClassUtilKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DeclarationChecker;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.jvm.diagnostics.ErrorsJvm;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={";\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u0003!\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001D\u0001\u0006\u0001\u0015\t\u00012B\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0003\u0011\rA\u0002A\r\u00021\u0003i\n1CQ\u0003#\u000e\t\u0001\"A\u0013\u0015\t-A\u0019!D\u0001\u0019\u0005e\u0019\u0001RA\u0007\u00021\rI2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u0005\u001b\u0005AR!G\u0002\t\f5\t\u0001DB\u0013\u000f\t\u0005Ai!d\u0002\u0019\u000fE\u001b\u0011\u0001b\u0004\u0016\u0003aA\u0011\u0014\u0002E\u0006\u001b\u0005Ab\u0001UB\u0001K\u0019!\u0011\u0001#\u0005\u000e\u0003a9Q#\u0001\r\tK\u0019!\u0011\u0001C\u0005\u000e\u0003a9Q#\u0001\r\t"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker;", "Lorg/jetbrains/kotlin/resolve/DeclarationChecker;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "hasBackingField", "", "Lorg/jetbrains/annotations/Nullable;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "hasCustomAccessor", "isInsideCompanionObjectOfInterface", "Problem"}, moduleName="kotlin-compiler")
public final class JvmFieldApplicabilityChecker
implements DeclarationChecker {
    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor2, @NotNull DiagnosticSink diagnosticHolder, @NotNull BindingContext bindingContext2) {
        Problem problem;
        Intrinsics.checkParameterIsNotNull(declaration, "declaration");
        Intrinsics.checkParameterIsNotNull(descriptor2, "descriptor");
        Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
        Intrinsics.checkParameterIsNotNull(bindingContext2, "bindingContext");
        AnnotationDescriptor annotationDescriptor = AnnotationUtilKt.findJvmFieldAnnotation(descriptor2);
        if (annotationDescriptor == null) {
            return;
        }
        AnnotationDescriptor annotation2 = annotationDescriptor;
        if (!(descriptor2 instanceof PropertyDescriptor)) {
            return;
        }
        if (!this.hasBackingField((PropertyDescriptor)descriptor2, bindingContext2)) {
            return;
        }
        if (ModalityKt.isOverridable((CallableMemberDescriptor)descriptor2)) {
            problem = Problem.NOT_FINAL;
        } else if (Visibilities.isPrivate(((PropertyDescriptor)descriptor2).getVisibility())) {
            problem = Problem.PRIVATE;
        } else if (this.hasCustomAccessor((PropertyDescriptor)descriptor2)) {
            problem = Problem.CUSTOM_ACCESSOR;
        } else if (CollectionsKt.isNotEmpty(((PropertyDescriptor)descriptor2).getOverriddenDescriptors())) {
            problem = Problem.OVERRIDES;
        } else if (((PropertyDescriptor)descriptor2).isLateInit()) {
            problem = Problem.LATEINIT;
        } else if (((PropertyDescriptor)descriptor2).isConst()) {
            problem = Problem.CONST;
        } else if (this.isInsideCompanionObjectOfInterface((PropertyDescriptor)descriptor2)) {
            problem = Problem.INSIDE_COMPANION_OF_INTERFACE;
        } else if (DescriptorUtils.isTopLevelDeclaration(descriptor2) && JvmFileClassUtilKt.isInsideJvmMultifileClassFile(declaration)) {
            problem = Problem.TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
        } else {
            return;
        }
        Problem problem2 = problem;
        KtAnnotationEntry ktAnnotationEntry = DescriptorToSourceUtils.getSourceFromAnnotation(annotation2);
        if (ktAnnotationEntry == null) {
            return;
        }
        KtAnnotationEntry annotationEntry = ktAnnotationEntry;
        diagnosticHolder.report(ErrorsJvm.INAPPLICABLE_JVM_FIELD.on((KtAnnotationEntry)((PsiElement)annotationEntry), problem2.getErrorMessage()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasCustomAccessor(PropertyDescriptor $receiver) {
        PropertyGetterDescriptor propertyGetterDescriptor = $receiver.getGetter();
        if (!(propertyGetterDescriptor != null ? propertyGetterDescriptor.isDefault() : true)) return true;
        PropertySetterDescriptor propertySetterDescriptor = $receiver.getSetter();
        if (propertySetterDescriptor == null) return false;
        boolean bl = propertySetterDescriptor.isDefault();
        if (bl) return false;
        return true;
    }

    private final boolean hasBackingField(PropertyDescriptor $receiver, BindingContext bindingContext2) {
        Boolean bl = (Boolean)bindingContext2.get(BindingContext.BACKING_FIELD_REQUIRED, $receiver);
        return bl != null ? bl : false;
    }

    private final boolean isInsideCompanionObjectOfInterface(PropertyDescriptor $receiver) {
        DeclarationDescriptor declarationDescriptor = $receiver.getContainingDeclaration();
        if (!(declarationDescriptor instanceof ClassDescriptor)) {
            declarationDescriptor = null;
        }
        ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
        if (classDescriptor == null) {
            return false;
        }
        ClassDescriptor containingClass = classDescriptor;
        if (!DescriptorUtils.isCompanionObject(containingClass)) {
            return false;
        }
        DeclarationDescriptor declarationDescriptor2 = containingClass.getContainingDeclaration();
        if (!(declarationDescriptor2 instanceof ClassDescriptor)) {
            declarationDescriptor2 = null;
        }
        ClassDescriptor classDescriptor2 = (ClassDescriptor)declarationDescriptor2;
        if (classDescriptor2 == null) {
            return false;
        }
        ClassDescriptor outerClassForObject = classDescriptor2;
        return DescriptorUtils.isInterface(outerClassForObject);
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0013\u0015\tA\"A\u0003\u0002\u0011!)\u0001!B\u0001\t\u000f\u0015\tA1\u0002\u0003A\u00021\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0002\u0001'\u0001\"\u0013\u0011\t\u0011\u0012\u0002\u0005\u0002\u001b\u0005A\u001a\u0001U\u0002\u0002#\u000e\t\u0001BA\u0015\u000b\t\rC\u0001\"A\u0007\u00021\u0007\t6\u0001B\u0003\u0001\u001b\t!)\u0001C\u00022\t\u000f!I!b\u0003\u0007\u000e\u001d)\u0014\u0001b\u00026\u0003\u0011!Q'\u0001C\u0005k\u0005!Q!N\u0001\u0005\fU\nAAB\u001b\u0002\t\u001b)\u0014\u0001B\u0004"}, strings={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/JvmFieldApplicabilityChecker$Problem;", "", "errorMessage", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getErrorMessage", "()Ljava/lang/String;", "NOT_FINAL", "PRIVATE", "CUSTOM_ACCESSOR", "OVERRIDES", "LATEINIT", "CONST", "INSIDE_COMPANION_OF_INTERFACE", "TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE"}, moduleName="kotlin-compiler")
    public static final class Problem
    extends Enum<Problem> {
        public static final /* enum */ Problem NOT_FINAL;
        public static final /* enum */ Problem PRIVATE;
        public static final /* enum */ Problem CUSTOM_ACCESSOR;
        public static final /* enum */ Problem OVERRIDES;
        public static final /* enum */ Problem LATEINIT;
        public static final /* enum */ Problem CONST;
        public static final /* enum */ Problem INSIDE_COMPANION_OF_INTERFACE;
        public static final /* enum */ Problem TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE;
        private static final /* synthetic */ Problem[] $VALUES;
        @NotNull
        private final String errorMessage;

        static {
            Problem[] problemArray = new Problem[8];
            Problem[] problemArray2 = problemArray;
            problemArray[0] = NOT_FINAL = new Problem("JvmField can only be applied to final property");
            problemArray[1] = PRIVATE = new Problem("JvmField has no effect on a private property");
            problemArray[2] = CUSTOM_ACCESSOR = new Problem("JvmField cannot be applied to a property with a custom accessor");
            problemArray[3] = OVERRIDES = new Problem("JvmField cannot be applied to a property that overrides some other property");
            problemArray[4] = LATEINIT = new Problem("JvmField cannot be applied to lateinit property");
            problemArray[5] = CONST = new Problem("JvmField cannot be applied to const property");
            problemArray[6] = INSIDE_COMPANION_OF_INTERFACE = new Problem("JvmField cannot be applied to a property defined in companion object of interface");
            problemArray[7] = TOP_LEVEL_PROPERTY_OF_MULTIFILE_FACADE = new Problem("JvmField cannot be applied to top level property of a file annotated with " + JvmFileClassUtil.INSTANCE.getJVM_MULTIFILE_CLASS_SHORT());
            $VALUES = problemArray;
        }

        @NotNull
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        protected Problem(@NotNull String errorMessage) {
            Intrinsics.checkParameterIsNotNull(errorMessage, "errorMessage");
            this.errorMessage = errorMessage;
        }

        public static Problem[] values() {
            return (Problem[])$VALUES.clone();
        }

        public static Problem valueOf(String string) {
            return Enum.valueOf(Problem.class, string);
        }
    }
}

