/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"!\u0015\tA\"A\u0003\u0002\u0011!)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0006\u000b\u0005!\u0011!B\u0001\t\t\u0015\tAq\u0002\u0003D\u00021\u0001\u0011\u0004B\u0005\u0003\u0013\u0005A\u0002\u0001'\u0001\"4\u0011\t\u0011\u0012\u0002\u0005\u0002\u001b\u0005A\u001a\u0001U\u0002\u0002\u0013\u0013A!!D\u0001\u0019\u0006A\u001b\u0019!#\u0003\t\u00075\t\u0001T\u0001)\u0004\u0005%%\u0001rA\u0007\u00021\u0011\u00016QA)\u0004\u0003!%Qe\u0002E\b\u001b\u0005A*!G\u0002\t\u00115\t\u0001\u0004A\u0013\u0004\u0011#i\u0011\u0001\u0007\u0001&\u000f!IQ\"\u0001\r\u00013\rA\u0019\"D\u0001\u0019\u0001\u0015\"Aa\u0003\u0005\u000b\u001b\u0005A\u001a!\u000b\u0006\u0005\u0007\"A!!D\u0001\u0019\u0006E\u001bA!\u0002\u0001\u000e\u0005\u0011)\u00012B\u0015\u000b\t\rC\u0001bA\u0007\u00021\u000b\t6\u0001B\u0003\u0001\u001b\t!a\u0001c\u0003*\u0015\u0011\u0019\u0005\u0002C\u0001\u000e\u0003a\r\u0011k\u0001\u0003\u0006\u00015\u0011AQ\u0002\u0005\bS\u001d!\u0011\t\u0003E\u0004\u001b\u0005AB!U\u0002\u0002\u000b\u0001\t\u001cQCF\fk\u0005!)\"N\u0001\u0005\u0017U\nAq\u0003"}, strings={"Lorg/jetbrains/kotlin/types/Variance;", "", "label", "", "allowsInPosition", "", "allowsOutPosition", "superpositionFactor", "", "(Ljava/lang/String;ILjava/lang/String;ZZI)V", "getAllowsInPosition", "()Z", "getAllowsOutPosition", "getLabel", "()Ljava/lang/String;", "allowsPosition", "position", "opposite", "superpose", "other", "toString", "INVARIANT", "IN_VARIANCE", "OUT_VARIANCE"}, moduleName="kotlin-compiler")
public final class Variance
extends Enum<Variance> {
    public static final /* enum */ Variance INVARIANT;
    public static final /* enum */ Variance IN_VARIANCE;
    public static final /* enum */ Variance OUT_VARIANCE;
    private static final /* synthetic */ Variance[] $VALUES;
    @NotNull
    private final String label;
    private final boolean allowsInPosition;
    private final boolean allowsOutPosition;
    private final int superpositionFactor;

    static {
        Variance[] varianceArray = new Variance[3];
        Variance[] varianceArray2 = varianceArray;
        varianceArray[0] = INVARIANT = new Variance("", true, true, 0);
        varianceArray[1] = IN_VARIANCE = new Variance("in", true, false, -1);
        varianceArray[2] = OUT_VARIANCE = new Variance("out", false, true, 1);
        $VALUES = varianceArray;
    }

    public final boolean allowsPosition(@NotNull Variance position) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)position, "position");
        Variance variance = position;
        if (Intrinsics.areEqual((Object)variance, (Object)IN_VARIANCE)) {
            bl = this.allowsInPosition;
        } else if (Intrinsics.areEqual((Object)variance, (Object)OUT_VARIANCE)) {
            bl = this.allowsOutPosition;
        } else if (Intrinsics.areEqual((Object)variance, (Object)INVARIANT)) {
            bl = this.allowsInPosition && this.allowsOutPosition;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @NotNull
    public final Variance superpose(@NotNull Variance other) {
        Variance variance;
        Intrinsics.checkParameterIsNotNull((Object)other, "other");
        int r = this.superpositionFactor * other.superpositionFactor;
        switch (r) {
            case 0: {
                variance = INVARIANT;
                break;
            }
            case -1: {
                variance = IN_VARIANCE;
                break;
            }
            case 1: {
                variance = OUT_VARIANCE;
                break;
            }
            default: {
                throw (Throwable)new IllegalStateException("Illegal factor: " + r);
            }
        }
        return variance;
    }

    @NotNull
    public final Variance opposite() {
        Variance variance;
        Variance variance2 = this;
        if (Intrinsics.areEqual((Object)variance2, (Object)INVARIANT)) {
            variance = INVARIANT;
        } else if (Intrinsics.areEqual((Object)variance2, (Object)IN_VARIANCE)) {
            variance = OUT_VARIANCE;
        } else if (Intrinsics.areEqual((Object)variance2, (Object)OUT_VARIANCE)) {
            variance = IN_VARIANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return variance;
    }

    @NotNull
    public String toString() {
        return this.label;
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final boolean getAllowsInPosition() {
        return this.allowsInPosition;
    }

    public final boolean getAllowsOutPosition() {
        return this.allowsOutPosition;
    }

    protected Variance(@NotNull String label, boolean allowsInPosition, boolean allowsOutPosition, int superpositionFactor) {
        Intrinsics.checkParameterIsNotNull(label, "label");
        this.label = label;
        this.allowsInPosition = allowsInPosition;
        this.allowsOutPosition = allowsOutPosition;
        this.superpositionFactor = superpositionFactor;
    }

    public static Variance[] values() {
        return (Variance[])$VALUES.clone();
    }

    public static Variance valueOf(String string) {
        return Enum.valueOf(Variance.class, string);
    }
}

