/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.types.expressions;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.TokenSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.PreconditionsKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.SimpleFunctionDescriptorImpl;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.DiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DeclarationsCheckerKt;
import org.jetbrains.kotlin.resolve.FunctionDescriptorResolver;
import org.jetbrains.kotlin.resolve.FunctionDescriptorUtil;
import org.jetbrains.kotlin.resolve.IdentifierChecker;
import org.jetbrains.kotlin.resolve.UnderscoreChecker;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowInfo;
import org.jetbrains.kotlin.resolve.lazy.ForceResolveUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalWritableScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.CommonSupertypes;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.expressions.CoercionStrategy;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingContext;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingInternals;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingServices;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.kotlin.types.expressions.KotlinTypeInfo;
import org.jetbrains.kotlin.types.expressions.ValueParameterResolver;
import org.jetbrains.kotlin.types.expressions.typeInfoFactory.TypeInfoFactoryKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"s\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0011\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\b\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\u0001Q!\u0001\u0007\u0002\u000b\u0005a\u0011!\u0002\u0001\u0006\u00031\tQ\u0001A\u0003\u0002\u0011\u0017)\u0011\u0001\"\u0002\u0006\u00031\tQ\u0001A\u0003\u0002\u0019\u0005)\u0001!B\u0001\r\u0003\u0015\tA!A\u0003\u0002\u0019\u0005)\u0011\u0001b\u0001\u0006\u00031\tA\u0001\u0001\u0007\u00013\u0005A\n!)\u0004\n\u0007!\tQ\"\u0001M\u0002#\u000e\t\u0001BA\u0013\r\t\u0005A)!D\u0001\u0019\u0007e\u0019\u0001rA\u0007\u00021\u0011I2\u0001#\u0003\u000e\u0003a)Qe\u0004\u0003\u0002\u0011\u0017iA!\u0003\u0002\n\u0003a5\u0001DB\r\u0004\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!AQ\"\u0001M\tKQ!\u0011\u0001C\u0005\u000e\u0003aM\u0011d\u0001E\u0005\u001b\u0005A\"\"G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011+i\u0011\u0001G\u0006\u001a\u0007!]Q\"\u0001\r\rKI!\u0011\u0001#\u0007\u000e\u00051\u0005\u00014C\r\u0004\u0011\u001di\u0011\u0001g\u0004\u001a\u0007!\u001dQ\"\u0001\r\u00053\u0011AQ\"\u0004\u0002\r\u0002aMQE\u0006\u0003\u0002\u00117i!\u0001$\u0001\u0019\u0014e\u0019\u0001\u0012B\u0007\u00021)I2\u0001c\u0002\u000e\u0003a!\u0011d\u0001E\u000b\u001b\u0005A2\"\u0007\u0003\t\u001d5\u0011A\u0012\u0001M\nK1!\u0011\u0001#\b\u000e\u0003ay\u0011d\u0001E\u0005\u001b\u0005A\"\"G\u0002\t\b5\t\u0001\u0004B\u0013\n\t\u0005Ay\"\u0004\u0002\r\u0002aM\u0011d\u0001E\u000b\u001b\u0005A\u0002#J\u0007\u0005\u0017!\u0005RB\u0001G\u00011EI2\u0001#\u0003\u000e\u0003aQ\u0011d\u0001E\u0004\u001b\u0005AB!\n\u0007\u0005\u0017!\rR\"\u0001\r\u00123\rA!#D\u0001\u0019&e\u0019\u0001bE\u0007\u00021\u0011)C\u0003c\t\u000e\u0003a\t\u0012d\u0001\u0005\u0013\u001b\u0005A*#G\u0002\t\b5\t\u0001\u0004B\r\u0004\u0011Oi\u0011\u0001\u0007\u0007\u001a\t!!RB\u0001G\u00011S\u0001"}, strings={"Lorg/jetbrains/kotlin/types/expressions/FunctionsTypingVisitor;", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingVisitor;", "facade", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;", "(Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingInternals;)V", "checkReservedAsync", "", "context", "Lorg/jetbrains/kotlin/types/expressions/ExpressionTypingContext;", "expression", "Lcom/intellij/psi/PsiElement;", "collectReturns", "", "Lorg/jetbrains/kotlin/psi/KtReturnExpression;", "functionLiteral", "Lorg/jetbrains/kotlin/psi/KtFunctionLiteral;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "computeReturnType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/SimpleFunctionDescriptorImpl;", "functionTypeExpected", "", "computeReturnTypeBasedOnReturnExpressions", "typeOfBodyExpression", "computeUnsafeReturnType", "expectedReturnType", "createFunctionLiteralDescriptor", "Lorg/jetbrains/kotlin/descriptors/impl/AnonymousFunctionDescriptor;", "createFunctionType", "Lorg/jetbrains/kotlin/descriptors/SimpleFunctionDescriptor;", "visitLambdaExpression", "Lorg/jetbrains/kotlin/types/expressions/KotlinTypeInfo;", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "data", "isStatement", "statementScope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalWritableScope;"}, moduleName="kotlin-compiler")
public final class FunctionsTypingVisitor
extends ExpressionTypingVisitor {
    @Override
    @NotNull
    public KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function, @NotNull ExpressionTypingContext data) {
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(data, "data");
        return this.visitNamedFunction(function, data, false, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final KotlinTypeInfo visitNamedFunction(@NotNull KtNamedFunction function, @NotNull ExpressionTypingContext context, boolean isStatement, @Nullable LexicalWritableScope statementScope) {
        void $receiver$iv;
        SimpleFunctionDescriptor functionDescriptor;
        Intrinsics.checkParameterIsNotNull(function, "function");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.checkReservedAsync(context, function);
        if (!isStatement) {
            if (!function.getTypeParameters().isEmpty()) {
                context.trace.report(Errors.TYPE_PARAMETERS_NOT_ALLOWED.on((KtDeclaration)((PsiElement)function)));
            }
            if (function.getName() != null) {
                context.trace.report(Errors.ANONYMOUS_FUNCTION_WITH_NAME.on(function.getNameIdentifier()));
            }
            for (KtParameter parameter : function.getValueParameters()) {
                if (parameter.hasDefaultValue()) {
                    context.trace.report(Errors.ANONYMOUS_FUNCTION_PARAMETER_WITH_DEFAULT_VALUE.on((KtParameter)((PsiElement)parameter)));
                }
                if (!parameter.isVarArg()) continue;
                context.trace.report(Errors.USELESS_VARARG_ON_PARAMETER.on((KtParameter)((PsiElement)parameter)));
            }
        }
        if (isStatement) {
            Unit unit;
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            functionDescriptor = functionDescriptorResolver.resolveFunctionDescriptor(declarationDescriptor, lexicalScope, function, bindingTrace, dataFlowInfo);
            boolean bl = statementScope != null;
            if (PreconditionsKt.getASSERTIONS_ENABLED()) {
                void value$iv;
                if (value$iv == false) {
                    String message$iv = "statementScope must be not null for function: " + function.getName() + " at location " + DiagnosticUtils.atLocation(function);
                    throw (Throwable)((Object)new AssertionError((Object)message$iv));
                }
                unit = Unit.INSTANCE;
            } else {
                unit = Unit.INSTANCE;
            }
            LexicalWritableScope lexicalWritableScope = statementScope;
            if (lexicalWritableScope == null) {
                Intrinsics.throwNpe();
            }
            lexicalWritableScope.addFunctionDescriptor(functionDescriptor);
        } else {
            FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
            DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
            LexicalScope lexicalScope = context.scope;
            Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
            BindingTrace bindingTrace = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
            DataFlowInfo dataFlowInfo = context.dataFlowInfo;
            Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
            KotlinType kotlinType = context.expectedType;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
            functionDescriptor = functionDescriptorResolver.resolveFunctionExpressionDescriptor(declarationDescriptor, lexicalScope, function, bindingTrace, dataFlowInfo, kotlinType);
        }
        ForceResolveUtil.forceResolveAllContents(functionDescriptor.getAnnotations());
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, (FunctionDescriptor)functionDescriptor, context.trace);
        this.components.expressionTypingServices.checkFunctionReturnType(functionInnerScope, function, functionDescriptor, context.dataFlowInfo, null, context.trace);
        ValueParameterResolver valueParameterResolver = this.components.valueParameterResolver;
        List<KtParameter> list = function.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list, "function.getValueParameters()");
        List<ValueParameterDescriptor> list2 = functionDescriptor.getValueParameters();
        Intrinsics.checkExpressionValueIsNotNull(list2, "functionDescriptor.getValueParameters()");
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        DataFlowInfo dataFlowInfo = context.dataFlowInfo;
        Intrinsics.checkExpressionValueIsNotNull(dataFlowInfo, "context.dataFlowInfo");
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        valueParameterResolver.resolveValueParameters(list, list2, lexicalScope, dataFlowInfo, bindingTrace);
        KtDeclaration ktDeclaration = function;
        BindingTrace bindingTrace2 = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace2, "context.trace");
        DeclarationsCheckerKt.checkTypeReferences(ktDeclaration, bindingTrace2);
        this.components.modifiersChecker.withTrace(context.trace).checkModifiersForLocalDeclaration(function, functionDescriptor);
        IdentifierChecker identifierChecker = this.components.identifierChecker;
        KtDeclaration ktDeclaration2 = function;
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
        identifierChecker.checkDeclaration(ktDeclaration2, diagnosticSink);
        if (!function.hasBody() && !function.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
            context.trace.report(Errors.NON_MEMBER_FUNCTION_NO_BODY.on((KtFunction)((PsiElement)function), functionDescriptor));
        }
        Iterable $i$a$1 = functionDescriptor.getValueParameters();
        int count$iv = 0;
        for (Object element$iv : $receiver$iv) {
            ValueParameterDescriptor it = (ValueParameterDescriptor)element$iv;
            if (!(it.getVarargElementType() != null)) continue;
            ++count$iv;
        }
        if (count$iv > 1) {
            context.trace.report(Errors.MULTIPLE_VARARG_PARAMETERS.on((KtDeclaration)((PsiElement)function)));
        }
        if (isStatement) {
            return TypeInfoFactoryKt.createTypeInfo(this.components.dataFlowAnalyzer.checkStatementType(function, context), context);
        }
        KotlinTypeInfo kotlinTypeInfo = this.components.dataFlowAnalyzer.createCheckedTypeInfo(this.createFunctionType(functionDescriptor), context, function);
        Intrinsics.checkExpressionValueIsNotNull(kotlinTypeInfo, "components.dataFlowAnaly\u2026ptor), context, function)");
        return kotlinTypeInfo;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinType createFunctionType(SimpleFunctionDescriptor functionDescriptor) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        ReceiverParameterDescriptor receiverParameterDescriptor = functionDescriptor.getExtensionReceiverParameter();
        KotlinType receiverType = receiverParameterDescriptor != null ? receiverParameterDescriptor.getType() : null;
        KotlinType returnType2 = functionDescriptor.getReturnType();
        if (returnType2 == null) {
            return null;
        }
        Iterable iterable = functionDescriptor.getValueParameters();
        void var6_5 = $receiver$iv;
        Collection collection = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            ValueParameterDescriptor valueParameterDescriptor = (ValueParameterDescriptor)item$iv$iv;
            void var14_10 = destination$iv$iv;
            KotlinType kotlinType = it.getType();
            var14_10.add(kotlinType);
        }
        List parameters2 = (List)destination$iv$iv;
        return this.components.builtIns.getFunctionType(Annotations.Companion.getEMPTY(), receiverType, parameters2, returnType2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KotlinTypeInfo visitLambdaExpression(@NotNull KtLambdaExpression expression, @NotNull ExpressionTypingContext context) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull(expression, "expression");
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.checkReservedAsync(context, expression);
        if (!expression.getFunctionLiteral().hasBody()) {
            return null;
        }
        KotlinType expectedType = context.expectedType;
        boolean functionTypeExpected = !TypeUtils.noExpectedType(expectedType) && KotlinBuiltIns.isFunctionOrExtensionFunctionType(expectedType);
        AnonymousFunctionDescriptor functionDescriptor = this.createFunctionLiteralDescriptor(expression, context);
        Iterable iterable = expression.getValueParameters();
        for (Object element$iv : $receiver$iv) {
            KtParameter it = (KtParameter)element$iv;
            IdentifierChecker identifierChecker = this.components.identifierChecker;
            KtDeclaration ktDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull(ktDeclaration, "it");
            DiagnosticSink diagnosticSink = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
            identifierChecker.checkDeclaration(ktDeclaration, diagnosticSink);
            KtNamedDeclaration ktNamedDeclaration = it;
            Intrinsics.checkExpressionValueIsNotNull(ktNamedDeclaration, "it");
            DiagnosticSink diagnosticSink2 = context.trace;
            Intrinsics.checkExpressionValueIsNotNull(diagnosticSink2, "context.trace");
            UnderscoreChecker.INSTANCE.checkNamed(ktNamedDeclaration, diagnosticSink2);
        }
        KotlinType safeReturnType = this.computeReturnType(expression, context, functionDescriptor, functionTypeExpected);
        functionDescriptor.setReturnType(safeReturnType);
        KotlinType kotlinType = this.createFunctionType(functionDescriptor);
        if (kotlinType == null) {
            Intrinsics.throwNpe();
        }
        KotlinType resultType = kotlinType;
        if (functionTypeExpected) {
            return TypeInfoFactoryKt.createTypeInfo(resultType, context);
        }
        return this.components.dataFlowAnalyzer.createCheckedTypeInfo(resultType, context, expression);
    }

    private final void checkReservedAsync(ExpressionTypingContext context, PsiElement expression) {
        DiagnosticSink diagnosticSink = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(diagnosticSink, "context.trace");
        TokenSet tokenSet = KtTokens.BINARY_OPERATIONS;
        Intrinsics.checkExpressionValueIsNotNull(tokenSet, "KtTokens.BINARY_OPERATIONS");
        KtPsiUtilKt.checkReservedPrefixWord(diagnosticSink, expression, "async", tokenSet, "async block/lambda. Use 'async() { ... }' or 'async(fun...)'");
    }

    private final AnonymousFunctionDescriptor createFunctionLiteralDescriptor(KtLambdaExpression expression, ExpressionTypingContext context) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        AnonymousFunctionDescriptor functionDescriptor = new AnonymousFunctionDescriptor(context.scope.getOwnerDescriptor(), this.components.annotationResolver.resolveAnnotationsWithArguments(context.scope, KtPsiUtilKt.getAnnotationEntries(expression), context.trace), CallableMemberDescriptor.Kind.DECLARATION, KotlinSourceElementKt.toSourceElement(functionLiteral));
        FunctionDescriptorResolver functionDescriptorResolver = this.components.functionDescriptorResolver;
        DeclarationDescriptor declarationDescriptor = context.scope.getOwnerDescriptor();
        LexicalScope lexicalScope = context.scope;
        Intrinsics.checkExpressionValueIsNotNull(lexicalScope, "context.scope");
        KtFunction ktFunction = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunction, "functionLiteral");
        SimpleFunctionDescriptorImpl simpleFunctionDescriptorImpl = functionDescriptor;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        KotlinType kotlinType = context.expectedType;
        Intrinsics.checkExpressionValueIsNotNull(kotlinType, "context.expectedType");
        functionDescriptorResolver.initializeFunctionDescriptorAndExplicitReturnType(declarationDescriptor, lexicalScope, ktFunction, simpleFunctionDescriptorImpl, bindingTrace, kotlinType);
        for (ValueParameterDescriptor parameterDescriptor : functionDescriptor.getValueParameters()) {
            ForceResolveUtil.forceResolveAllContents(parameterDescriptor.getAnnotations());
        }
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, functionLiteral, functionDescriptor);
        return functionDescriptor;
    }

    private final KotlinType computeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        KotlinType kotlinType;
        KotlinType expectedReturnType = functionTypeExpected ? KotlinBuiltIns.getReturnTypeFromFunctionType(context.expectedType) : (KotlinType)null;
        KotlinType returnType2 = this.computeUnsafeReturnType(expression, context, functionDescriptor, expectedReturnType);
        if (!expression.getFunctionLiteral().hasDeclaredReturnType() && functionTypeExpected) {
            KotlinType kotlinType2 = expectedReturnType;
            if (kotlinType2 == null) {
                Intrinsics.throwNpe();
            }
            if (!TypeUtils.noExpectedType(kotlinType2) && KotlinBuiltIns.isUnit(expectedReturnType)) {
                KotlinType kotlinType3 = this.components.builtIns.getUnitType();
                Intrinsics.checkExpressionValueIsNotNull(kotlinType3, "components.builtIns.getUnitType()");
                return kotlinType3;
            }
        }
        if ((kotlinType = returnType2) == null) {
            KotlinType kotlinType4 = TypeUtils.CANT_INFER_FUNCTION_PARAM_TYPE;
            kotlinType = kotlinType4;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType4, "CANT_INFER_FUNCTION_PARAM_TYPE");
        }
        return kotlinType;
    }

    private final KotlinType computeUnsafeReturnType(KtLambdaExpression expression, ExpressionTypingContext context, SimpleFunctionDescriptorImpl functionDescriptor, KotlinType expectedReturnType) {
        KtFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        KotlinType kotlinType = expectedReturnType;
        if (kotlinType == null) {
            KotlinType kotlinType2 = TypeUtils.NO_EXPECTED_TYPE;
            kotlinType = kotlinType2;
            Intrinsics.checkExpressionValueIsNotNull(kotlinType2, "NO_EXPECTED_TYPE");
        }
        KotlinType expectedType = kotlinType;
        LexicalScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, (FunctionDescriptor)functionDescriptor, context.trace);
        ExpressionTypingContext newContext = (ExpressionTypingContext)((ExpressionTypingContext)context.replaceScope(functionInnerScope)).replaceExpectedType(expectedType);
        context.trace.record(BindingContext.EXPECTED_RETURN_TYPE, functionLiteral, expectedType);
        ExpressionTypingServices expressionTypingServices = this.components.expressionTypingServices;
        KtBlockExpression ktBlockExpression = functionLiteral.getBodyExpression();
        if (ktBlockExpression == null) {
            Intrinsics.throwNpe();
        }
        KotlinType typeOfBodyExpression = expressionTypingServices.getBlockReturnedType(ktBlockExpression, CoercionStrategy.COERCION_TO_UNIT, newContext).getType();
        KtFunctionLiteral ktFunctionLiteral = functionLiteral;
        Intrinsics.checkExpressionValueIsNotNull(ktFunctionLiteral, "functionLiteral");
        return this.computeReturnTypeBasedOnReturnExpressions(ktFunctionLiteral, context, typeOfBodyExpression);
    }

    private final KotlinType computeReturnTypeBasedOnReturnExpressions(KtFunctionLiteral functionLiteral, ExpressionTypingContext context, KotlinType typeOfBodyExpression) {
        KtExpression returnedExpression;
        ArrayList returnedExpressionTypes = Lists.newArrayList();
        boolean hasEmptyReturn = false;
        BindingTrace bindingTrace = context.trace;
        Intrinsics.checkExpressionValueIsNotNull(bindingTrace, "context.trace");
        Collection<KtReturnExpression> returnExpressions = this.collectReturns(functionLiteral, bindingTrace);
        for (KtReturnExpression returnExpression : returnExpressions) {
            returnedExpression = returnExpression.getReturnedExpression();
            if (returnedExpression == null) {
                hasEmptyReturn = true;
                continue;
            }
            CollectionsKt.addIfNotNull(returnedExpressionTypes, context.trace.getType(returnedExpression));
        }
        if (hasEmptyReturn) {
            for (KtReturnExpression returnExpression : returnExpressions) {
                KotlinType type2;
                returnedExpression = returnExpression.getReturnedExpression();
                if (returnedExpression == null || (type2 = context.trace.getType(returnedExpression)) != null && KotlinBuiltIns.isUnit(type2)) continue;
                context.trace.report(Errors.RETURN_TYPE_MISMATCH.on((KtExpression)((PsiElement)returnedExpression), this.components.builtIns.getUnitType()));
            }
            return this.components.builtIns.getUnitType();
        }
        CollectionsKt.addIfNotNull(returnedExpressionTypes, typeOfBodyExpression);
        if (returnedExpressionTypes.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(returnedExpressionTypes);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<KtReturnExpression> collectReturns(KtFunctionLiteral functionLiteral, BindingTrace trace) {
        void destination$iv$iv;
        void $receiver$iv$iv;
        void $receiver$iv;
        KtBlockExpression bodyExpression;
        ArrayList result2 = Lists.newArrayList();
        KtBlockExpression ktBlockExpression = bodyExpression = functionLiteral.getBodyExpression();
        Void void_ = ktBlockExpression != null ? (Void)ktBlockExpression.accept((KtVisitor)new KtTreeVisitor<List<KtReturnExpression>>(){

            @Nullable
            public Void visitReturnExpression(@NotNull KtReturnExpression expression, @NotNull List<KtReturnExpression> data) {
                Intrinsics.checkParameterIsNotNull(expression, "expression");
                Intrinsics.checkParameterIsNotNull(data, "data");
                data.add(expression);
                return null;
            }
        }, result2) : null;
        Iterable iterable = result2;
        void var6_6 = $receiver$iv;
        Collection collection = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            PsiElement psiElement2;
            KtReturnExpression it = (KtReturnExpression)element$iv$iv;
            if (it.getTargetLabel() != null) {
                void $receiver$iv2;
                KtSimpleNameExpression it2 = (KtSimpleNameExpression)$receiver$iv2;
                psiElement2 = (PsiElement)trace.get(BindingContext.LABEL_TARGET, it2);
            } else {
                psiElement2 = null;
            }
            if (!Intrinsics.areEqual(psiElement2, functionLiteral)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public FunctionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        Intrinsics.checkParameterIsNotNull(facade, "facade");
        super(facade);
    }
}

