/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.daemon.client;

import com.intellij.openapi.progress.ProcessCanceledException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Collection;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.daemon.common.CompilerCallbackServicesFacade;
import org.jetbrains.kotlin.daemon.common.LoopbackNetworkInterface;
import org.jetbrains.kotlin.daemon.common.NetworkUtilsKt;
import org.jetbrains.kotlin.daemon.common.RmiFriendlyCompilationCancelledException;
import org.jetbrains.kotlin.incremental.components.LookupInfo;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.load.kotlin.incremental.components.JvmPackagePartProto;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"]\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001D\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!!Q!\u0001\u0003\u0004\u000b\u0005AY!\u0002\u0001\u0006\u0003!\tQ!\u0001C\u0003\u000b\u0005a\u0011!\u0002\u0001\u0006\u0003!9Q!\u0001\u0003\u0002\u000b\u0005A\u0011\"B\u0001\u0005\u0004\u0015\t\u0001bD\u0003\u0002\t\t)\u0011\u0001D\u0001\u0006\u0003\u0011\u001dQ!\u0001\u0007\u0002\u000b\u0001a\u0001!G\u0001\u0019\u0002e\t\u0001$AQ\u0014\u0013\u0015!\u0011\u0001c\u0001\u000e\u00051\u0005\u0001DA\u0005\u0006\t\u0005A)!\u0004\u0002\r\u0002a\u0019\u0011\u0002\u0002\u0003\u0002\u0011\u000fi\u0011\u0001\u0007\u0003R\u0007\u0005AI!\n\u0003\u0005\u0017!AQ\"\u0001M\tK\u0011!1\u0002C\u0005\u000e\u0003a=Q\u0005\u0002\u0003\f\u0011'i\u0011\u0001g\u0004&\t\u0011Y\u0001BC\u0007\u00021\u001f)\u0003\u0002B\u0006\t\u00165\t\u0001\u0014C\r\u0004\u0011-i\u0011\u0001g\u0006&\u0019\u0011Y\u0001\u0002D\u0007\u000213I2\u0001C\u0006\u000e\u0003a]\u0011d\u0001\u0005\u000e\u001b\u0005AJ\"J\u0005\u0005\u0017!mQB\u0001G\u000119I2\u0001C\u0006\u000e\u0003a]Q%\u0004\u0003\f\u0011;i!\u0001$\u0001\u0019\u001ae\u0019\u0001bC\u0007\u00021/I2\u0001C\b\u000e\u0003aeQ\u0005\u0005\u0003\f\u0011?iQ!\u0003\u0002\n\u0003aeA\u0012\u0001\r\u00113\rA1\"D\u0001\u0019\u0018e\u0019\u0001\u0012E\u0007\u000213)3\u0002B\u0006\t#5!\u0011BA\u0005\u000213A\u0002#G\u0002\t\u00175\t\u0001tC\u0013\f\t-A\u0019#\u0004\u0003\n\u0005%\t\u0001\u0014\u0004\r\u00113\rA1\"D\u0001\u0019\u0018\u0015jAa\u0003\u0005\u0013\u001b\ta\t\u0001'\n\u001a\u0007!YQ\"\u0001M\f3\rA1#D\u0001\u0019\u001a\u0015\"Ba\u0003E\u0014\u001b\u0005A\n\"G\u0002\t\u00175\t\u0001tC\r\u0004\u0011Qi\u0011\u0001'\u0007\u001a\u0007!%R\"\u0001M\r3\rAQ#D\u0001\u0019\u001a\u0015\"Aa\u0003\u0005\b\u001b\u0005Az!J\u0006\u0005\u0017!-R\"\u0001M\t3\u0019Aa#\u0004\u0003\n\u0005%\t\u0001T\u0006\r\u0011K\u0011!1\u0002C\f\u000e\u0003a=\u0011f\u0003\u0003D\u0011!\u0015QB\u0001G\u00011\r\t6\u0001B\u0003\u0001\u001b\t!Q\u0001c\u0003*\u0017\u0011\u0019\u0005\u0002c\u0001\u000e\u00051\u0005\u0001DA)\u0004\t\u0015\u0001QB\u0001\u0003\u0007\u0011\u001bIs\u0001B!\t\u0011\u001di\u0011\u0001g\u0004R\u0007\u0005)\u0001\u0001"}, strings={"Lorg/jetbrains/kotlin/daemon/client/CompilerCallbackServicesFacadeServer;", "Lorg/jetbrains/kotlin/daemon/common/CompilerCallbackServicesFacade;", "Ljava/rmi/server/UnicastRemoteObject;", "incrementalCompilationComponents", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCompilationComponents;", "compilationCancelledStatus", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "port", "", "(Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCompilationComponents;Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;I)V", "getCompilationCancelledStatus", "()Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "getIncrementalCompilationComponents", "()Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCompilationComponents;", "lookupTracker_isDoNothing", "", "compilationCanceledStatus_checkCanceled", "", "hasCompilationCanceledStatus", "hasIncrementalCaches", "hasLookupTracker", "incrementalCache_close", "target", "Lorg/jetbrains/kotlin/modules/TargetId;", "incrementalCache_getClassFilePath", "", "internalClassName", "incrementalCache_getModuleMappingData", "", "incrementalCache_getMultifileFacade", "partInternalName", "incrementalCache_getMultifileFacadeParts", "", "internalName", "incrementalCache_getObsoleteMultifileClassFacades", "incrementalCache_getObsoletePackageParts", "incrementalCache_getPackagePartData", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/JvmPackagePartProto;", "fqName", "incrementalCache_registerInline", "fromPath", "jvmSignature", "toPath", "lookupTracker_record", "lookups", "Lorg/jetbrains/kotlin/incremental/components/LookupInfo;", "lookupTracker_requiresPosition"}, moduleName="client")
public final class CompilerCallbackServicesFacadeServer
extends UnicastRemoteObject
implements CompilerCallbackServicesFacade {
    private final boolean lookupTracker_isDoNothing;
    @Nullable
    private final IncrementalCompilationComponents incrementalCompilationComponents;
    @Nullable
    private final CompilationCanceledStatus compilationCancelledStatus;

    public boolean hasIncrementalCaches() {
        return this.incrementalCompilationComponents != null;
    }

    public boolean hasLookupTracker() {
        return this.incrementalCompilationComponents != null;
    }

    public boolean hasCompilationCanceledStatus() {
        return this.compilationCancelledStatus != null;
    }

    @NotNull
    public Collection<String> incrementalCache_getObsoletePackageParts(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getObsoletePackageParts();
    }

    @NotNull
    public Collection<String> incrementalCache_getObsoleteMultifileClassFacades(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getObsoleteMultifileClasses();
    }

    @Nullable
    public Collection<String> incrementalCache_getMultifileFacadeParts(@NotNull TargetId target, @NotNull String internalName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)internalName, (String)"internalName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getStableMultifileFacadeParts(internalName);
    }

    @Nullable
    public String incrementalCache_getMultifileFacade(@NotNull TargetId target, @NotNull String partInternalName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)partInternalName, (String)"partInternalName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getMultifileFacade(partInternalName);
    }

    @Nullable
    public JvmPackagePartProto incrementalCache_getPackagePartData(@NotNull TargetId target, @NotNull String fqName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)fqName, (String)"fqName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getPackagePartData(fqName);
    }

    @Nullable
    public byte[] incrementalCache_getModuleMappingData(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getModuleMappingData();
    }

    public void incrementalCache_registerInline(@NotNull TargetId target, @NotNull String fromPath, @NotNull String jvmSignature, @NotNull String toPath) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)fromPath, (String)"fromPath");
        Intrinsics.checkParameterIsNotNull((Object)jvmSignature, (String)"jvmSignature");
        Intrinsics.checkParameterIsNotNull((Object)toPath, (String)"toPath");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        incrementalCompilationComponents.getIncrementalCache(target).registerInline(fromPath, jvmSignature, toPath);
    }

    @NotNull
    public String incrementalCache_getClassFilePath(@NotNull TargetId target, @NotNull String internalClassName) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        Intrinsics.checkParameterIsNotNull((Object)internalClassName, (String)"internalClassName");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getIncrementalCache(target).getClassFilePath(internalClassName);
    }

    public void incrementalCache_close(@NotNull TargetId target) {
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        incrementalCompilationComponents.getIncrementalCache(target).close();
    }

    public boolean lookupTracker_requiresPosition() {
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        return incrementalCompilationComponents.getLookupTracker().getRequiresPosition();
    }

    public void lookupTracker_record(@NotNull Collection<LookupInfo> lookups) {
        Intrinsics.checkParameterIsNotNull(lookups, (String)"lookups");
        IncrementalCompilationComponents incrementalCompilationComponents = this.incrementalCompilationComponents;
        if (incrementalCompilationComponents == null) {
            Intrinsics.throwNpe();
        }
        LookupTracker lookupTracker = incrementalCompilationComponents.getLookupTracker();
        for (LookupInfo it : lookups) {
            lookupTracker.record(it.getFilePath(), it.getPosition(), it.getScopeFqName(), it.getScopeKind(), it.getName());
        }
    }

    public boolean lookupTracker_isDoNothing() {
        return this.lookupTracker_isDoNothing;
    }

    public void compilationCanceledStatus_checkCanceled() {
        try {
            CompilationCanceledStatus compilationCanceledStatus = this.compilationCancelledStatus;
            if (compilationCanceledStatus == null) {
                Intrinsics.throwNpe();
            }
            compilationCanceledStatus.checkCanceled();
        }
        catch (ProcessCanceledException e) {
            throw (Throwable)new RmiFriendlyCompilationCancelledException();
        }
    }

    @Nullable
    public final IncrementalCompilationComponents getIncrementalCompilationComponents() {
        return this.incrementalCompilationComponents;
    }

    @Nullable
    public final CompilationCanceledStatus getCompilationCancelledStatus() {
        return this.compilationCancelledStatus;
    }

    public CompilerCallbackServicesFacadeServer(@Nullable IncrementalCompilationComponents incrementalCompilationComponents, @Nullable CompilationCanceledStatus compilationCancelledStatus, int port) {
        super(port, (RMIClientSocketFactory)LoopbackNetworkInterface.INSTANCE.getClientLoopbackSocketFactory(), (RMIServerSocketFactory)LoopbackNetworkInterface.INSTANCE.getServerLoopbackSocketFactory());
        this.incrementalCompilationComponents = incrementalCompilationComponents;
        this.compilationCancelledStatus = compilationCancelledStatus;
        this.lookupTracker_isDoNothing = this.incrementalCompilationComponents != null && Intrinsics.areEqual((Object)this.incrementalCompilationComponents.getLookupTracker(), (Object)LookupTracker.Companion.getDO_NOTHING());
    }

    public /* synthetic */ CompilerCallbackServicesFacadeServer(IncrementalCompilationComponents incrementalCompilationComponents, CompilationCanceledStatus compilationCanceledStatus, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            incrementalCompilationComponents = null;
        }
        if ((n2 & 2) != 0) {
            compilationCanceledStatus = null;
        }
        if ((n2 & 4) != 0) {
            n = NetworkUtilsKt.getSOCKET_ANY_FREE_PORT();
        }
        this(incrementalCompilationComponents, compilationCanceledStatus, n);
    }

    public CompilerCallbackServicesFacadeServer() {
        this(null, null, 0, 7, null);
    }
}

