/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.snapShooter;

import com.intellij.uiDesigner.snapShooter.SnapShooterDaemon;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;

public class SnapShooter {
    private SnapShooter() {
    }

    public static void main(String[] args) throws Throwable {
        int origClassPathSize = Integer.parseInt(args[0]);
        int port = Integer.parseInt(args[1]);
        ClassLoader loader = SnapShooter.class.getClassLoader();
        if (loader instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)loader;
            URL[] oldURLs = ucl.getURLs();
            URL[] newURLs = new URL[origClassPathSize];
            int startIndex = oldURLs.length - origClassPathSize;
            System.arraycopy(oldURLs, startIndex, newURLs, 0, origClassPathSize);
            loader = new URLClassLoader(newURLs, null);
            Thread.currentThread().setContextClassLoader(loader);
        }
        Thread thread = new Thread((Runnable)new SnapShooterDaemon(port), "snapshooter");
        thread.setDaemon(true);
        thread.start();
        String mainClass = args[2];
        String[] parms = new String[args.length - 3];
        for (int j = 3; j < args.length; ++j) {
            parms[j - 3] = args[j];
        }
        Method m = loader.loadClass(mainClass).getMethod("main", parms.getClass());
        try {
            SnapShooter.ensureAccess(m);
            m.invoke(null, new Object[]{parms});
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    private static void ensureAccess(Object reflectionObject) {
        Class<?> aClass = reflectionObject.getClass();
        try {
            Method setAccessibleMethod = aClass.getMethod("setAccessible", Boolean.TYPE);
            setAccessibleMethod.invoke(reflectionObject, Boolean.TRUE);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

