/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.java.decompiler.IdeaDecompiler;
import org.jetbrains.java.decompiler.IdeaLogger$WhenMappings;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;

@KotlinClass(version={1, 0, 1}, abiVersion=32, data={"1\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0011\u0001B\u0001\u0006\u00031\tQ!\u0001\u0007\u0002\u000b\u0001)\u0011\u0001C\u0004\u0006\u0001\u0015\t\u0001\"A\u0003\u0002\t\u001b)\u0011\u0001c\u0001\u0006\u0001\u0015\tA\"A\u0003\u0001\u0019\u0001I\u0012\u0001'\u0001\u001e\u00025\t+!U\u0002\u0002\u0011\u0005)C\u0001B\u0006\t\t5\t\u0001\u0014B\u0013\u0005\t-AQ!D\u0001\u0019\n\u0015\"Aa\u0003E\u0006\u001b\u0005AJ!\n\u0003\u0005\u0017!1Q\"\u0001M\u0005K!!\u0011\u0001#\u0004\u000e\u0003a\u001d\u0011d\u0001\u0005\b\u001b\u0005A:!\n\u0005\u0005\u0017!=Q\"\u0001M\u00053\rA\u0001\"D\u0001\u0019\b\u0015BAa\u0003E\t\u001b\u0005AJ!G\u0002\t\u00135\t\u0001tA\u0013\t\t-A\u0019\"D\u0001\u0019\ne\u0019\u0001\u0002C\u0007\u00021\u000f)\u0003\u0002B\u0006\t\u00155\t\u0001\u0014B\r\u0004\u0011!i\u0011\u0001g\u0002&\u0019\u0011Y\u0001RC\u0007\u00021\u0013I2\u0001C\u0004\u000e\u0003a\u001d\u0011d\u0001\u0005\f\u001b\u0005A:\"\n\u0007\u0005\u0017!UQ\"\u0001M\u00053\rAq!D\u0001\u0019\be\u0019\u0001\u0002D\u0007\u000213I\u001b\u0002B!\t\u0011\u0007i9\u0001\u0007\u0002R\u0007\u0005!)!U\u0002\u0002\u000b\u0001I\u0003\u0002B!\u001d\u0011\ri!\u0001$\u0001\u0019\bE\u001b\u0011!\u0002\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaLogger;", "Lorg/jetbrains/java/decompiler/main/extern/IFernflowerLogger;", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "myClass", "", "endClass", "", "endMethod", "endReadingClass", "endWriteClass", "extendMessage", "message", "startClass", "className", "startMethod", "methodName", "startReadingClass", "startWriteClass", "writeMessage", "t", "", "severity", "Lorg/jetbrains/java/decompiler/main/extern/IFernflowerLogger$Severity;", "InternalException"}, moduleName="java-decompiler-plugin")
public final class IdeaLogger
extends IFernflowerLogger {
    private final Logger LOG = Logger.getInstance(IdeaDecompiler.class);
    private String myClass;

    @Override
    public void writeMessage(@NotNull String message, @NotNull IFernflowerLogger.Severity severity) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
        String text = this.extendMessage(message);
        switch (IdeaLogger$WhenMappings.$EnumSwitchMapping$0[severity.ordinal()]) {
            case 1: {
                this.LOG.error(text);
                break;
            }
            case 2: {
                this.LOG.warn(text);
                break;
            }
            case 3: {
                this.LOG.info(text);
                break;
            }
            default: {
                this.LOG.debug(text);
            }
        }
    }

    @Override
    public void writeMessage(@NotNull String message, @NotNull Throwable t) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
        Throwable throwable = t;
        if (throwable instanceof InternalException) {
            throw t;
        }
        if (throwable instanceof ProcessCanceledException) {
            throw t;
        }
        if (throwable instanceof InterruptedException) {
            throw (Throwable)new ProcessCanceledException(t);
        }
        throw (Throwable)new InternalException(this.extendMessage(message), t);
    }

    private final String extendMessage(String message) {
        return this.myClass != null ? message + " [" + this.myClass + "]" : message;
    }

    @Override
    public void startReadingClass(@NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        this.LOG.debug("decompiling class " + className);
        this.myClass = className;
    }

    @Override
    public void endReadingClass() {
        this.LOG.debug("... class decompiled");
        this.myClass = null;
    }

    @Override
    public void startClass(@NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        this.LOG.debug("processing class " + className);
    }

    @Override
    public void endClass() {
        this.LOG.debug("... class processed");
    }

    @Override
    public void startMethod(@NotNull String methodName) {
        Intrinsics.checkParameterIsNotNull((Object)methodName, (String)"methodName");
        this.LOG.debug("processing method " + methodName);
    }

    @Override
    public void endMethod() {
        this.LOG.debug("... method processed");
    }

    @Override
    public void startWriteClass(@NotNull String className) {
        Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
        this.LOG.debug("writing class " + className);
    }

    @Override
    public void endWriteClass() {
        this.LOG.debug("... class written");
    }

    @KotlinClass(version={1, 0, 1}, abiVersion=32, data={"\u0017\u0015\tA\"A\u0003\u0002\u0019\u0005)\u0001!B\u0001\t\u000f\u0015\u0001Q!\u0001E\u0002\u000b\u0001a\u0001!G\u0001\u0019\u0002\u0005V\u0011b\u0001\u0005\u0002\u001b\u0005A\u001a!C\u0002\t\u00055\t\u0001TA)\u0004\u0003!\u0019\u0001"}, strings={"Lorg/jetbrains/java/decompiler/IdeaLogger$InternalException;", "Ljava/lang/RuntimeException;", "message", "", "cause", "", "(Ljava/lang/String;Ljava/lang/Throwable;)V"}, moduleName="java-decompiler-plugin")
    public static final class InternalException
    extends RuntimeException {
        public InternalException(@NotNull String message, @NotNull Throwable cause) {
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
            super(message, cause);
        }
    }
}

