/*
 * Decompiled with CFR 0.152.
 */
package kotlin.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.NoSuchElementException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.ByteIterator;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.KotlinFileFacade;
import kotlin.text.Charsets;
import kotlin.text.CharsetsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 0}, bv={1, 0, 0}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00062\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0013\u001a\u00020\u000f*\u00020\u0014\u001a\u001a\u0010\u0013\u001a\u00020\u000f*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u001a\r\u0010\u0017\u001a\u00020\u0018*\u00020\u0001H\u0086\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0014*\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u0004\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00062\u0006\u0010\t\u001a\u00020\u000bH\u0007\u00a8\u0006\u001f"}, d2={"buffered", "Ljava/io/BufferedInputStream;", "Ljava/io/InputStream;", "bufferSize", "", "Ljava/io/BufferedOutputStream;", "Ljava/io/OutputStream;", "bufferedReader", "Ljava/io/BufferedReader;", "charset", "Ljava/nio/charset/Charset;", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "byteInputStream", "Ljava/io/ByteArrayInputStream;", "copyTo", "", "out", "inputStream", "", "offset", "length", "iterator", "Lkotlin/collections/ByteIterator;", "readBytes", "estimatedSize", "reader", "Ljava/io/InputStreamReader;", "writer", "Ljava/io/OutputStreamWriter;", "kotlin-stdlib"})
@KotlinFileFacade(version={1, 1, 0}, data={"\u0000Z\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0000\u001a\u00020\u0005*\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u0007\u001a\u00020\b*\u00020\u00022\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00062\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\u000b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u001c\u0010\u0010\u001a\u00020\u0011*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00062\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0013\u001a\u00020\u000f*\u00020\u0014\u001a\u001a\u0010\u0013\u001a\u00020\u000f*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004\u001a\r\u0010\u0017\u001a\u00020\u0018*\u00020\u0001H\u0086\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0014*\u00020\u00022\b\b\u0002\u0010\u001a\u001a\u00020\u0004\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u001b\u001a\u00020\u001c*\u00020\u00022\u0006\u0010\t\u001a\u00020\u000bH\u0007\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u001d\u001a\u00020\u001e*\u00020\u00062\u0006\u0010\t\u001a\u00020\u000bH\u0007\u00a8\u0006\u001f"}, strings={"buffered", "Ljava/io/BufferedInputStream;", "Ljava/io/InputStream;", "bufferSize", "", "Ljava/io/BufferedOutputStream;", "Ljava/io/OutputStream;", "bufferedReader", "Ljava/io/BufferedReader;", "charset", "Ljava/nio/charset/Charset;", "", "bufferedWriter", "Ljava/io/BufferedWriter;", "byteInputStream", "Ljava/io/ByteArrayInputStream;", "copyTo", "", "out", "inputStream", "", "offset", "length", "iterator", "Lkotlin/collections/ByteIterator;", "readBytes", "estimatedSize", "reader", "Ljava/io/InputStreamReader;", "writer", "Ljava/io/OutputStreamWriter;", "kotlin-stdlib"})
@JvmName(name="ByteStreamsKt")
public final class ByteStreamsKt {
    @NotNull
    public static final ByteIterator iterator(BufferedInputStream $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteIterator($receiver){
            private int nextByte;
            private boolean nextPrepared;
            private boolean finished;
            final /* synthetic */ BufferedInputStream receiver$0;

            public final int getNextByte() {
                return this.nextByte;
            }

            public final void setNextByte(int n) {
                this.nextByte = n;
            }

            public final boolean getNextPrepared() {
                return this.nextPrepared;
            }

            public final void setNextPrepared(boolean bl) {
                this.nextPrepared = bl;
            }

            public final boolean getFinished() {
                return this.finished;
            }

            public final void setFinished(boolean bl) {
                this.finished = bl;
            }

            private final void prepareNext() {
                if (!this.nextPrepared && !this.finished) {
                    this.nextByte = this.receiver$0.read();
                    this.nextPrepared = true;
                    this.finished = this.nextByte == -1;
                }
            }

            public boolean hasNext() {
                this.prepareNext();
                return !this.finished;
            }

            public byte nextByte() {
                this.prepareNext();
                if (this.finished) {
                    throw (Throwable)new NoSuchElementException("Input stream is over");
                }
                byte res = (byte)this.nextByte;
                this.nextPrepared = false;
                return res;
            }
            {
                this.receiver$0 = $receiver;
                this.nextByte = -1;
            }

            public void remove() {
                throw new UnsupportedOperationException("Mutating immutable collection");
            }
        };
    }

    @NotNull
    public static final ByteArrayInputStream byteInputStream(String $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new ByteArrayInputStream(StringsKt.toByteArray($receiver, charset));
    }

    @NotNull
    public static /* bridge */ /* synthetic */ ByteArrayInputStream byteInputStream$default(String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return ByteStreamsKt.byteInputStream(string, charset);
    }

    public static /* bridge */ /* synthetic */ ByteArrayInputStream byteInputStream$default(String string, Charset charset, int n) {
        return ByteStreamsKt.byteInputStream$default(string, charset, n, null);
    }

    @NotNull
    public static final ByteArrayInputStream inputStream(byte[] $receiver) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteArrayInputStream($receiver);
    }

    @NotNull
    public static final ByteArrayInputStream inputStream(byte[] $receiver, int offset, int length) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return new ByteArrayInputStream($receiver, offset, length);
    }

    @NotNull
    public static final BufferedInputStream buffered(InputStream $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedInputStream ? (BufferedInputStream)$receiver : new BufferedInputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedInputStream buffered$default(InputStream inputStream, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDEFAULT_BUFFER_SIZE();
        }
        return ByteStreamsKt.buffered(inputStream, n);
    }

    public static /* bridge */ /* synthetic */ BufferedInputStream buffered$default(InputStream inputStream, int n, int n2) {
        return ByteStreamsKt.buffered$default(inputStream, n, n2, null);
    }

    @NotNull
    public static final InputStreamReader reader(InputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ InputStreamReader reader$default(InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return ByteStreamsKt.reader(inputStream, charset);
    }

    public static /* bridge */ /* synthetic */ InputStreamReader reader$default(InputStream inputStream, Charset charset, int n) {
        return ByteStreamsKt.reader$default(inputStream, charset, n, null);
    }

    @NotNull
    public static final BufferedReader bufferedReader(InputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.reader($receiver, charset), 0, 1, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedReader bufferedReader$default(InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return ByteStreamsKt.bufferedReader(inputStream, charset);
    }

    public static /* bridge */ /* synthetic */ BufferedReader bufferedReader$default(InputStream inputStream, Charset charset, int n) {
        return ByteStreamsKt.bufferedReader$default(inputStream, charset, n, null);
    }

    @Deprecated(message="Use InputStream.reader(Charset) instead.", replaceWith=@ReplaceWith(imports={}, expression="this.reader(charset(charset))"), level=DeprecationLevel.ERROR)
    @NotNull
    public static final InputStreamReader reader(InputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new InputStreamReader($receiver, charset);
    }

    @Deprecated(message="Use InputStream.bufferedReader(Charset) instead.", replaceWith=@ReplaceWith(imports={}, expression="this.bufferedReader(charset(charset))"), level=DeprecationLevel.ERROR)
    @NotNull
    public static final BufferedReader bufferedReader(InputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.reader($receiver, CharsetsKt.charset(charset)), 0, 1, null);
    }

    @NotNull
    public static final BufferedOutputStream buffered(OutputStream $receiver, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        return $receiver instanceof BufferedOutputStream ? (BufferedOutputStream)$receiver : new BufferedOutputStream($receiver, bufferSize);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDEFAULT_BUFFER_SIZE();
        }
        return ByteStreamsKt.buffered(outputStream, n);
    }

    public static /* bridge */ /* synthetic */ BufferedOutputStream buffered$default(OutputStream outputStream, int n, int n2) {
        return ByteStreamsKt.buffered$default(outputStream, n, n2, null);
    }

    @NotNull
    public static final OutputStreamWriter writer(OutputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return ByteStreamsKt.writer(outputStream, charset);
    }

    public static /* bridge */ /* synthetic */ OutputStreamWriter writer$default(OutputStream outputStream, Charset charset, int n) {
        return ByteStreamsKt.writer$default(outputStream, charset, n, null);
    }

    @NotNull
    public static final BufferedWriter bufferedWriter(OutputStream $receiver, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.writer($receiver, charset), 0, 1, null);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ BufferedWriter bufferedWriter$default(OutputStream outputStream, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return ByteStreamsKt.bufferedWriter(outputStream, charset);
    }

    public static /* bridge */ /* synthetic */ BufferedWriter bufferedWriter$default(OutputStream outputStream, Charset charset, int n) {
        return ByteStreamsKt.bufferedWriter$default(outputStream, charset, n, null);
    }

    @Deprecated(message="Use OutputStream.writer(Charset) instead.", replaceWith=@ReplaceWith(imports={}, expression="this.writer(charset(charset))"), level=DeprecationLevel.ERROR)
    @NotNull
    public static final OutputStreamWriter writer(OutputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return new OutputStreamWriter($receiver, charset);
    }

    @Deprecated(message="Use OutputStream.bufferedWriter(Charset) instead.", replaceWith=@ReplaceWith(imports={}, expression="this.bufferedWriter(charset(charset))"), level=DeprecationLevel.ERROR)
    @NotNull
    public static final BufferedWriter bufferedWriter(OutputStream $receiver, @NotNull String charset) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(charset, "charset");
        return TextStreamsKt.buffered$default(ByteStreamsKt.writer($receiver, CharsetsKt.charset(charset)), 0, 1, null);
    }

    public static final long copyTo(InputStream $receiver, @NotNull OutputStream out, int bufferSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(out, "out");
        long bytesCopied = 0L;
        byte[] buffer = new byte[bufferSize];
        int bytes = $receiver.read(buffer);
        while (bytes >= 0) {
            out.write(buffer, 0, bytes);
            bytesCopied += (long)bytes;
            bytes = $receiver.read(buffer);
        }
        return bytesCopied;
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = FilesKt.getDEFAULT_BUFFER_SIZE();
        }
        return ByteStreamsKt.copyTo(inputStream, outputStream, n);
    }

    public static /* bridge */ /* synthetic */ long copyTo$default(InputStream inputStream, OutputStream outputStream, int n, int n2) {
        return ByteStreamsKt.copyTo$default(inputStream, outputStream, n, n2, null);
    }

    @NotNull
    public static final byte[] readBytes(InputStream $receiver, int estimatedSize) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(estimatedSize);
        ByteStreamsKt.copyTo$default($receiver, buffer, 0, 2, null);
        byte[] byArray = buffer.toByteArray();
        Intrinsics.checkExpressionValueIsNotNull(byArray, "buffer.toByteArray()");
        return byArray;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = FilesKt.getDEFAULT_BUFFER_SIZE();
        }
        return ByteStreamsKt.readBytes(inputStream, n);
    }

    public static /* bridge */ /* synthetic */ byte[] readBytes$default(InputStream inputStream, int n, int n2) {
        return ByteStreamsKt.readBytes$default(inputStream, n, n2, null);
    }
}

