/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options;

import com.intellij.application.options.ChangesDiffCalculator;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.PredefinedCodeStyle;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.Alarm;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CodeStyleAbstractPanel
implements Disposable {
    private static final long TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS = TimeUnit.SECONDS.toMillis(3L);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.application.options.CodeStyleXmlPanel");
    private final ChangesDiffCalculator myDiffCalculator;
    private final List<TextRange> myPreviewRangesToHighlight;
    private final Editor myEditor;
    private final CodeStyleSettings mySettings;
    private boolean myShouldUpdatePreview;
    protected static final int[] ourWrappings = new int[]{0, 1, 4, 2};
    private long myLastDocumentModificationStamp;
    private String myTextToReformat;
    private final UserActivityWatcher myUserActivityWatcher;
    private final Alarm myUpdateAlarm;
    private CodeStyleSchemesModel myModel;
    private boolean mySomethingChanged;
    private long myEndHighlightPreviewChangesTimeMillis;
    private boolean myShowsPreviewHighlighters;
    private final CodeStyleSettings myCurrentSettings;
    private final Language myDefaultLanguage;

    protected CodeStyleAbstractPanel(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/CodeStyleAbstractPanel", "<init>"));
        }
        this(null, null, settings);
    }

    protected CodeStyleAbstractPanel(@Nullable Language defaultLanguage, @Nullable CodeStyleSettings currentSettings, @NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/application/options/CodeStyleAbstractPanel", "<init>"));
        }
        this.myDiffCalculator = new ChangesDiffCalculator();
        this.myPreviewRangesToHighlight = new ArrayList<TextRange>();
        this.myTextToReformat = null;
        this.myUserActivityWatcher = new UserActivityWatcher();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.mySomethingChanged = false;
        this.myEndHighlightPreviewChangesTimeMillis = -1L;
        Disposer.register((Disposable)this, (Disposable)this.myDiffCalculator);
        this.myCurrentSettings = currentSettings;
        this.mySettings = settings;
        this.myDefaultLanguage = defaultLanguage;
        this.myEditor = this.createEditor();
        if (this.myEditor != null) {
            this.myUpdateAlarm.setActivationComponent(this.myEditor.getComponent());
        }
        this.myUserActivityWatcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                CodeStyleAbstractPanel.this.somethingChanged();
            }
        });
        this.updatePreview(true);
    }

    protected void setShouldUpdatePreview(boolean shouldUpdatePreview) {
        this.myShouldUpdatePreview = shouldUpdatePreview;
    }

    private synchronized void setSomethingChanged(boolean b) {
        this.mySomethingChanged = b;
    }

    private synchronized boolean isSomethingChanged() {
        return this.mySomethingChanged;
    }

    public void setModel(CodeStyleSchemesModel model) {
        this.myModel = model;
    }

    protected void somethingChanged() {
        if (this.myModel != null) {
            this.myModel.fireCurrentSettingsChanged();
        }
    }

    protected void addPanelToWatch(Component component) {
        this.myUserActivityWatcher.register(component);
    }

    @Nullable
    private Editor createEditor() {
        if (this.getPreviewText() == null) {
            return null;
        }
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document editorDocument = editorFactory.createDocument((CharSequence)"");
        EditorEx editor = (EditorEx)editorFactory.createEditor(editorDocument);
        CodeStyleAbstractPanel.fillEditorSettings(editor.getSettings());
        this.myLastDocumentModificationStamp = editor.getDocument().getModificationStamp();
        return editor;
    }

    private static void fillEditorSettings(EditorSettings editorSettings) {
        editorSettings.setWhitespacesShown(true);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setAdditionalColumnsCount(0);
        editorSettings.setAdditionalLinesCount(1);
        editorSettings.setUseSoftWraps(false);
    }

    protected void updatePreview(boolean useDefaultSample) {
        if (this.myEditor == null) {
            return;
        }
        this.updateEditor(useDefaultSample);
        this.updatePreviewHighlighter((EditorEx)this.myEditor);
    }

    private void updateEditor(boolean useDefaultSample) {
        if (!this.myShouldUpdatePreview || !ApplicationManager.getApplication().isUnitTestMode() && !this.myEditor.getComponent().isShowing()) {
            return;
        }
        if (this.myLastDocumentModificationStamp != this.myEditor.getDocument().getModificationStamp()) {
            this.myTextToReformat = this.myEditor.getDocument().getText();
        } else if (useDefaultSample || this.myTextToReformat == null) {
            this.myTextToReformat = this.getPreviewText();
        }
        int currOffs = this.myEditor.getScrollingModel().getVerticalScrollOffset();
        final Project finalProject = ProjectUtil.guessCurrentProject((JComponent)this.getPanel());
        CommandProcessor.getInstance().executeCommand(finalProject, new Runnable(){

            @Override
            public void run() {
                CodeStyleAbstractPanel.this.replaceText(finalProject);
            }
        }, null, null);
        this.myEditor.getSettings().setRightMargin(this.getAdjustedRightMargin());
        this.myLastDocumentModificationStamp = this.myEditor.getDocument().getModificationStamp();
        this.myEditor.getScrollingModel().scrollVertically(currOffs);
    }

    private int getAdjustedRightMargin() {
        int result = this.getRightMargin();
        return result > 0 ? result : CodeStyleFacade.getInstance((Project)ProjectUtil.guessCurrentProject((JComponent)this.getPanel())).getRightMargin(this.getDefaultLanguage());
    }

    protected abstract int getRightMargin();

    private void replaceText(final Project project2) {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    PsiFile formatted;
                    Document beforeReformat = null;
                    beforeReformat = CodeStyleAbstractPanel.this.collectChangesBeforeCurrentSettingsAppliance(project2);
                    PsiFile psiFile = CodeStyleAbstractPanel.this.createFileFromText(project2, CodeStyleAbstractPanel.this.myTextToReformat);
                    CodeStyleAbstractPanel.this.prepareForReformat(psiFile);
                    try {
                        CodeStyleAbstractPanel.this.apply(CodeStyleAbstractPanel.this.mySettings);
                    }
                    catch (ConfigurationException configurationException) {
                        // empty catch block
                    }
                    CodeStyleSettings clone = CodeStyleAbstractPanel.this.mySettings.clone();
                    clone.setRightMargin(CodeStyleAbstractPanel.this.getDefaultLanguage(), CodeStyleAbstractPanel.this.getAdjustedRightMargin());
                    CodeStyleSettingsManager.getInstance((Project)project2).setTemporarySettings(clone);
                    try {
                        formatted = CodeStyleAbstractPanel.this.doReformat(project2, psiFile);
                    }
                    finally {
                        CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings();
                    }
                    CodeStyleAbstractPanel.this.myEditor.getSettings().setTabSize(clone.getTabSize(CodeStyleAbstractPanel.this.getFileType()));
                    Document document = CodeStyleAbstractPanel.this.myEditor.getDocument();
                    document.replaceString(0, document.getTextLength(), (CharSequence)formatted.getText());
                    if (document != null && beforeReformat != null) {
                        CodeStyleAbstractPanel.this.highlightChanges(beforeReformat);
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Document collectChangesBeforeCurrentSettingsAppliance(Project project2) {
        Document document;
        PsiFile psiFile = this.createFileFromText(project2, this.myTextToReformat);
        this.prepareForReformat(psiFile);
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        if (documentManager != null && (document = documentManager.getDocument(psiFile)) != null) {
            CodeStyleSettings clone = this.mySettings.clone();
            clone.setRightMargin(this.getDefaultLanguage(), this.getAdjustedRightMargin());
            CodeStyleSettingsManager.getInstance((Project)project2).setTemporarySettings(clone);
            try {
                CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)psiFile);
            }
            finally {
                CodeStyleSettingsManager.getInstance((Project)project2).dropTemporarySettings();
            }
            return document;
        }
        return null;
    }

    protected void prepareForReformat(PsiFile psiFile) {
    }

    protected String getFileExt() {
        return this.getFileTypeExtension(this.getFileType());
    }

    protected PsiFile createFileFromText(Project project2, String text) {
        return PsiFileFactory.getInstance((Project)project2).createFileFromText("a." + this.getFileExt(), this.getFileType(), (CharSequence)text, LocalTimeCounter.currentTime(), true);
    }

    protected PsiFile doReformat(Project project2, PsiFile psiFile) {
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)psiFile);
        return psiFile;
    }

    private void highlightChanges(Document beforeReformat) {
        this.myPreviewRangesToHighlight.clear();
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        markupModel.removeAllHighlighters();
        int textLength = this.myEditor.getDocument().getTextLength();
        boolean highlightPreview = false;
        Collection<TextRange> ranges = this.myDiffCalculator.calculateDiff(beforeReformat, this.myEditor.getDocument());
        for (TextRange range : ranges) {
            if (range.getStartOffset() >= textLength) continue;
            highlightPreview = true;
            TextRange rangeToUse = this.calculateChangeHighlightRange(range);
            this.myPreviewRangesToHighlight.add(rangeToUse);
        }
        if (highlightPreview) {
            this.myEndHighlightPreviewChangesTimeMillis = System.currentTimeMillis() + TIME_TO_HIGHLIGHT_PREVIEW_CHANGES_IN_MILLIS;
            this.myShowsPreviewHighlighters = true;
        }
    }

    private static boolean isWithinBounds(VisualPosition targetPosition, VisualPosition startPosition, VisualPosition endPosition) {
        return targetPosition.line >= startPosition.line && targetPosition.line <= endPosition.line && targetPosition.column >= startPosition.column && targetPosition.column <= endPosition.column;
    }

    private TextRange calculateChangeHighlightRange(TextRange range) {
        int endOffset;
        CharSequence text = this.myEditor.getDocument().getCharsSequence();
        if (range.getLength() <= 0) {
            int offset;
            for (offset = range.getStartOffset(); offset < text.length() && text.charAt(offset) == ' '; ++offset) {
            }
            return offset > range.getStartOffset() ? new TextRange(offset, offset) : range;
        }
        int startOffset = range.getStartOffset() + 1;
        boolean useSameRange = true;
        for (endOffset = range.getEndOffset() + 1; endOffset <= text.length() && StringUtil.equals((CharSequence)text.subSequence(range.getStartOffset(), range.getEndOffset()), (CharSequence)text.subSequence(startOffset, endOffset)); ++endOffset) {
            useSameRange = false;
            ++startOffset;
        }
        return useSameRange ? range : new TextRange(--startOffset, --endOffset);
    }

    private void updatePreviewHighlighter(EditorEx editor) {
        EditorColorsScheme scheme = editor.getColorsScheme();
        editor.getSettings().setCaretRowShown(false);
        editor.setHighlighter(this.createHighlighter(scheme));
    }

    @Nullable
    protected abstract EditorHighlighter createHighlighter(EditorColorsScheme var1);

    @NotNull
    protected abstract FileType getFileType();

    @NonNls
    @Nullable
    protected abstract String getPreviewText();

    public abstract void apply(CodeStyleSettings var1) throws ConfigurationException;

    public final void reset(CodeStyleSettings settings) {
        this.myShouldUpdatePreview = false;
        try {
            this.resetImpl(settings);
        }
        finally {
            this.myShouldUpdatePreview = true;
        }
    }

    protected static int getIndexForWrapping(int value) {
        for (int i = 0; i < ourWrappings.length; ++i) {
            int ourWrapping = ourWrappings[i];
            if (ourWrapping != value) continue;
            return i;
        }
        LOG.assertTrue(false);
        return 0;
    }

    public abstract boolean isModified(CodeStyleSettings var1);

    @Nullable
    public abstract JComponent getPanel();

    public void dispose() {
        this.myUpdateAlarm.cancelAllRequests();
        if (this.myEditor != null) {
            EditorFactory.getInstance().releaseEditor(this.myEditor);
        }
    }

    protected abstract void resetImpl(CodeStyleSettings var1);

    protected static void fillWrappingCombo(JComboBox wrapCombo) {
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.do.not.wrap", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.wrap.if.long", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.chop.down.if.long", (Object[])new Object[0]));
        wrapCombo.addItem(ApplicationBundle.message((String)"wrapping.wrap.always", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromFile(Class resourceContainerClass, @NonNls String fileName) {
        try {
            StringBuffer result;
            InputStream stream = resourceContainerClass.getClassLoader().getResourceAsStream("codeStyle/preview/" + fileName);
            InputStreamReader reader = new InputStreamReader(stream);
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            try {
                String line;
                result = new StringBuffer();
                while ((line = lineNumberReader.readLine()) != null) {
                    result.append(line);
                    result.append("\n");
                }
            }
            finally {
                lineNumberReader.close();
            }
            return result.toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    protected void installPreviewPanel(JPanel previewPanel) {
        previewPanel.setLayout(new BorderLayout());
        previewPanel.add((Component)this.getEditor().getComponent(), "Center");
        previewPanel.setBorder(new AbstractBorder(){
            private static final int LEFT_WHITE_SPACE = 2;

            @Override
            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                Editor editor = CodeStyleAbstractPanel.this.getEditor();
                if (editor instanceof EditorEx) {
                    g.setColor(((EditorEx)editor).getBackgroundColor());
                    g.fillRect(x + 1, y, 2, height);
                }
                g.setColor(OnePixelDivider.BACKGROUND);
                g.fillRect(x, y, 1, height);
            }

            @Override
            public Insets getBorderInsets(Component c, Insets insets) {
                insets.set(0, 3, 0, 0);
                return insets;
            }
        });
    }

    @NonNls
    protected String getFileTypeExtension(FileType fileType) {
        return fileType.getDefaultExtension();
    }

    public void onSomethingChanged() {
        this.setSomethingChanged(true);
        if (this.myEditor != null) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                this.updateEditor(true);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)this.myEditor.getComponent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CodeStyleAbstractPanel.this.addUpdatePreviewRequest();
                    }
                });
            }
        }
    }

    private void addUpdatePreviewRequest() {
        this.myUpdateAlarm.addComponentRequest(new Runnable(){

            @Override
            public void run() {
                try {
                    CodeStyleAbstractPanel.this.myUpdateAlarm.cancelAllRequests();
                    if (CodeStyleAbstractPanel.this.isSomethingChanged()) {
                        CodeStyleAbstractPanel.this.updateEditor(false);
                    }
                    if (System.currentTimeMillis() <= CodeStyleAbstractPanel.this.myEndHighlightPreviewChangesTimeMillis && !CodeStyleAbstractPanel.this.myPreviewRangesToHighlight.isEmpty()) {
                        CodeStyleAbstractPanel.this.blinkHighlighters();
                        CodeStyleAbstractPanel.this.myUpdateAlarm.addComponentRequest((Runnable)this, 500);
                    } else {
                        CodeStyleAbstractPanel.this.myEditor.getMarkupModel().removeAllHighlighters();
                    }
                }
                finally {
                    CodeStyleAbstractPanel.this.setSomethingChanged(false);
                }
            }
        }, 300);
    }

    private void blinkHighlighters() {
        MarkupModel markupModel = this.myEditor.getMarkupModel();
        if (this.myShowsPreviewHighlighters) {
            Rectangle visibleArea = this.myEditor.getScrollingModel().getVisibleArea();
            VisualPosition visualStart = this.myEditor.xyToVisualPosition(visibleArea.getLocation());
            VisualPosition visualEnd = this.myEditor.xyToVisualPosition(new Point(visibleArea.x + visibleArea.width, visibleArea.y + visibleArea.height));
            int endColumnCandidate = visibleArea.width / EditorUtil.getSpaceWidth(0, this.myEditor) + visualStart.column;
            if (endColumnCandidate > visualEnd.column) {
                visualEnd = new VisualPosition(visualEnd.line, endColumnCandidate);
            }
            int offsetToScroll = -1;
            CharSequence text = this.myEditor.getDocument().getCharsSequence();
            TextAttributes backgroundAttributes = this.myEditor.getColorsScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
            TextAttributes borderAttributes = new TextAttributes(null, null, backgroundAttributes.getBackgroundColor(), EffectType.BOXED, 0);
            boolean scrollToChange = true;
            for (TextRange range : this.myPreviewRangesToHighlight) {
                if (scrollToChange) {
                    boolean rangeVisible = CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range.getStartOffset()), visualStart, visualEnd) || CodeStyleAbstractPanel.isWithinBounds(this.myEditor.offsetToVisualPosition(range.getEndOffset()), visualStart, visualEnd);
                    boolean bl = scrollToChange = !rangeVisible;
                    if (offsetToScroll < 0 && offsetToScroll < 0) {
                        if (text.charAt(range.getStartOffset()) != '\n') {
                            offsetToScroll = range.getStartOffset();
                        } else if (range.getEndOffset() > 0 && text.charAt(range.getEndOffset() - 1) != '\n') {
                            offsetToScroll = range.getEndOffset() - 1;
                        }
                    }
                }
                TextAttributes attributesToUse = range.getLength() > 0 ? backgroundAttributes : borderAttributes;
                markupModel.addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 6000, attributesToUse, HighlighterTargetArea.EXACT_RANGE);
            }
            if (scrollToChange) {
                if (offsetToScroll < 0 && !this.myPreviewRangesToHighlight.isEmpty()) {
                    offsetToScroll = this.myPreviewRangesToHighlight.get(0).getStartOffset();
                }
                if (offsetToScroll >= 0 && offsetToScroll < text.length() - 1 && text.charAt(offsetToScroll) != '\n') {
                    ++offsetToScroll;
                }
                if (offsetToScroll >= 0 && offsetToScroll < this.myEditor.getDocument().getTextLength()) {
                    this.myEditor.getScrollingModel().scrollTo(this.myEditor.offsetToLogicalPosition(offsetToScroll), ScrollType.RELATIVE);
                }
            }
        } else {
            markupModel.removeAllHighlighters();
        }
        this.myShowsPreviewHighlighters = !this.myShowsPreviewHighlighters;
    }

    protected Editor getEditor() {
        return this.myEditor;
    }

    @NotNull
    protected CodeStyleSettings getSettings() {
        CodeStyleSettings codeStyleSettings = this.mySettings;
        if (codeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/application/options/CodeStyleAbstractPanel", "getSettings"));
        }
        return codeStyleSettings;
    }

    public Set<String> processListOptions() {
        return Collections.emptySet();
    }

    public final void applyPredefinedSettings(@NotNull PredefinedCodeStyle codeStyle) {
        if (codeStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeStyle", "com/intellij/application/options/CodeStyleAbstractPanel", "applyPredefinedSettings"));
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)ProjectUtil.guessCurrentProject((JComponent)this.getPanel())).clone();
        codeStyle.apply(settings);
        this.reset(settings);
        this.onSomethingChanged();
    }

    @Nullable
    public Language getDefaultLanguage() {
        return this.myDefaultLanguage;
    }

    protected String getTabTitle() {
        return "Other";
    }

    protected CodeStyleSettings getCurrentSettings() {
        return this.myCurrentSettings;
    }

    public void setupCopyFromMenu(JPopupMenu copyMenu) {
        copyMenu.removeAll();
    }

    public boolean isCopyFromMenuAvailable() {
        return false;
    }
}

