/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.editor;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.GutterIconDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.daemon.LineMarkerSettings;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.ui.CheckBoxList;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.EmptyIcon;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GutterIconsConfigurable
implements Configurable,
Configurable.NoScroll {
    private JPanel myPanel;
    private CheckBoxList<GutterIconDescriptor> myList;
    private List<GutterIconDescriptor> myDescriptors;
    private Map<GutterIconDescriptor, PluginDescriptor> myFirstDescriptors;

    public GutterIconsConfigurable() {
        this.$$$setupUI$$$();
        this.myFirstDescriptors = new HashMap<GutterIconDescriptor, PluginDescriptor>();
    }

    @Nls
    public String getDisplayName() {
        return "Gutter Icons";
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.codeInsight.lineMarkerProvider");
        LanguageExtensionPoint[] extensions = (LanguageExtensionPoint[])point.getExtensions();
        NullableFunction<LanguageExtensionPoint<LineMarkerProvider>, PluginDescriptor> function = new NullableFunction<LanguageExtensionPoint<LineMarkerProvider>, PluginDescriptor>(){

            @Nullable
            public PluginDescriptor fun(LanguageExtensionPoint<LineMarkerProvider> point) {
                LineMarkerProvider instance = (LineMarkerProvider)point.getInstance();
                return instance instanceof LineMarkerProviderDescriptor && ((LineMarkerProviderDescriptor)instance).getName() != null ? point.getPluginDescriptor() : null;
            }
        };
        MultiMap map = ContainerUtil.groupBy(Arrays.asList(extensions), (NullableFunction)function);
        this.myDescriptors = new ArrayList<GutterIconDescriptor>();
        for (PluginDescriptor descriptor : map.keySet()) {
            Collection points = map.get((Object)descriptor);
            AtomicBoolean first = new AtomicBoolean(true);
            for (LanguageExtensionPoint extensionPoint : points) {
                GutterIconDescriptor instance = (GutterIconDescriptor)extensionPoint.getInstance();
                if (instance.getOptions().length > 0) {
                    for (GutterIconDescriptor.Option option : instance.getOptions()) {
                        if (first.getAndSet(false)) {
                            this.myFirstDescriptors.put(instance, descriptor);
                        }
                        this.myDescriptors.add((GutterIconDescriptor)option);
                    }
                    continue;
                }
                if (first.getAndSet(false)) {
                    this.myFirstDescriptors.put(instance, descriptor);
                }
                this.myDescriptors.add(instance);
            }
        }
        ArrayList<GutterIconDescriptor.Option> options = new ArrayList<GutterIconDescriptor.Option>();
        Iterator<GutterIconDescriptor> iterator = this.myDescriptors.iterator();
        while (iterator.hasNext()) {
            GutterIconDescriptor descriptor = iterator.next();
            if (descriptor.getOptions().length <= 0) continue;
            options.addAll(Arrays.asList(descriptor.getOptions()));
            iterator.remove();
        }
        this.myDescriptors.addAll(options);
        this.myList.setItems(this.myDescriptors, (Function)new Function<GutterIconDescriptor, String>(){

            public String fun(GutterIconDescriptor descriptor) {
                return descriptor.getName();
            }
        });
        return this.myPanel;
    }

    public boolean isModified() {
        for (GutterIconDescriptor descriptor : this.myDescriptors) {
            if (this.myList.isItemSelected((Object)descriptor) == LineMarkerSettings.getSettings().isEnabled(descriptor)) continue;
            return true;
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        for (GutterIconDescriptor descriptor : this.myDescriptors) {
            LineMarkerSettings.getSettings().setEnabled(descriptor, this.myList.isItemSelected((Object)descriptor));
        }
        for (Project project2 : ProjectManager.getInstance().getOpenProjects()) {
            DaemonCodeAnalyzer.getInstance((Project)project2).restart();
        }
    }

    public void reset() {
        for (GutterIconDescriptor descriptor : this.myDescriptors) {
            this.myList.setItemSelected((Object)descriptor, LineMarkerSettings.getSettings().isEnabled(descriptor));
        }
    }

    public void disposeUIResources() {
    }

    private void createUIComponents() {
        this.myList = new CheckBoxList<GutterIconDescriptor>(){

            protected JComponent adjustRendering(JComponent rootComponent, JCheckBox checkBox, int index, boolean selected, boolean hasFocus) {
                JPanel panel = new JPanel(new BorderLayout());
                panel.setBorder(BorderFactory.createEmptyBorder());
                GutterIconDescriptor descriptor = (GutterIconDescriptor)GutterIconsConfigurable.this.myList.getItemAt(index);
                Icon icon = descriptor == null ? null : descriptor.getIcon();
                JLabel label = new JLabel(icon == null ? EmptyIcon.ICON_16 : icon);
                label.setOpaque(true);
                label.setPreferredSize(new Dimension(25, -1));
                label.setHorizontalAlignment(0);
                panel.add((Component)label, "West");
                panel.add((Component)checkBox, "Center");
                panel.setBackground(this.getBackground(false));
                label.setBackground(this.getBackground(selected));
                checkBox.setBorder(null);
                PluginDescriptor pluginDescriptor = (PluginDescriptor)GutterIconsConfigurable.this.myFirstDescriptors.get(descriptor);
                if (pluginDescriptor instanceof IdeaPluginDescriptor) {
                    SeparatorWithText separator = new SeparatorWithText();
                    String name = ((IdeaPluginDescriptor)pluginDescriptor).getName();
                    separator.setCaption("IDEA CORE".equals(name) ? "Platform" : name);
                    panel.add((Component)separator, "North");
                }
                return panel;
            }

            @Nullable
            protected Point findPointRelativeToCheckBox(int x, int y, @NotNull JCheckBox checkBox, int index) {
                if (checkBox == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkBox", "com/intellij/application/options/editor/GutterIconsConfigurable$3", "findPointRelativeToCheckBox"));
                }
                return super.findPointRelativeToCheckBoxWithAdjustedRendering(x, y, checkBox, index);
            }
        };
        this.myList.setBorder(BorderFactory.createEmptyBorder());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        CheckBoxList<GutterIconDescriptor> checkBoxList = this.myList;
        jBScrollPane.setViewportView((Component)checkBoxList);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

