/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.ShowAutoImportPass;
import com.intellij.codeInsight.daemon.impl.quickfix.ImportClassFixBase;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiMember;
import com.intellij.psi.util.PsiUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StaticImportMemberFix<T extends PsiMember>
implements IntentionAction,
HintAction {
    private List<T> candidates;

    @NotNull
    protected abstract String getBaseText();

    @NotNull
    protected abstract String getMemberPresentableText(T var1);

    @NotNull
    public String getText() {
        String text = this.getBaseText();
        text = this.candidates != null && this.candidates.size() == 1 ? text + " '" + this.getMemberPresentableText((PsiMember)this.candidates.get(0)) + "'" : text + "...";
        String string = text;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix", "getFamilyName"));
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        List<T> list;
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix", "isAvailable"));
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)file2)) return false;
        if (!file2.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) return false;
        if (this.getElement() == null) return false;
        if (!this.getElement().isValid()) return false;
        if (this.getQualifierExpression() != null) return false;
        if (this.resolveRef() != null) return false;
        if (!file2.getManager().isInProject((PsiElement)file2)) return false;
        if (this.candidates == null) {
            this.candidates = this.getMembersToImport(false);
            list = this.candidates;
        } else {
            list = this.candidates;
        }
        if (list.isEmpty()) return false;
        return true;
    }

    @NotNull
    protected abstract List<T> getMembersToImport(boolean var1);

    @NotNull
    protected abstract QuestionAction createQuestionAction(List<T> var1, @NotNull Project var2, Editor var3);

    @Nullable
    protected abstract PsiElement getElement();

    @Nullable
    protected abstract PsiElement getQualifierExpression();

    @Nullable
    protected abstract PsiElement resolveRef();

    public void invoke(final @NotNull Project project2, final Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                List methodsToImport = StaticImportMemberFix.this.getMembersToImport(false);
                if (methodsToImport.isEmpty()) {
                    return;
                }
                StaticImportMemberFix.this.createQuestionAction(methodsToImport, project2, editor).execute();
            }
        });
    }

    private ImportClassFixBase.Result doFix(Editor editor) {
        if (!CodeInsightSettings.getInstance().ADD_MEMBER_IMPORTS_ON_THE_FLY) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        List<T> candidates = this.getMembersToImport(true);
        if (candidates.isEmpty()) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        PsiElement element = this.getElement();
        if (element == null) {
            return ImportClassFixBase.Result.POPUP_NOT_SHOWN;
        }
        final QuestionAction action = this.createQuestionAction(candidates, element.getProject(), editor);
        PsiFile psiFile = element.getContainingFile();
        if (candidates.size() == 1 && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)psiFile)) && !LaterInvocator.isInModalContext()) {
            CommandProcessor.getInstance().runUndoTransparentAction(new Runnable(){

                @Override
                public void run() {
                    action.execute();
                }
            });
            return ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
        }
        String hintText = ShowAutoImportPass.getMessage(candidates.size() > 1, this.getMemberPresentableText((PsiMember)candidates.get(0)));
        if (!ApplicationManager.getApplication().isUnitTestMode() && !HintManager.getInstance().hasShownHintsThatWillHideByOtherHint(true)) {
            TextRange textRange = element.getTextRange();
            HintManager.getInstance().showQuestionHint(editor, hintText, textRange.getStartOffset(), textRange.getEndOffset(), action);
        }
        return ImportClassFixBase.Result.POPUP_SHOWN;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMemberFix", "showHint"));
        }
        PsiElement callExpression = this.getElement();
        if (callExpression == null || this.getQualifierExpression() != null) {
            return false;
        }
        ImportClassFixBase.Result result = this.doFix(editor);
        return result == ImportClassFixBase.Result.POPUP_SHOWN || result == ImportClassFixBase.Result.CLASS_AUTO_IMPORTED;
    }
}

