/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.JavaProjectCodeInsightSettings;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMemberFix;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticImportMethodQuestionAction;
import com.intellij.codeInsight.daemon.impl.quickfix.StaticMembersProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.DefaultParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticImportMethodFix
extends StaticImportMemberFix<PsiMethod> {
    private final SmartPsiElementPointer<PsiMethodCallExpression> myMethodCall;

    public StaticImportMethodFix(@NotNull PsiMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "<init>"));
        }
        this.myMethodCall = SmartPointerManager.getInstance((Project)methodCallExpression.getProject()).createSmartPsiElementPointer((PsiElement)methodCallExpression);
    }

    @Override
    @NotNull
    protected String getBaseText() {
        String string = QuickFixBundle.message("static.import.method.text", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getBaseText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected String getMemberPresentableText(PsiMethod method) {
        String string = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)0);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMemberPresentableText"));
        }
        return string;
    }

    @Override
    @NotNull
    protected List<PsiMethod> getMembersToImport(boolean applicableOnly) {
        String name;
        Project project2 = this.myMethodCall.getProject();
        PsiShortNamesCache cache = PsiShortNamesCache.getInstance((Project)project2);
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        PsiReferenceExpression reference = element == null ? null : element.getMethodExpression();
        String string = name = reference == null ? null : reference.getReferenceName();
        if (name == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMembersToImport"));
            }
            return list;
        }
        MyStaticMethodProcessor processor2 = new MyStaticMethodProcessor(project2, element);
        cache.processMethodsWithName(name, element.getResolveScope(), (Processor)processor2);
        List<PsiMethod> list = processor2.getMembersToImport(applicableOnly);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "getMembersToImport"));
        }
        return list;
    }

    public static boolean isExcluded(PsiMember method) {
        String name = PsiUtil.getMemberQualifiedName((PsiMember)method);
        return name != null && JavaProjectCodeInsightSettings.getSettings(method.getProject()).isExcluded(name);
    }

    @NotNull
    protected StaticImportMethodQuestionAction<PsiMethod> createQuestionAction(List<PsiMethod> methodsToImport, @NotNull Project project2, Editor editor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "createQuestionAction"));
        }
        StaticImportMethodQuestionAction<PsiMethod> staticImportMethodQuestionAction = new StaticImportMethodQuestionAction<PsiMethod>(project2, editor, methodsToImport, this.myMethodCall);
        if (staticImportMethodQuestionAction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/StaticImportMethodFix", "createQuestionAction"));
        }
        return staticImportMethodQuestionAction;
    }

    @Override
    @Nullable
    protected PsiElement getElement() {
        return this.myMethodCall.getElement();
    }

    @Override
    @Nullable
    protected PsiElement getQualifierExpression() {
        PsiMethodCallExpression element = (PsiMethodCallExpression)this.myMethodCall.getElement();
        return element != null ? element.getMethodExpression().getQualifierExpression() : null;
    }

    @Override
    @Nullable
    protected PsiElement resolveRef() {
        PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)this.getElement();
        return methodCallExpression != null ? methodCallExpression.resolveMethod() : null;
    }

    private static class MyStaticMethodProcessor
    extends StaticMembersProcessor<PsiMethod> {
        private MyStaticMethodProcessor(Project project2, PsiMethodCallExpression place) {
            super((PsiElement)place);
        }

        @Override
        protected boolean isApplicable(PsiMethod method, PsiElement place) {
            PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance((Project)place.getProject()).getResolveHelper();
            PsiExpressionList argumentList = ((PsiMethodCallExpression)place).getArgumentList();
            PsiSubstitutor substitutorForMethod = resolveHelper.inferTypeArguments(method.getTypeParameters(), method.getParameterList().getParameters(), argumentList.getExpressions(), PsiSubstitutor.EMPTY, place.getParent(), (ParameterTypeInferencePolicy)DefaultParameterTypeInferencePolicy.INSTANCE);
            if (PsiUtil.isApplicable((PsiMethod)method, (PsiSubstitutor)substitutorForMethod, (PsiExpressionList)argumentList)) {
                PsiType returnType = substitutorForMethod.substitute(method.getReturnType());
                PsiType expectedType = this.getExpectedType();
                return expectedType == null || returnType == null || TypeConversionUtil.isAssignable((PsiType)expectedType, (PsiType)returnType);
            }
            return false;
        }
    }
}

